/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;

public class FutureForkJoin<K extends BaseFuture>
extends BaseFutureImpl
implements BaseFuture {
    private final K[] forks;
    private final int nrFutures;
    private final int nrFinishFuturesSuccess;
    private final boolean cancelFuturesOnFinish;
    private K last;
    private int counter = 0;
    private int successCounter = 0;
    private volatile boolean completedJoin = false;
    private final List<K> forksCopy;

    public FutureForkJoin(K ... forks) {
        this(forks.length, false, (BaseFuture[])forks);
    }

    public FutureForkJoin(int nrFinishFuturesSuccess, boolean cancelFuturesOnFinish, K ... forks) {
        this.nrFinishFuturesSuccess = nrFinishFuturesSuccess;
        this.forks = forks;
        int len = forks.length;
        this.forksCopy = new ArrayList<K>(len);
        for (int i = 0; i < len; ++i) {
            if (forks[i] == null) continue;
            this.forksCopy.add(forks[i]);
        }
        this.cancelFuturesOnFinish = cancelFuturesOnFinish;
        this.nrFutures = forks.length;
        if (this.nrFutures <= 0) {
            this.setFailed("We have no futures: " + this.nrFutures);
        } else {
            this.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() {
        int len = this.forks.length;
        for (int i = 0; i < len; ++i) {
            if (this.completedJoin) {
                return;
            }
            final int index = i;
            if (this.forks[index] != null) {
                this.forks[index].addListener(new BaseFutureAdapter<K>(){

                    @Override
                    public void operationComplete(K future) throws Exception {
                        FutureForkJoin.this.evaluate(future, index);
                    }
                });
                continue;
            }
            boolean notifyNow = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.completed) {
                    return;
                }
                if (++this.counter >= this.nrFutures) {
                    notifyNow = this.setFinish(null, BaseFuture.FutureType.FAILED);
                }
            }
            if (!notifyNow) continue;
            this.notifyListerenrs();
            this.cancelAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluate(K finished, int index) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return;
            }
            this.forks[index] = null;
            if (finished.isSuccess() && ++this.successCounter >= this.nrFinishFuturesSuccess) {
                notifyNow = this.setFinish(finished, BaseFuture.FutureType.OK);
            } else if (++this.counter >= this.nrFutures) {
                notifyNow = this.setFinish(finished, BaseFuture.FutureType.FAILED);
            }
        }
        if (notifyNow) {
            this.notifyListerenrs();
            this.cancelAll();
        }
    }

    private void cancelAll() {
        if (this.cancelFuturesOnFinish) {
            for (K future : this.forks) {
                if (future == null) continue;
                future.cancel();
            }
        }
    }

    protected boolean setFinish(K last, BaseFuture.FutureType type) {
        if (!this.setCompletedAndNotify()) {
            return false;
        }
        this.completedJoin = true;
        this.last = last;
        this.type = type;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailedReason() {
        Object object = this.lock;
        synchronized (object) {
            StringBuilder sb = new StringBuilder("FutureMulti:").append(this.reason).append(", type:").append((Object)this.type);
            if (this.last != null) {
                sb.append(", last:").append(this.last.getFailedReason()).append("rest:");
            }
            for (BaseFuture k : this.getAll()) {
                if (k == null) continue;
                sb.append(",").append(k.getFailedReason());
            }
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K getLast() {
        Object object = this.lock;
        synchronized (object) {
            return this.last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getAll() {
        Object object = this.lock;
        synchronized (object) {
            return this.forksCopy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSuccessCounter() {
        Object object = this.lock;
        synchronized (object) {
            return this.successCounter;
        }
    }
}

