/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;

public class FutureDHT
extends BaseFutureImpl {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private final FutureCreate<FutureDHT> futureCreate;
    private final FutureRouting futureRouting;
    private Map<PeerAddress, Collection<Number160>> rawKeys;
    private Map<PeerAddress, Map<Number160, Data>> rawData;
    private Map<PeerAddress, Object> rawObjects;
    private Map<PeerAddress, ChannelBuffer> rawChannels;
    private List<FutureResponse> pendingFutures = new ArrayList<FutureResponse>(4);
    private ScheduledFuture<?> scheduledFuture;
    private List<ScheduledFuture<?>> scheduledFutures;
    private boolean cancelSchedule = false;
    private boolean minReached;

    public FutureDHT() {
        this(0, new VotingSchemeDHT(), null, null);
    }

    public FutureDHT(int min, EvaluatingSchemeDHT evaluationScheme, FutureCreate<FutureDHT> futureCreate, FutureRouting futureRouting) {
        this.min = min;
        this.evaluationScheme = evaluationScheme;
        this.futureCreate = futureCreate;
        this.futureRouting = futureRouting;
    }

    public void created(FutureDHT futureDHT) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(futureDHT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovedKeys(Map<PeerAddress, Collection<Number160>> rawKeys) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
            int size = rawKeys.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + rawKeys.size();
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoredKeys(Map<PeerAddress, Collection<Number160>> rawKeys, boolean ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
            boolean bl = this.minReached = rawKeys.size() >= this.min;
            if (ifAbsent) {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "ok, since store if absent";
            } else {
                this.type = BaseFuture.FutureType.FAILED;
                this.reason = "Key size is zero";
                for (Collection<Number160> result : rawKeys.values()) {
                    if (result.size() <= 0) continue;
                    this.type = BaseFuture.FutureType.OK;
                    this.reason = "size ok";
                    break;
                }
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Map<PeerAddress, Map<Number160, Data>> rawData) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            int size = rawData.size();
            this.minReached = size >= this.min;
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + rawData.size();
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Collection<Number160>> getRawKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate1(this.rawKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number160, Data>> getRawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, Data> getData() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData1(Map<PeerAddress, ChannelBuffer> rawChannels) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawChannels = rawChannels;
            this.minReached = rawChannels.size() >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + this.rawData.size();
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, ChannelBuffer> getRawDirectData1() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData2(Map<PeerAddress, Object> rawObjects) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawObjects = rawObjects;
            this.minReached = rawObjects.size() >= this.min;
            this.type = this.minReached ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = this.minReached ? "Minimun number of results reached" : "Expected " + this.min + " result, but got " + this.rawData.size();
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Object> getRawDirectData2() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureCreate<FutureDHT> getFutureCreate() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureCreate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureRouting getFutureRouting() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureRouting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture, List<ScheduledFuture<?>> scheduledFutures) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduledFuture = scheduledFuture;
            this.scheduledFutures = scheduledFutures;
            if (this.cancelSchedule) {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelSchedule = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (this.scheduledFutures != null) {
                this.scheduledFutures.remove(this.scheduledFuture);
            }
        }
        super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate3(this.rawObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getChannelBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate4(this.rawChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(FutureResponse futureResponse) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingFutures.add(futureResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureForkJoin<FutureResponse> getRunningFutures() {
        Object object = this.lock;
        synchronized (object) {
            int size = this.pendingFutures.size();
            BaseFuture[] futureResponses = new FutureResponse[size];
            for (int i = 0; i < size; ++i) {
                futureResponses[i] = this.pendingFutures.get(i);
            }
            return new FutureForkJoin(futureResponses);
        }
    }
}

