/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetAddress;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;

public class IdentifierTCP
implements Comparable<IdentifierTCP> {
    public static final String DEFAULT = "default-tcp";
    private final Number160 recipientId;
    private final Number160 senderId;
    private final Number160 both;
    private final InetAddress inetAddress;
    private final String channelName;
    private final long timestamp;

    public IdentifierTCP(Number160 recipientId, Number160 senderId, InetAddress inetAddress, String channelName) {
        this.recipientId = recipientId;
        this.senderId = senderId;
        this.both = senderId.xor(recipientId);
        this.inetAddress = inetAddress;
        this.channelName = channelName;
        this.timestamp = System.currentTimeMillis();
    }

    public IdentifierTCP(PeerAddress remotePeer, PeerAddress senderPeer, String channelName) {
        this.recipientId = remotePeer.getID();
        this.senderId = senderPeer.getID();
        this.both = this.senderId.xor(this.recipientId);
        this.inetAddress = remotePeer.getInetAddress();
        this.channelName = channelName;
        this.timestamp = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.both.hashCode() ^ this.inetAddress.hashCode() ^ this.channelName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IdentifierTCP)) {
            return false;
        }
        IdentifierTCP i = (IdentifierTCP)obj;
        return i.both.equals(this.both) && i.inetAddress.equals(this.inetAddress) && i.channelName.equals(this.channelName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("recipientID:");
        sb.append(this.recipientId).append(",senderID:").append(this.senderId).append(",inet:").append(this.inetAddress).append(",name:").append(this.channelName);
        return sb.toString();
    }

    @Override
    public int compareTo(IdentifierTCP o) {
        long diff = this.timestamp - o.timestamp;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return this.recipientId.compareTo(o.recipientId);
    }
}

