/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.PeerConnection;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionReservation {
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ChannelGroup channelsTCP = new DefaultChannelGroup("TomP2P ConnectionPool TCP");
    private final ChannelGroup channelsUDP = new DefaultChannelGroup("TomP2P ConnectionPool UDP");
    private final Semaphore semaphoreCreating;
    private final Semaphore semaphoreOpen;
    private static final Logger logger = LoggerFactory.getLogger(ConnectionReservation.class);
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final MessageLogger messageLoggerFilter;
    private final int maxPermitsCreating;
    private final int maxPermitsOpen;
    private final ConcurrentMap<PeerConnection, Boolean> permanentConnections = new ConcurrentHashMap<PeerConnection, Boolean>();

    public ConnectionReservation(ChannelFactory tcpClientChannelFactory, ChannelFactory udpChannelFactory, ConnectionConfiguration configuration, MessageLogger messageLoggerFilter) {
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpChannelFactory;
        this.maxPermitsCreating = configuration.getMaxCreating();
        this.maxPermitsOpen = configuration.getMaxOpenConnection();
        this.semaphoreCreating = new Semaphore(this.maxPermitsCreating);
        this.semaphoreOpen = new Semaphore(this.maxPermitsOpen);
        this.messageLoggerFilter = messageLoggerFilter;
    }

    public ChannelCreator reserve(int permits) throws ChannelException {
        return this.reserve(permits, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelCreator reserve(int permits, boolean keepAliveAndReuse) throws ChannelException {
        if (this.shutdown.get()) {
            return null;
        }
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            logger.warn("we are blocking in a thread that could cause a deadlock: " + Thread.currentThread().getName());
            throw new RuntimeException("cannot block here");
        }
        boolean acquired = false;
        while (!acquired && !this.shutdown.get()) {
            acquired = this.semaphoreCreating.tryAcquire(permits) && this.semaphoreOpen.tryAcquire(permits);
            if (acquired) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("cannot acquire " + permits + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", but now we have " + this.semaphoreCreating.availablePermits());
            }
            Semaphore semaphore = this.semaphoreCreating;
            synchronized (semaphore) {
                try {
                    this.semaphoreCreating.wait(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (this.shutdown.get()) {
            if (acquired) {
                this.semaphoreCreating.release(permits);
                this.semaphoreOpen.release(permits);
            }
            return null;
        }
        ChannelCreator channelCreator = new ChannelCreator(this.channelsTCP, this.channelsUDP, permits, this.messageLoggerFilter, this.tcpClientChannelFactory, this.udpChannelFactory, this.shutdown, this, keepAliveAndReuse);
        return channelCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCreating(int permits) {
        this.semaphoreCreating.release(permits);
        Semaphore semaphore = this.semaphoreCreating;
        synchronized (semaphore) {
            this.semaphoreCreating.notifyAll();
        }
    }

    public void releaseOpen(int permits) {
        this.semaphoreOpen.release(permits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(int permits) {
        this.semaphoreCreating.release(permits);
        this.semaphoreOpen.release(permits);
        if (logger.isDebugEnabled()) {
            logger.debug("released " + permits + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", now we have " + this.semaphoreCreating.availablePermits());
        }
        Semaphore semaphore = this.semaphoreCreating;
        synchronized (semaphore) {
            this.semaphoreCreating.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown.set(true);
        for (PeerConnection peerConnection : this.permanentConnections.keySet()) {
            peerConnection.close();
        }
        Semaphore semaphore = this.semaphoreCreating;
        synchronized (semaphore) {
            this.semaphoreCreating.notifyAll();
        }
        this.channelsTCP.close().awaitUninterruptibly();
        this.channelsUDP.close().awaitUninterruptibly();
    }

    public void addPeerConnection(PeerConnection peerConnection) {
        this.permanentConnections.put(peerConnection, Boolean.TRUE);
    }

    public void removePeerConnection(PeerConnection peerConnection) {
        this.permanentConnections.remove(peerConnection);
    }
}

