/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.storage.Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(StorageRPC.class);

    public StorageRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.PUT, Message.Command.GET, Message.Command.ADD, Message.Command.REMOVE);
    }

    public PeerAddress getPeerAddress() {
        return this.peerBean.getServerPeerAddress();
    }

    public FutureResponse put(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator) {
        Message.Type request = Message.Type.REQUEST_1;
        if (protectDomain) {
            request = Message.Type.REQUEST_3;
        }
        return this.put(remoteNode, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator);
    }

    public FutureResponse putIfAbsent(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, boolean protectDomain, boolean protectEntry, boolean signMessage, ChannelCreator channelCreator) {
        Message.Type request = Message.Type.REQUEST_2;
        if (protectDomain) {
            request = Message.Type.REQUEST_4;
        }
        return this.put(remoteNode, locationKey, domainKey, dataMap, request, protectDomain || signMessage || protectEntry, channelCreator);
    }

    private FutureResponse put(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Map<Number160, Data> dataMap, Message.Type type, boolean signMessage, ChannelCreator channelCreator) {
        this.nullCheck(remoteNode, locationKey, domainKey, dataMap);
        Message message = this.createMessage(remoteNode, Message.Command.PUT, type);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP request = new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message);
        return request.sendTCP(channelCreator);
    }

    public FutureResponse add(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Collection<Data> dataSet, boolean protectDomain, boolean signMessage, ChannelCreator channelCreator) {
        Message.Type type = Message.Type.REQUEST_1;
        if (protectDomain) {
            type = Message.Type.REQUEST_3;
        }
        this.nullCheck(remoteNode, locationKey, domainKey, dataSet);
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>(dataSet.size());
        for (Data data : dataSet) {
            dataMap.put(data.getHash(), data);
        }
        Message message = this.createMessage(remoteNode, Message.Command.ADD, type);
        if (protectDomain || signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        message.setDataMap(dataMap);
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP request = new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message);
        return request.sendTCP(channelCreator);
    }

    public FutureResponse get(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, PublicKey protectedDomains, boolean signMessage, ChannelCreator channelCreator) {
        this.nullCheck(remoteNode, locationKey, domainKey);
        Message message = this.createMessage(remoteNode, Message.Command.GET, Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        if (protectedDomains != null) {
            message.setPublicKey(protectedDomains);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP request = new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message);
        return request.sendTCP(channelCreator);
    }

    public FutureResponse remove(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, boolean sendBackResults, boolean signMessage, ChannelCreator channelCreator) {
        this.nullCheck(remoteNode, locationKey, domainKey);
        Message message = this.createMessage(remoteNode, Message.Command.REMOVE, sendBackResults ? Message.Type.REQUEST_2 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (contentKeys != null) {
            message.setKeys(contentKeys);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        RequestHandlerTCP request = new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message);
        return request.sendTCP(channelCreator);
    }

    @Override
    public boolean checkMessage(Message message) {
        if (message.isRequest()) {
            switch (message.getCommand()) {
                case ADD: 
                case PUT: {
                    return message.getKey1() != null && message.getKey2() != null && message.getDataMap() != null;
                }
                case GET: 
                case REMOVE: {
                    return message.getKey1() != null && message.getKey2() != null;
                }
            }
        }
        return false;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("handle " + message);
        }
        Message responseMessage = this.createMessage(message.getSender(), message.getCommand(), Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        responseMessage.setMessageId(message.getMessageId());
        switch (message.getCommand()) {
            case PUT: {
                return this.handlePut(message, responseMessage, this.isStoreIfAbsent(message), this.isDomainProtected(message));
            }
            case GET: {
                return this.handleGet(message, responseMessage);
            }
            case ADD: {
                return this.handleAdd(message, responseMessage, this.isDomainProtected(message));
            }
            case REMOVE: {
                return this.handleRemove(message, responseMessage, message.getType() == Message.Type.REQUEST_2);
            }
        }
        return null;
    }

    private boolean isDomainProtected(Message message) {
        boolean protectDomain = message.getPublicKey() != null && (message.getType() == Message.Type.REQUEST_3 || message.getType() == Message.Type.REQUEST_4);
        return protectDomain;
    }

    private boolean isStoreIfAbsent(Message message) {
        boolean absent = message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_4;
        return absent;
    }

    private Message handlePut(Message message, Message responseMessage, boolean putIfAbsent, boolean protectDomain) throws IOException {
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        Map<Number160, Data> toStore = message.getDataMap();
        PublicKey publicKey = message.getPublicKey();
        if (this.peerBean.getReplicationStorage() != null) {
            this.peerBean.getReplicationStorage().updatePeerMapIfCloser(locationKey, message.getSender().getID());
        }
        HashSet<Number160> result = new HashSet<Number160>();
        for (Map.Entry<Number160, Data> entry : toStore.entrySet()) {
            if (this.peerBean.getStorage().put(new Number480(locationKey, domainKey, entry.getKey()), entry.getValue(), publicKey, putIfAbsent, protectDomain)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("put data with key " + locationKey + " on " + this.peerBean.getServerPeerAddress());
                }
                result.add(entry.getKey());
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("could not add " + locationKey + " on " + this.peerBean.getServerPeerAddress());
            }
            this.peerBean.getStorage().put(new Number480(locationKey, domainKey, entry.getKey()), entry.getValue(), publicKey, putIfAbsent, protectDomain);
        }
        if (result.size() > 0 && this.peerBean.getReplicationStorage() != null) {
            this.peerBean.getReplicationStorage().checkResponsibility(locationKey);
        }
        if (result.size() == 0 && !putIfAbsent) {
            responseMessage.setType(Message.Type.DENIED);
        } else if (result.size() == 0 && putIfAbsent) {
            responseMessage.setType(Message.Type.OK);
            responseMessage.setKeys(result);
        } else {
            responseMessage.setKeys(result);
            if (result.size() != toStore.size()) {
                responseMessage.setType(Message.Type.PARTIALLY_OK);
            }
        }
        return responseMessage;
    }

    private Message handleAdd(Message message, Message responseMessage, boolean protectDomain) {
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        Map<Number160, Data> data = message.getDataMap();
        PublicKey publicKey = message.getPublicKey();
        if (this.peerBean.getReplicationStorage() != null) {
            this.peerBean.getReplicationStorage().updatePeerMapIfCloser(locationKey, message.getSender().getID());
        }
        HashSet<Number160> result = new HashSet<Number160>();
        for (Map.Entry<Number160, Data> entry : data.entrySet()) {
            if (!this.peerBean.getStorage().put(new Number480(locationKey, domainKey, entry.getKey()), entry.getValue(), publicKey, true, protectDomain)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("add data with key " + locationKey + " on " + this.peerBean.getServerPeerAddress());
            }
            result.add(entry.getKey());
        }
        if (result.size() > 0 && this.peerBean.getReplicationStorage() != null) {
            this.peerBean.getReplicationStorage().checkResponsibility(locationKey);
        }
        responseMessage.setKeys(result);
        return responseMessage;
    }

    private Message handleGet(Message message, Message responseMessage) {
        HashMap<Number480, Data> result;
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        Collection<Number160> contentKeys = message.getKeys();
        if (contentKeys != null) {
            result = new HashMap();
            for (Number160 contentKey : contentKeys) {
                Number480 key = new Number480(locationKey, domainKey, contentKey);
                Data data = this.peerBean.getStorage().get(key);
                if (data == null) continue;
                result.put(key, data);
            }
        } else {
            result = this.peerBean.getStorage().get(new Number320(locationKey, domainKey));
        }
        responseMessage.setDataMapConvert(result);
        return responseMessage;
    }

    private Message handleRemove(Message message, Message responseMessage, boolean sendBackResults) {
        Map<Object, Object> result;
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        Collection<Number160> contentKeys = message.getKeys();
        PublicKey publicKey = message.getPublicKey();
        if (contentKeys != null) {
            result = new HashMap();
            for (Number160 contentKey : contentKeys) {
                Number480 key = new Number480(locationKey, domainKey, contentKey);
                Data data = this.peerBean.getStorage().remove(key, publicKey);
                if (data == null) continue;
                result.put(key, data);
            }
        } else {
            result = this.peerBean.getStorage().remove(new Number320(locationKey, domainKey), publicKey);
        }
        if (!sendBackResults) {
            responseMessage.setKeysConvert(result.keySet());
        } else {
            responseMessage.setDataMapConvert(result);
        }
        return responseMessage;
    }
}

