/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReplyHandler
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(ReplyHandler.class);
    final PeerBean peerBean;
    final ConnectionBean connectionBean;
    private boolean sign = false;

    public ReplyHandler(PeerBean peerBean, ConnectionBean connectionBean) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
    }

    protected void registerIoHandler(Message.Command ... names) {
        this.connectionBean.getDispatcherRequest().registerIoHandler(this.peerBean.getServerPeerAddress(), this, names);
    }

    public Message createMessage(PeerAddress recipient, Message.Command name, Message.Type type) {
        Message m = new Message();
        return m.setRecipient(recipient).setSender(this.peerBean.getServerPeerAddress()).setCommand(name).setType(type).setVersion(this.connectionBean.getP2PID());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        Message message;
        logger.equals("error in reply " + e.toString());
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        if ((message = (Message)ctx.getAttachment()) != null) {
            this.peerBean.getPeerMap().peerOffline(message.getSender(), true);
        }
        ctx.getChannel().close();
    }

    public Message forwardMessage(Message message) {
        if (this.checkMessage(message)) {
            this.peerBean.getPeerMap().peerFound(message.getSender(), message.getSender());
            try {
                Message reply = this.handleResponse(message, this.sign);
                return reply;
            }
            catch (Throwable e) {
                logger.error("Exception in custom handler: " + e.toString());
                e.printStackTrace();
            }
        }
        this.peerBean.getPeerMap().peerOffline(message.getSender(), true);
        logger.error("Check failed: " + message);
        return null;
    }

    public abstract boolean checkMessage(Message var1);

    public abstract Message handleResponse(Message var1, boolean var2) throws Exception;

    void nullCheck(Object ... objs) {
        for (Object obj : objs) {
            if (obj != null) continue;
            throw new IllegalArgumentException("Object cannot be null");
        }
    }

    public void setSignReply(boolean sign) {
        this.sign = sign;
    }
}

