/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.futures.FutureData;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.DistributedHashHashMap;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.IdentityManagement;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.p2p.P2PConfiguration;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.p2p.config.ConfigurationDirect;
import net.tomp2p.p2p.config.ConfigurationGet;
import net.tomp2p.p2p.config.ConfigurationRemove;
import net.tomp2p.p2p.config.ConfigurationStore;
import net.tomp2p.p2p.config.ConfigurationTrackerGet;
import net.tomp2p.p2p.config.ConfigurationTrackerStore;
import net.tomp2p.p2p.config.Configurations;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapKadImpl;
import net.tomp2p.replication.DefaultStorageReplication;
import net.tomp2p.replication.Replication;
import net.tomp2p.replication.TrackerStorageReplication;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.ResponsibilityMemory;
import net.tomp2p.storage.StorageMemory;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    private static final KeyPair EMPTY_KEYPAIR = new KeyPair(null, null);
    private ConnectionHandler connectionHandler;
    private final Number160 peerId;
    private final int p2pID;
    private final KeyPair keyPair;
    private DistributedHashHashMap dht;
    private DistributedTracker tracker;
    private IdentityManagement identityManagement;
    private Maintenance maintenance;
    private HandshakeRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private PeerExchangeRPC peerExchangeRPC;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private DistributedRouting routing;
    private Bindings bindings;
    private final P2PConfiguration peerConfiguration;
    private final ConnectionConfiguration connectionConfiguration;
    private ScheduledExecutorService scheduledExecutorServiceMaintenance;
    private ScheduledExecutorService scheduledExecutorServiceReplication;
    private final Map<BaseFuture, Long> pendingFutures = Collections.synchronizedMap(new CacheMap(1000));
    private boolean masterFlag = true;
    private List<ScheduledFuture<?>> scheduledFutures = Collections.synchronizedList(new ArrayList());
    private final List<PeerListener> listeners = new ArrayList<PeerListener>();
    private Timer timer;
    public static final int BLOOMFILTER_SIZE = 1024;

    public Peer(KeyPair keyPair) {
        this(Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(Number160 nodeId) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), EMPTY_KEYPAIR);
    }

    public Peer(Number160 nodeId, KeyPair keyPair) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), keyPair);
    }

    public Peer(int p2pID, KeyPair keyPair) {
        this(p2pID, Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, KeyPair keyPair) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId, ConnectionConfiguration connectionConfiguration) {
        this(p2pID, nodeId, new P2PConfiguration(), connectionConfiguration, EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, P2PConfiguration peerConfiguration, ConnectionConfiguration connectionConfiguration, KeyPair keyPair) {
        this.p2pID = p2pID;
        this.peerId = nodeId;
        this.peerConfiguration = peerConfiguration;
        this.connectionConfiguration = connectionConfiguration;
        this.keyPair = keyPair;
    }

    public void addPeerListener(PeerListener listener) {
        if (this.isRunning()) {
            listener.notifyOnStart();
        }
        this.listeners.add(listener);
    }

    public void removePeerListener() {
        this.listeners.remove(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info("shutdown in progres");
        List<ScheduledFuture<?>> list = this.scheduledFutures;
        synchronized (list) {
            for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        if (this.masterFlag && this.timer != null) {
            this.timer.stop();
        }
        if (this.masterFlag && this.scheduledExecutorServiceMaintenance != null) {
            this.scheduledExecutorServiceMaintenance.shutdownNow();
        }
        if (this.masterFlag && this.scheduledExecutorServiceReplication != null) {
            this.scheduledExecutorServiceReplication.shutdownNow();
        }
        this.getConnectionHandler().shutdown();
        for (PeerListener listener : this.listeners) {
            listener.notifyOnShutdown();
        }
        this.getPeerBean().getStorage().close();
        this.connectionHandler = null;
    }

    public void listen() throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort());
    }

    public void listen(File messageLogger) throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings());
    }

    public void listen(int udpPort, int tcpPort, File messageLogger) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort, InetAddress bind) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(bind), null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings) throws Exception {
        this.listen(udpPort, tcpPort, bindings, null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings, File messageLogger) throws Exception {
        this.masterFlag = true;
        this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS, 10);
        this.bindings = bindings;
        this.scheduledExecutorServiceMaintenance = Executors.newScheduledThreadPool(this.peerConfiguration.getMaintenanceThreads());
        this.scheduledExecutorServiceReplication = Executors.newScheduledThreadPool(this.peerConfiguration.getReplicationThreads());
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration);
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(udpPort, tcpPort, this.peerId, bindings, this.getP2PID(), this.connectionConfiguration, messageLogger, this.keyPair, peerMap, this.listeners, this.peerConfiguration), statistics);
        logger.debug("init done");
    }

    public void listen(Peer master) throws Exception {
        this.masterFlag = false;
        this.timer = master.timer;
        this.bindings = master.bindings;
        this.scheduledExecutorServiceMaintenance = master.scheduledExecutorServiceMaintenance;
        this.scheduledExecutorServiceReplication = master.scheduledExecutorServiceReplication;
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration);
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(master.getConnectionHandler(), this.peerId, this.keyPair, peerMap), statistics);
    }

    protected void init(ConnectionHandler connectionHandler, Statistics statistics) {
        this.connectionHandler = connectionHandler;
        PeerBean peerBean = connectionHandler.getPeerBean();
        peerBean.setStatistics(statistics);
        ConnectionBean connectionBean = connectionHandler.getConnectionBean();
        PeerAddress selfAddress = this.getPeerAddress();
        PeerMap peerMap = connectionHandler.getPeerBean().getPeerMap();
        ResponsibilityMemory responsibilityMemory = new ResponsibilityMemory();
        StorageMemory storage = new StorageMemory(responsibilityMemory);
        peerBean.setStorage(storage);
        Replication replicationStorage = new Replication(responsibilityMemory, selfAddress, peerMap);
        peerBean.setReplicationStorage(replicationStorage);
        this.identityManagement = new IdentityManagement(this.getPeerAddress());
        this.maintenance = new Maintenance();
        Replication replicationTracker = new Replication(new ResponsibilityMemory(), selfAddress, peerMap);
        TrackerStorage storageTracker = new TrackerStorage(this.identityManagement, this.getP2PConfiguration().getTrackerTimoutSeconds(), replicationTracker, this.maintenance);
        peerBean.setTrackerStorage(storageTracker);
        peerMap.addPeerOfflineListener(storageTracker);
        this.handshakeRCP = new HandshakeRPC(peerBean, connectionBean);
        this.storageRPC = new StorageRPC(peerBean, connectionBean);
        this.neighborRPC = new NeighborRPC(peerBean, connectionBean);
        this.quitRCP = new QuitRPC(peerBean, connectionBean);
        this.peerExchangeRPC = new PeerExchangeRPC(peerBean, connectionBean);
        this.directDataRPC = new DirectDataRPC(peerBean, connectionBean);
        TrackerStorageReplication trackerStorageReplication = new TrackerStorageReplication(this, this.peerExchangeRPC, this.pendingFutures, storageTracker);
        replicationTracker.addResponsibilityListener(trackerStorageReplication);
        this.trackerRPC = new TrackerRPC(peerBean, connectionBean);
        this.routing = new DistributedRouting(peerBean, this.neighborRPC);
        this.dht = new DistributedHashHashMap(this.routing, this.storageRPC, this.directDataRPC);
        this.tracker = new DistributedTracker(peerBean, this.routing, this.trackerRPC, this.peerExchangeRPC);
        if (this.peerConfiguration.isStartMaintenance()) {
            this.startMaintainance();
        }
        for (PeerListener listener : this.listeners) {
            listener.notifyOnStart();
        }
    }

    public void setDefaultStorageReplication() {
        Replication replicationStorage = this.getPeerBean().getReplicationStorage();
        DefaultStorageReplication defaultStorageReplication = new DefaultStorageReplication(this, this.getPeerBean().getStorage(), this.storageRPC, this.pendingFutures, this.getConnectionBean().getScheduler());
        this.scheduledFutures.add(this.addIndirectReplicaiton(defaultStorageReplication));
        replicationStorage.addResponsibilityListener(defaultStorageReplication);
    }

    public Map<BaseFuture, Long> getPendingFutures() {
        return this.pendingFutures;
    }

    public boolean isRunning() {
        return this.connectionHandler != null;
    }

    public boolean isListening() {
        if (!this.isRunning()) {
            return false;
        }
        return this.connectionHandler.isListening();
    }

    void startMaintainance() {
        this.scheduledFutures.add(this.addMaintainance(new Maintenance2(this.connectionHandler.getPeerBean().getPeerMap(), this.handshakeRCP, this.peerConfiguration)));
    }

    public void customLoggerMessage(String customMessage) {
        this.getConnectionHandler().customLoggerMessage(customMessage);
    }

    public HandshakeRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.handshakeRCP;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.storageRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.quitRCP;
    }

    public PeerExchangeRPC getPeerExchangeRPC() {
        if (this.peerExchangeRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.peerExchangeRPC;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.trackerRPC;
    }

    public DistributedRouting getRouting() {
        if (this.routing == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.routing;
    }

    public ScheduledFuture<?> addIndirectReplicaiton(Runnable runnable) {
        return this.scheduledExecutorServiceReplication.scheduleWithFixedDelay(runnable, this.peerConfiguration.getReplicationRefreshMillis(), this.peerConfiguration.getReplicationRefreshMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> addMaintainance(Runnable runnable) {
        return this.scheduledExecutorServiceMaintenance.scheduleWithFixedDelay(runnable, 0L, (this.peerConfiguration.getWaitingTimeBetweenNodeMaintenenceSeconds()[0] + 1) / 2, TimeUnit.SECONDS);
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.connectionHandler;
    }

    public DistributedHashHashMap getDHT() {
        if (this.dht == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.dht;
    }

    public DistributedTracker getTracker() {
        if (this.tracker == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.tracker;
    }

    public PeerBean getPeerBean() {
        return this.getConnectionHandler().getPeerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.getConnectionHandler().getConnectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public void setPeerMap(PeerMap peerMap) {
        this.getPeerBean().setPeerMap(peerMap);
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public PeerConnection createPeerConnection(PeerAddress destination, int idleTCPMillis) {
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(1, true);
        final PeerConnection peerConnection = new PeerConnection(destination, cc, idleTCPMillis);
        this.getConnectionBean().getReservation().addPeerConnection(peerConnection);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Peer.this.getConnectionBean().getReservation().removePeerConnection(peerConnection);
            }
        };
        peerConnection.setCloseRunner(runner);
        return peerConnection;
    }

    public FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer) {
        return this.send(remotePeer, requestBuffer, true);
    }

    public FutureData send(PeerConnection connection, ChannelBuffer requestBuffer) {
        return this.send(connection, requestBuffer, true);
    }

    public FutureData send(PeerAddress remotePeer, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(remotePeer, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    public FutureData send(PeerConnection connection, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(connection, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    private FutureData send(final PeerConnection connection, ChannelBuffer requestBuffer, boolean raw) {
        RequestHandlerTCP request = this.getDirectDataRPC().send(connection.getDestination(), requestBuffer.slice(), raw);
        request.setKeepAlive(true);
        try {
            connection.aquireSingleConnection();
        }
        catch (InterruptedException e) {
            request.getFutureResponse().setFailed("Interupted " + e);
        }
        request.sendTCP(connection.getChannelCreator(), connection.getIdleTCPMillis());
        request.getFutureResponse().addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                connection.releaseSingleConnection();
                connection.getChannelCreator().releaseCreating();
            }
        });
        return (FutureData)request.getFutureResponse();
    }

    private FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer, boolean raw) {
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            final RequestHandlerTCP request = this.getDirectDataRPC().send(remotePeer, requestBuffer.slice(), raw);
            FutureRunnable runner = new FutureRunnable(){

                @Override
                public void run() {
                    ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(1);
                    request.sendTCP(cc);
                    Utils.addReleaseListener(request.getFutureResponse(), cc, 1);
                }

                @Override
                public void failed(String reason) {
                    request.getFutureResponse().setFailed(reason);
                }
            };
            this.getConnectionBean().getScheduler().callLater(runner);
            return (FutureData)request.getFutureResponse();
        }
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(1);
        RequestHandlerTCP request = this.getDirectDataRPC().send(remotePeer, requestBuffer.slice(), raw);
        request.sendTCP(cc);
        Utils.addReleaseListener(request.getFutureResponse(), cc, 1);
        return (FutureData)request.getFutureResponse();
    }

    public FutureBootstrap bootstrapBroadcast() {
        return this.bootstrapBroadcast(this.connectionConfiguration.getDefaultPort());
    }

    public FutureBootstrap bootstrapBroadcast(int port) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureForkJoin<FutureResponse> tmp = this.pingBroadcast(port);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(final FutureForkJoin<FutureResponse> future) throws Exception {
                if (future.isSuccess()) {
                    FutureRunnable runner = new FutureRunnable(){

                        @Override
                        public void run() {
                            PeerAddress sender = ((FutureResponse)future.getLast()).getResponse().getSender();
                            ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                            bootstrapTo.add(sender);
                            result.setBootstrapTo(bootstrapTo);
                            result.waitFor(Peer.this.bootstrap(sender));
                        }

                        @Override
                        public void failed(String reason) {
                            result.setFailed(reason);
                        }
                    };
                    Peer.this.getConnectionBean().getScheduler().callLater(runner);
                } else {
                    result.setFailed("could not reach anyone with the broadcast (1)");
                }
            }
        });
        return result;
    }

    FutureForkJoin<FutureResponse> pingBroadcast(int port) {
        int size = this.bindings.getBroadcastAddresses().size();
        if (size > 0) {
            BaseFuture[] validBroadcast = new FutureResponse[size];
            if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
                throw new RuntimeException("calling from IO thread not supported yet, may cause a deadlock.");
            }
            ChannelCreator cc = this.getConnectionBean().getReservation().reserve(size);
            for (int i = 0; i < size; ++i) {
                InetAddress broadcastAddress = this.bindings.getBroadcastAddresses().get(i);
                PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                validBroadcast[i] = this.getHandshakeRPC().pingBroadcastUDP(peerAddress, cc);
                Utils.addReleaseListener(validBroadcast[i], cc, 1);
                logger.debug("ping broadcast to " + broadcastAddress);
            }
            FutureForkJoin pings = new FutureForkJoin(1, true, validBroadcast);
            return pings;
        }
        throw new IllegalArgumentException("No broadcast address found. Cannot ping nothing");
    }

    public FutureResponse ping(InetSocketAddress address) {
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            throw new RuntimeException("calling from IO thread not supported yet, may cause a deadlock.");
        }
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(1);
        FutureResponse futureResponse = this.getHandshakeRPC().pingUDP(new PeerAddress(Number160.ZERO, address), cc);
        Utils.addReleaseListener(futureResponse, cc, 1);
        return futureResponse;
    }

    public FutureBootstrap bootstrap(InetSocketAddress address) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureResponse tmp = this.ping(address);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    final PeerAddress sender = future.getResponse().getSender();
                    FutureRunnable runner = new FutureRunnable(){

                        @Override
                        public void run() {
                            ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                            bootstrapTo.add(sender);
                            result.setBootstrapTo(bootstrapTo);
                            result.waitFor(Peer.this.bootstrap(sender));
                        }

                        @Override
                        public void failed(String string) {
                            result.setFailed(string);
                        }
                    };
                    Peer.this.getConnectionBean().getScheduler().callLater(runner);
                } else {
                    result.setFailed("could not reach anyone with the broadcast (2)");
                }
            }
        });
        return result;
    }

    public FutureBootstrap bootstrap(PeerAddress peerAddress) {
        ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
        bootstrapTo.add(peerAddress);
        return this.bootstrap(peerAddress, bootstrapTo, Configurations.defaultStoreConfiguration());
    }

    public FutureBootstrap bootstrap(PeerAddress peerAddress, final Collection<PeerAddress> bootstrapTo, final ConfigurationStore config) {
        final FutureWrappedBootstrap<FutureRouting> result = new FutureWrappedBootstrap<FutureRouting>();
        result.setBootstrapTo(bootstrapTo);
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        if (this.peerConfiguration.isBehindFirewall()) {
            final ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn * 2);
            FutureDiscover futureDiscover = this.discover(peerAddress);
            futureDiscover.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureDiscover>(){

                @Override
                public void operationComplete(FutureDiscover future) throws Exception {
                    if (future.isSuccess()) {
                        FutureRouting futureBootstrap = Peer.this.routing.bootstrap(bootstrapTo, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getMaxSuccess(), config.getRoutingConfiguration().getParallel(), false, cc);
                        result.waitFor(futureBootstrap);
                        Utils.addReleaseListenerAll(futureBootstrap, cc);
                    } else {
                        result.setFailed("Network discovery failed.");
                        cc.release();
                    }
                }
            });
            return result;
        }
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn * 2);
        FutureRouting futureBootstrap = this.routing.bootstrap(bootstrapTo, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getMaxSuccess(), config.getRoutingConfiguration().getParallel(), false, cc);
        Utils.addReleaseListenerAll(futureBootstrap, cc);
        result.waitFor(futureBootstrap);
        return result;
    }

    public void setupPortForwandingUPNP(String internalHost) {
        int portTCP;
        int range = 16383;
        Random rnd = new Random();
        int portUDP = this.bindings.getOutsideUDPPort();
        if (portUDP == 0) {
            portUDP = rnd.nextInt(16383) + 49152;
            this.bindings.setOutsidePortUDP(portUDP);
        }
        if ((portTCP = this.bindings.getOutsideTCPPort()) == 0) {
            portTCP = rnd.nextInt(16383) + 49152;
            this.bindings.setOutsidePortTCP(portTCP);
        }
        try {
            this.connectionHandler.getNATUtils().mapUPNP(internalHost, this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
        }
        catch (IOException e) {
            logger.warn("cannot find UPNP devices " + e);
            try {
                boolean retVal = this.connectionHandler.getNATUtils().mapPMP(this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
                if (!retVal) {
                    logger.warn("cannot find NAT-PMP devices");
                }
            }
            catch (NatPmpException e1) {
                logger.warn("cannot find NAT-PMP devices " + e);
            }
        }
    }

    public FutureDiscover discover(final PeerAddress peerAddress) {
        final FutureDiscover futureDiscover = new FutureDiscover(this.timer, this.peerConfiguration.getDiscoverTimeoutSec());
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ")) {
            throw new RuntimeException("calling from IO thread not supported yet, may cause a deadlock.");
        }
        final ChannelCreator cc = this.getConnectionBean().getReservation().reserve(3);
        final FutureResponse futureResponseTCP = this.getHandshakeRPC().pingTCPDiscover(peerAddress, cc);
        Utils.addReleaseListener(futureResponseTCP, cc, 1);
        this.addPeerListener(new PeerListener(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void serverAddressChanged(PeerAddress peerAddress, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                } else {
                    this.changedUDP = true;
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress);
                }
            }

            @Override
            public void notifyOnStart() {
            }

            @Override
            public void notifyOnShutdown() {
            }
        });
        futureResponseTCP.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = Peer.this.getPeerBean().getServerPeerAddress();
                if (!futureResponseTCP.isSuccess()) {
                    cc.release(2);
                    futureDiscover.setFailed("FutureDiscover: We need at least the TCP connection");
                    return;
                }
                Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighbors();
                if (tmp.size() != 1) {
                    cc.release(2);
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                PeerAddress seenAs = tmp.iterator().next();
                logger.debug("I'm seen as " + seenAs + " by peer " + peerAddress);
                if (!Peer.this.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                    Peer.this.setupPortForwandingUPNP(futureResponseTCP.getResponse().getRecipient().getInetAddress().getHostAddress());
                    serverAddress = serverAddress.changePorts(Peer.this.bindings.getOutsideUDPPort(), Peer.this.bindings.getOutsideTCPPort());
                    serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                    Peer.this.getPeerBean().setServerPeerAddress(serverAddress);
                    FutureResponse fr1 = Peer.this.getHandshakeRPC().pingTCPProbe(peerAddress, cc);
                    FutureResponse fr2 = Peer.this.getHandshakeRPC().pingUDPProbe(peerAddress, cc);
                    Utils.addReleaseListener(fr1, cc, 1);
                    Utils.addReleaseListener(fr2, cc, 1);
                    return;
                }
                cc.release(2);
                futureDiscover.done(seenAs);
            }
        });
        return futureDiscover;
    }

    public FutureDHT put(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.put(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
        dataMap.put(config.getContentKey(), data);
        return this.put(locationKey, dataMap, config);
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config) {
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate(), cc);
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.schedulePut(locationKey, dataMap, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    private ScheduledFuture<?> schedulePut(final Number160 locationKey, final Map<Number160, Data> dataMap, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureDHT futureDHT2 = Peer.this.getDHT().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate(), cc);
                futureDHT.created(futureDHT2);
                Utils.addReleaseListenerAll(futureDHT2, cc);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT add(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.add(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        ArrayList<Data> dataCollection = new ArrayList<Data>();
        dataCollection.add(data);
        return this.add(locationKey, dataCollection, config);
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        if (config.getContentKey() != null && !config.getContentKey().equals(Number160.ZERO)) {
            logger.warn("Warning, setting a content key in add() does not have any effect");
        }
        if (!config.isSignMessage()) {
            for (Data data : dataCollection) {
                if (!data.isProtectedEntry()) continue;
                config.setSignMessage(true);
                break;
            }
        }
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate(), cc);
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.scheduleAdd(locationKey, dataCollection, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleAdd(final Number160 locationKey, final Collection<Data> dataCollection, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureDHT futureDHT2 = Peer.this.getDHT().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate(), cc);
                futureDHT.created(futureDHT2);
                Utils.addReleaseListenerAll(futureDHT2, cc);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT getAll(Number160 locationKey) {
        return this.get(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, null, config);
    }

    public FutureDHT get(Number160 locationKey) {
        return this.get(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.get(locationKey, keyCollection, config);
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage(), cc);
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    public FutureDHT removeAll(Number160 locationKey) {
        return this.remove(locationKey, null, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config) {
        return this.remove(locationKey, null, config);
    }

    public FutureDHT remove(Number160 locationKey) {
        return this.remove(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.remove(locationKey, keyCollection, config);
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config) {
        if (keyCollection != null) {
            for (Number160 contentKey : keyCollection) {
                this.getPeerBean().getStorage().remove(new Number480(locationKey, config.getDomain(), contentKey), this.keyPair.getPublic());
            }
        } else {
            this.getPeerBean().getStorage().remove(new Number320(locationKey, config.getDomain()), this.keyPair.getPublic());
        }
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.getFutureCreate(), cc);
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleRemove(locationKey, keyCollection, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleRemove(final Number160 locationKey, final Set<Number160> keyCollection, final ConfigurationRemove config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureDHT futureDHT2 = Peer.this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.getFutureCreate(), cc);
                futureDHT.created(futureDHT2);
                Utils.addReleaseListenerAll(futureDHT2, cc);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, buffer, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, true, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), cc);
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    public FutureDHT send(Number160 locationKey, Object object) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, object, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        byte[] me = Utils.encodeJavaObject(object);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])me);
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), cc);
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureDHT, cc);
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleSend(final Number160 locationKey, final ChannelBuffer buffer, final ConfigurationDirect config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureDHT futureDHT2 = Peer.this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), cc);
                futureDHT.created(futureDHT2);
                Utils.addReleaseListenerAll(futureDHT2, cc);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config) {
        return this.getFromTracker(locationKey, config, new SimpleBloomFilter<Number160>(1024, 200));
    }

    public FutureTracker getFromTrackerCreateBloomfilter1(Number160 locationKey, ConfigurationTrackerGet config, Collection<PeerAddress> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (PeerAddress peerAddress : knownPeers) {
                bloomFilter.add(peerAddress.getID());
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTrackerCreateBloomfilter2(Number160 locationKey, ConfigurationTrackerGet config, Collection<Number160> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (Number160 number160 : knownPeers) {
                bloomFilter.add(number160);
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config, Set<Number160> knownPeers) {
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureTracker futureTracker = this.getTracker().getFromTracker(locationKey, config.getDomain(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isExpectAttachement(), config.getEvaluationScheme(), config.isSignMessage(), config.isUseSecondaryTrackers(), knownPeers, cc);
        Utils.addReleaseListenerAll(futureTracker, cc);
        return futureTracker;
    }

    public FutureTracker addToTracker(Number160 locationKey, ConfigurationTrackerStore config) {
        ScheduledFuture<?> tmp;
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
        this.getPeerBean().getTrackerStorage().put(locationKey, config.getDomain(), this.getPeerAddress(), this.getPeerBean().getKeyPair().getPublic(), config.getAttachement());
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        ChannelCreator cc = this.getConnectionBean().getReservation().reserve(conn);
        FutureTracker futureTracker = this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, cc);
        if (this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() > 0) {
            tmp = this.scheduleAddTracker(locationKey, config, futureTracker);
            futureTracker.setScheduledFuture(tmp, this.scheduledFutures);
        }
        if (config.getWaitBeforeNextSendSeconds() > 0) {
            tmp = this.schedulePeerExchange(locationKey, config, futureTracker);
            futureTracker.setScheduledFuture(tmp, this.scheduledFutures);
        }
        Utils.addReleaseListenerAll(futureTracker, cc);
        return futureTracker;
    }

    private ScheduledFuture<?> scheduleAddTracker(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureTracker futureTracker2 = Peer.this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, cc);
                futureTracker.repeated(futureTracker2);
                Utils.addReleaseListenerAll(futureTracker2, cc);
            }
        };
        int refresh = this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() * 3 / 4;
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    private ScheduledFuture<?> schedulePeerExchange(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(35);
                FutureForkJoin<FutureResponse> futureForkJoin = Peer.this.getTracker().startPeerExchange(locationKey, config.getDomain(), cc);
                futureTracker.repeated(futureForkJoin);
                Utils.addReleaseListenerAll(futureForkJoin, cc);
            }
        };
        int refresh = config.getWaitBeforeNextSendSeconds();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public P2PConfiguration getP2PConfiguration() {
        return this.peerConfiguration;
    }

    private class Maintenance2
    implements Runnable {
        final int max;
        final Map<PeerAddress, FutureResponse> result = new HashMap<PeerAddress, FutureResponse>();
        private final PeerMap peerMap;
        private final HandshakeRPC handshakeRPC;

        public Maintenance2(PeerMap peerMap, HandshakeRPC handshakeRPC, P2PConfiguration config) {
            this.peerMap = peerMap;
            this.handshakeRPC = handshakeRPC;
            this.max = config.getMaintenanceThreads();
        }

        @Override
        public void run() {
            Collection<PeerAddress> nas = this.peerMap.peersForMaintenance();
            if (logger.isDebugEnabled()) {
                logger.debug("numbe of peers for maintenance: " + nas.size());
            }
            for (PeerAddress na : nas) {
                ChannelCreator cc = Peer.this.getConnectionBean().getReservation().reserve(1);
                FutureResponse futureResponse = this.handshakeRPC.pingUDP(na, cc);
                Utils.addReleaseListener(futureResponse, cc, 1);
                this.result.put(na, futureResponse);
                if (this.result.size() >= this.max && !this.waitFor()) {
                    this.cleanUp();
                    return;
                }
                if (!Thread.interrupted()) continue;
                this.cleanUp();
                return;
            }
            if (!this.waitFor()) {
                this.cleanUp();
                return;
            }
        }

        private void cleanUp() {
            for (FutureResponse futureResponse : this.result.values()) {
                futureResponse.cancel();
            }
        }

        private boolean waitFor() {
            try {
                for (Map.Entry<PeerAddress, FutureResponse> entry : this.result.entrySet()) {
                    entry.getValue().await();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Maintenance: peer " + entry.getKey() + " online=" + entry.getValue());
                }
                this.result.clear();
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

