/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedRouting {
    private static final Logger logger = LoggerFactory.getLogger(DistributedRouting.class);
    private final NeighborRPC neighbors;
    private final PeerBean peerBean;

    public DistributedRouting(PeerBean peerBean, NeighborRPC neighbors) {
        this.neighbors = neighbors;
        this.peerBean = peerBean;
    }

    public FutureRouting bootstrap(Collection<PeerAddress> peerAddresses, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, boolean forceSocket, ChannelCreator cc) {
        if (logger.isDebugEnabled()) {
            logger.debug("broadcast to " + peerAddresses);
        }
        FutureRouting futureRouting = this.routing(peerAddresses, this.peerBean.getServerPeerAddress().getID(), null, null, 0, maxNoNewInfo, maxFailures, maxSuccess, parallel, Message.Command.NEIGHBORS_STORAGE, false, forceSocket, cc);
        return futureRouting;
    }

    public FutureRouting route(Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, Message.Command command, int maxDirectHits, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, boolean isDigest, ChannelCreator cc) {
        return this.route(locationKey, domainKey, contentKeys, command, maxDirectHits, maxNoNewInfo, maxFailures, maxSuccess, parallel, isDigest, false, cc);
    }

    FutureRouting route(Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, Message.Command command, int maxDirectHits, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, boolean isDigest, boolean forceSocket, ChannelCreator cc) {
        SortedSet<PeerAddress> startPeers = this.peerBean.getPeerMap().closePeers(locationKey, parallel * 2);
        return this.routing(startPeers, locationKey, domainKey, contentKeys, maxDirectHits, maxNoNewInfo, maxFailures, maxSuccess, parallel, command, isDigest, forceSocket, cc);
    }

    private FutureRouting routing(Collection<PeerAddress> peerAddresses, Number160 locationKey, Number160 domainKey, Collection<Number160> contentKeys, int maxDirectHits, int maxNoNewInfo, int maxFailures, int maxSuccess, int parallel, Message.Command command, boolean isDigest, boolean forceSocket, ChannelCreator cc) {
        DigestInfo digestInfo;
        if (peerAddresses == null) {
            throw new IllegalArgumentException("you need to specify some nodes");
        }
        if (locationKey == null) {
            throw new IllegalArgumentException("location key cannot be null");
        }
        FutureResponse[] futureResponses = new FutureResponse[parallel];
        FutureRouting futureRouting = new FutureRouting();
        Comparator<PeerAddress> comparator = this.peerBean.getPeerMap().createPeerComparator(locationKey);
        TreeSet<PeerAddress> queueToAsk = new TreeSet<PeerAddress>(comparator);
        TreeSet<PeerAddress> alreadyAsked = new TreeSet<PeerAddress>(comparator);
        TreeSet<PeerAddress> directHits = new TreeSet<PeerAddress>(this.peerBean.getPeerMap().createPeerComparator());
        TreeSet<PeerAddress> potentialHits = new TreeSet<PeerAddress>(comparator);
        queueToAsk.addAll(peerAddresses);
        alreadyAsked.add(this.peerBean.getServerPeerAddress());
        potentialHits.add(this.peerBean.getServerPeerAddress());
        if (command == Message.Command.NEIGHBORS_STORAGE && domainKey != null) {
            DigestInfo digestInfo2 = Utils.digest(this.peerBean.getStorage(), locationKey, domainKey, contentKeys);
            if (digestInfo2.getSize() > 0) {
                directHits.add(this.peerBean.getServerPeerAddress());
            }
        } else if (command == Message.Command.NEIGHBORS_TRACKER && (digestInfo = Utils.digest(this.peerBean.getTrackerStorage(), locationKey, domainKey, contentKeys)).getSize() > 0) {
            directHits.add(this.peerBean.getServerPeerAddress());
        }
        if (peerAddresses.size() == 0) {
            futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked);
        } else {
            this.routingRec(futureResponses, futureRouting, queueToAsk, alreadyAsked, directHits, potentialHits, new AtomicInteger(0), new AtomicInteger(0), new AtomicInteger(0), maxDirectHits, maxNoNewInfo, maxFailures, maxSuccess, parallel, locationKey, domainKey, contentKeys, true, command, isDigest, forceSocket, false, cc);
        }
        return futureRouting;
    }

    private void routingRec(final FutureResponse[] futureResponses, final FutureRouting futureRouting, final SortedSet<PeerAddress> queueToAsk, final SortedSet<PeerAddress> alreadyAsked, final SortedSet<PeerAddress> directHits, final SortedSet<PeerAddress> potentialHits, final AtomicInteger nrNoNewInfo, final AtomicInteger nrFailures, final AtomicInteger nrSuccess, final int maxDirectHits, final int maxNoNewInfo, final int maxFailures, final int maxSucess, final int parallel, final Number160 locationKey, final Number160 domainKey, final Collection<Number160> contentKeys, final boolean cancelOnFinish, final Message.Command command, final boolean isDigest, final boolean forceSocket, boolean stopCreatingNewFutures, final ChannelCreator cc) {
        int active = 0;
        for (int i = 0; i < parallel; ++i) {
            if (futureResponses[i] == null && !stopCreatingNewFutures) {
                PeerAddress next = Utils.pollFirst(queueToAsk);
                if (next == null) continue;
                alreadyAsked.add(next);
                ++active;
                futureResponses[i] = this.neighbors.closeNeighbors(next, locationKey, domainKey, contentKeys, command, isDigest, forceSocket, cc);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("get close neighbors: " + next);
                continue;
            }
            if (futureResponses[i] == null) continue;
            ++active;
        }
        if (active == 0) {
            futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked);
            DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
            return;
        }
        final boolean last = active == 1;
        FutureForkJoin fp = new FutureForkJoin(1, false, (BaseFuture[])futureResponses);
        fp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                boolean stopCreatingNewFutures;
                boolean finished;
                if (future.isSuccess()) {
                    Map<Number160, Number160> keyMap;
                    long contentLength;
                    Message lastResponse = future.getLast().getResponse();
                    PeerAddress remotePeer = lastResponse.getSender();
                    potentialHits.add(remotePeer);
                    Collection<PeerAddress> newNeighbors = lastResponse.getNeighbors();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Peer " + remotePeer + " reported " + newNeighbors);
                    }
                    if (DistributedRouting.evaluateDirectHits(contentLength = (long)lastResponse.getInteger(), keyMap = lastResponse.getKeyMap(), remotePeer, directHits, maxDirectHits)) {
                        finished = true;
                        stopCreatingNewFutures = true;
                    } else if (nrSuccess.incrementAndGet() > maxSucess) {
                        finished = last;
                        stopCreatingNewFutures = true;
                    } else if (DistributedRouting.evaluateInformation(newNeighbors, queueToAsk, alreadyAsked, nrNoNewInfo, maxNoNewInfo)) {
                        finished = last;
                        stopCreatingNewFutures = true;
                    } else {
                        finished = false;
                        stopCreatingNewFutures = false;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Routing finished " + finished);
                    }
                } else {
                    stopCreatingNewFutures = finished = nrFailures.incrementAndGet() > maxFailures;
                }
                if (finished) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("finished routing, direct hits: " + directHits + ", potential: " + potentialHits);
                    }
                    futureRouting.setNeighbors(directHits, potentialHits, alreadyAsked);
                    DistributedRouting.cancel(cancelOnFinish, parallel, futureResponses);
                } else {
                    DistributedRouting.this.routingRec(futureResponses, futureRouting, queueToAsk, alreadyAsked, directHits, potentialHits, nrNoNewInfo, nrFailures, nrSuccess, maxDirectHits, maxNoNewInfo, maxFailures, maxSucess, parallel, locationKey, domainKey, contentKeys, cancelOnFinish, command, isDigest, forceSocket, stopCreatingNewFutures, cc);
                }
            }
        });
    }

    static void cancel(boolean cancelOnFinish, int parallel, FutureResponse[] futureResponses) {
        if (cancelOnFinish) {
            for (int i = 0; i < parallel; ++i) {
                if (futureResponses[i] == null) continue;
                futureResponses[i].cancel();
            }
        }
    }

    static boolean evaluateDirectHits(long contentLength, Map<Number160, Number160> keyMap, PeerAddress recipient, Collection<PeerAddress> directHits, int maxDirectHits) {
        if (contentLength > 0L) {
            directHits.add(recipient);
            if (directHits.size() >= maxDirectHits) {
                return true;
            }
        }
        return false;
    }

    static boolean evaluateInformation(Collection<PeerAddress> newNeighbors, SortedSet<PeerAddress> queueToAsk, Set<PeerAddress> alreadyAsked, AtomicInteger noNewInfo, int maxNoNewInfo) {
        boolean newInformation = DistributedRouting.merge(queueToAsk, newNeighbors, alreadyAsked);
        if (newInformation) {
            noNewInfo.set(0);
            return false;
        }
        return noNewInfo.incrementAndGet() >= maxNoNewInfo;
    }

    static boolean merge(SortedSet<PeerAddress> queueToAsk, Collection<PeerAddress> newNeighbors, Set<PeerAddress> alreadyAsked) {
        TreeSet<PeerAddress> result = new TreeSet<PeerAddress>(queueToAsk.comparator());
        Utils.difference(newNeighbors, alreadyAsked, result);
        if (result.size() == 0) {
            return false;
        }
        PeerAddress first = (PeerAddress)result.first();
        boolean newInfo = DistributedRouting.isNew(queueToAsk, first);
        queueToAsk.addAll(result);
        return newInfo;
    }

    static boolean isNew(SortedSet<PeerAddress> queueToAsk, PeerAddress first) {
        if (queueToAsk.contains(first)) {
            return false;
        }
        SortedSet<PeerAddress> tmp = queueToAsk.headSet(first);
        return tmp.size() == 0;
    }
}

