/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.tomp2p.message.DataInput;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.ProtocolChunkedInput;
import net.tomp2p.message.SHA1Signature;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerData;
import org.jboss.netty.buffer.ChannelBuffer;

public class MessageCodec {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int MAX_BYTE = 255;
    public static final int HEADER_SIZE = 56;

    public static ChannelBuffer encodeHeader(ChannelBuffer buffer, Message message) {
        buffer.writeInt(message.getVersion());
        buffer.writeInt(message.getMessageId());
        buffer.writeByte(message.getType().ordinal() << 4 | message.getCommand().ordinal());
        buffer.writeBytes(message.getSender().getID().toByteArray());
        buffer.writeShort((int)((short)message.getSender().portTCP()));
        buffer.writeShort((int)((short)message.getSender().portUDP()));
        buffer.writeBytes(message.getRecipient().getID().toByteArray());
        int content = message.getContentType4().ordinal() << 12 | message.getContentType3().ordinal() << 8 | message.getContentType2().ordinal() << 4 | message.getContentType1().ordinal();
        buffer.writeShort((int)((short)content));
        int options = message.getSender().getOptions() << 4 | message.getOptions();
        buffer.writeByte(options);
        return buffer;
    }

    public static void encodePayload(Message message, ProtocolChunkedInput input) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        int contentLength = 0;
        if (message.getContentType1() != Message.Content.EMPTY) {
            contentLength += MessageCodec.encodePayloadType(message.getContentType1(), input, message);
            if (message.getContentType2() != Message.Content.EMPTY) {
                contentLength += MessageCodec.encodePayloadType(message.getContentType2(), input, message);
                if (message.getContentType3() != Message.Content.EMPTY) {
                    contentLength += MessageCodec.encodePayloadType(message.getContentType3(), input, message);
                    if (message.getContentType4() != Message.Content.EMPTY) {
                        contentLength += MessageCodec.encodePayloadType(message.getContentType4(), input, message);
                    }
                }
            }
        }
        if (message.isHintSign()) {
            input.addMarkerForSignature();
        } else {
            input.flush(true);
        }
        message.setLength(contentLength);
    }

    private static int encodePayloadType(Message.Content content, ProtocolChunkedInput input, Message message) {
        switch (content) {
            case KEY: {
                input.copyToCurrent(message.getKey3().toByteArray());
                return 20;
            }
            case KEY_KEY: {
                input.copyToCurrent(message.getKey1().toByteArray());
                input.copyToCurrent(message.getKey2().toByteArray());
                return 40;
            }
            case MAP_KEY_DATA: {
                int count = 4;
                if (message.isConvertNumber480to160()) {
                    Map<Number480, Data> dataMap = message.getDataMapConvert();
                    input.copyToCurrent(dataMap.size());
                    for (Map.Entry<Number480, Data> entry : dataMap.entrySet()) {
                        input.copyToCurrent(entry.getKey().getContentKey().toByteArray());
                        count += 20;
                        count += MessageCodec.encodeData(input, message, entry.getValue());
                    }
                    return count;
                }
                input.copyToCurrent(message.getDataMap().size());
                for (Map.Entry<Number160, Data> entry : message.getDataMap().entrySet()) {
                    input.copyToCurrent(entry.getKey().toByteArray());
                    count += 20;
                    count += MessageCodec.encodeData(input, message, entry.getValue());
                }
                return count;
            }
            case MAP_KEY_KEY: {
                Map<Number160, Number160> keyMap = message.getKeyMap();
                int size = keyMap.size();
                input.copyToCurrent(size);
                for (Map.Entry<Number160, Number160> entry : keyMap.entrySet()) {
                    input.copyToCurrent(entry.getKey().toByteArray());
                    input.copyToCurrent(entry.getValue().toByteArray());
                }
                return 4 + size * 40;
            }
            case SET_KEYS: {
                if (message.isConvertNumber480to160()) {
                    Collection<Number480> keys = message.getKeysConvert();
                    int size = keys.size();
                    input.copyToCurrent(size);
                    for (Number480 key : keys) {
                        input.copyToCurrent(key.getContentKey().toByteArray());
                    }
                    return 4 + size * 20;
                }
                int size = message.getKeys().size();
                input.copyToCurrent(size);
                for (Number160 key : message.getKeys()) {
                    input.copyToCurrent(key.toByteArray());
                }
                return 4 + size * 20;
            }
            case SET_NEIGHBORS: {
                int count = 1;
                int size = Math.min(message.getNeighbors().size(), Math.min(message.getUseAtMostNeighbors(), 255));
                input.copyToCurrent((byte)size);
                Iterator<PeerAddress> iterator = message.getNeighbors().iterator();
                for (int i = 0; iterator.hasNext() && i < size; ++i) {
                    byte[] data1 = iterator.next().toByteArray();
                    input.copyToCurrent(data1);
                    count += data1.length;
                }
                return count;
            }
            case SET_TRACKER_DATA: {
                int count = 1;
                Collection<TrackerData> trackerDatas = message.getTrackerData();
                input.copyToCurrent((byte)trackerDatas.size());
                for (TrackerData trackerData : trackerDatas) {
                    byte[] data1 = trackerData.getPeerAddress().toByteArray();
                    input.copyToCurrent(data1);
                    count += data1.length;
                    if (trackerData.getAttachement() != null) {
                        input.copyToCurrent((byte)1);
                        input.copyToCurrent(trackerData.getLength());
                        count += 5;
                        input.copyToCurrent(trackerData.getAttachement(), trackerData.getOffset(), trackerData.getLength());
                        count += trackerData.getLength();
                        continue;
                    }
                    input.copyToCurrent((byte)0);
                    ++count;
                }
                return count;
            }
            case CHANNEL_BUFFER: {
                ChannelBuffer tmpBuffer = message.getPayload1();
                if (tmpBuffer == null) {
                    tmpBuffer = message.getPayload2();
                } else {
                    message.setPayload1(null);
                }
                int size = tmpBuffer.writerIndex();
                input.copyToCurrent(size);
                input.copyToCurrent(tmpBuffer.slice());
                return 4 + size;
            }
            case LONG: {
                input.copyToCurrent(message.getLong());
                return 8;
            }
            case INTEGER: {
                input.copyToCurrent(message.getInteger());
                return 4;
            }
            case PUBLIC_KEY: {
                byte[] data = message.getPublicKey().getEncoded();
                int size = data.length;
                input.copyToCurrent((short)size);
                input.copyToCurrent(data);
                return 2 + size;
            }
            case PUBLIC_KEY_SIGNATURE: {
                byte[] data = message.getPublicKey().getEncoded();
                int size = data.length;
                input.copyToCurrent((short)size);
                input.copyToCurrent(data);
                message.setHintSign(true);
                return 42 + size;
            }
        }
        return 0;
    }

    public static int encodeData(ProtocolChunkedInput input, Message message, Data data) {
        int count = 8;
        int seconds = data.getTTLSeconds();
        seconds = data.isProtectedEntry() ? seconds | Integer.MIN_VALUE : seconds & Integer.MAX_VALUE;
        input.copyToCurrent(seconds);
        input.copyToCurrent(data.getLength());
        input.copyToCurrent(data.getData(), data.getOffset(), data.getLength());
        return count += data.getLength();
    }

    public static Message decodeHeader(ChannelBuffer buffer, InetSocketAddress recipient, InetSocketAddress sender) throws DecoderException {
        Message message = new Message();
        message.setVersion(buffer.readInt());
        message.setMessageId(buffer.readInt());
        short typeCommand = buffer.readUnsignedByte();
        message.setType(Message.Type.values()[typeCommand >>> 4]);
        message.setCommand(Message.Command.values()[typeCommand & 0xF]);
        Number160 senderID = MessageCodec.readID(buffer);
        int portTCP = buffer.readUnsignedShort();
        int portUDP = buffer.readUnsignedShort();
        Number160 recipientID = MessageCodec.readID(buffer);
        message.setRecipient(new PeerAddress(recipientID, recipient));
        int contentType = buffer.readUnsignedShort();
        message.setContentType(Message.Content.values()[contentType & 0xF], Message.Content.values()[contentType >>> 4 & 0xF], Message.Content.values()[contentType >>> 8 & 0xF], Message.Content.values()[contentType >>> 12]);
        short senderMessageOptions = buffer.readUnsignedByte();
        int senderOptions = senderMessageOptions >>> 4;
        PeerAddress peerAddress = new PeerAddress(senderID, sender.getAddress(), portTCP, portUDP, senderOptions);
        message.setSender(peerAddress);
        int options = senderMessageOptions & 0xF;
        message.setOptions(options);
        return message;
    }

    public static boolean decodePayload(Message.Content content, ChannelBuffer buffer, Message message) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, InvalidKeySpecException, IOException, DecoderException {
        switch (content) {
            case KEY: {
                if (buffer.readableBytes() < 20) {
                    return false;
                }
                message.setKey0(MessageCodec.readID(buffer));
                return true;
            }
            case KEY_KEY: {
                if (buffer.readableBytes() < 40) {
                    return false;
                }
                message.setKeyKey0(MessageCodec.readID(buffer), MessageCodec.readID(buffer));
                return true;
            }
            case MAP_KEY_DATA: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int size = buffer.readInt();
                HashMap<Number160, Data> result = new HashMap<Number160, Data>(size);
                for (int i = 0; i < size; ++i) {
                    if (buffer.readableBytes() < 20) {
                        return false;
                    }
                    Number160 key = MessageCodec.readID(buffer);
                    Data data = MessageCodec.decodeData(new ChannelDecoder(buffer), message.getSender());
                    if (data == null) {
                        return false;
                    }
                    if (message.isRequest()) {
                        if (data.isProtectedEntry() && message.getPublicKey() == null) {
                            throw new DecoderException("You indicated that you want to protect the data, but you did not provide or provided too late a public key.");
                        }
                        data.setPublicKey(message.getPublicKey());
                    }
                    result.put(key, data);
                }
                message.setDataMap0(result);
                return true;
            }
            case MAP_KEY_KEY: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < 40 * len) {
                    return false;
                }
                HashMap<Number160, Number160> keyMap = new HashMap<Number160, Number160>();
                for (int i = 0; i < len; ++i) {
                    Number160 key1 = MessageCodec.readID(buffer);
                    Number160 key2 = MessageCodec.readID(buffer);
                    keyMap.put(key1, key2);
                }
                message.setKeyMap0(keyMap);
                return true;
            }
            case SET_KEYS: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < 20 * len) {
                    return false;
                }
                ArrayList<Number160> tmp = new ArrayList<Number160>(len);
                for (int i = 0; i < len; ++i) {
                    Number160 key = MessageCodec.readID(buffer);
                    tmp.add(key);
                }
                message.setKeys0(tmp);
                return true;
            }
            case SET_NEIGHBORS: {
                if (buffer.readableBytes() < 1) {
                    return false;
                }
                int len = buffer.readUnsignedByte();
                if (buffer.readableBytes() < len * 29) {
                    return false;
                }
                ArrayList<PeerAddress> neighbors = new ArrayList<PeerAddress>(len);
                for (int i = 0; i < len; ++i) {
                    PeerAddress peerAddress = MessageCodec.readPeerAddress(buffer);
                    if (peerAddress == null) {
                        return false;
                    }
                    neighbors.add(peerAddress);
                }
                message.setNeighbors0(neighbors);
                return true;
            }
            case SET_TRACKER_DATA: {
                if (buffer.readableBytes() < 1) {
                    return false;
                }
                int len = buffer.readUnsignedByte();
                if (buffer.readableBytes() < len * 30) {
                    return false;
                }
                ArrayList<TrackerData> trackerDatas = new ArrayList<TrackerData>(len);
                for (int i = 0; i < len; ++i) {
                    PeerAddress peerAddress = MessageCodec.readPeerAddress(buffer);
                    if (peerAddress == null) {
                        return false;
                    }
                    byte[] attachment = null;
                    int offset = 0;
                    int length = 0;
                    if (buffer.readableBytes() < 1) {
                        return false;
                    }
                    byte miniHeader = buffer.readByte();
                    if (miniHeader != 0) {
                        if (buffer.readableBytes() < 4) {
                            return false;
                        }
                        length = buffer.readInt();
                        if (buffer.readableBytes() < length) {
                            return false;
                        }
                        attachment = new byte[length];
                        buffer.readBytes(attachment);
                    }
                    trackerDatas.add(new TrackerData(peerAddress, message.getSender(), attachment, offset, length));
                }
                message.setTrackerData0(trackerDatas);
                return true;
            }
            case CHANNEL_BUFFER: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                int len = buffer.readInt();
                if (buffer.readableBytes() < len) {
                    return false;
                }
                ChannelBuffer tmpBuffer = buffer.slice(buffer.readerIndex(), len);
                buffer.skipBytes(len);
                message.setPayload0(tmpBuffer);
                return true;
            }
            case LONG: {
                if (buffer.readableBytes() < 8) {
                    return false;
                }
                message.setLong0(buffer.readLong());
                return true;
            }
            case INTEGER: {
                if (buffer.readableBytes() < 4) {
                    return false;
                }
                message.setInteger0(buffer.readInt());
                return true;
            }
            case PUBLIC_KEY: 
            case PUBLIC_KEY_SIGNATURE: {
                if (buffer.readableBytes() < 2) {
                    return false;
                }
                int len = buffer.readUnsignedShort();
                byte[] me = new byte[len];
                if (buffer.readableBytes() < len) {
                    return false;
                }
                message.setPublicKey0(MessageCodec.decodePublicKey(new ChannelDecoder(buffer), me));
                if (content == Message.Content.PUBLIC_KEY_SIGNATURE) {
                    message.setHintSign(true);
                }
                return true;
            }
        }
        return true;
    }

    public static Data decodeData(DataInput buffer, PeerAddress originator) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        if (buffer.readableBytes() < 8) {
            return null;
        }
        int ttl = buffer.readInt();
        boolean protectedEntry = (ttl & Integer.MIN_VALUE) != 0;
        ttl &= Integer.MAX_VALUE;
        int dateLength = buffer.readInt();
        if (buffer.readableBytes() < dateLength) {
            return null;
        }
        Data data = MessageCodec.createData(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), dateLength, ttl, protectedEntry, originator);
        buffer.skipBytes(dateLength);
        return data;
    }

    public static Data createData(byte[] me, int offset, int length, int ttl, boolean protectedEntry, PeerAddress originator) {
        Data data;
        if (length == 0) {
            data = new Data(EMPTY_BYTE_ARRAY, originator);
        } else {
            boolean copy = true;
            byte[] me2 = new byte[length];
            System.arraycopy(me, offset, me2, 0, length);
            data = new Data(me2, 0, length, originator);
        }
        data.setTTLSeconds(ttl);
        data.setProtectedEntry(protectedEntry);
        return data;
    }

    private static Number160 readID(ChannelBuffer buffer) {
        byte[] me = new byte[20];
        buffer.readBytes(me);
        return new Number160(me);
    }

    private static PeerAddress readPeerAddress(ChannelBuffer buffer) {
        if (buffer.readableBytes() < 21) {
            return null;
        }
        Number160 id = MessageCodec.readID(buffer);
        short type = buffer.getUnsignedByte(buffer.readerIndex());
        int len = PeerAddress.expectedSocketLength(type);
        if (buffer.readableBytes() < len) {
            return null;
        }
        PeerAddress peerAddress = new PeerAddress(id, buffer.array(), buffer.arrayOffset() + buffer.readerIndex());
        buffer.skipBytes(len);
        return peerAddress;
    }

    public static PublicKey decodePublicKey(DataInput buffer, byte[] receivedRawPublicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        buffer.readBytes(receivedRawPublicKey);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(receivedRawPublicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey receivedPublicKey = keyFactory.generatePublic(pubKeySpec);
        return receivedPublicKey;
    }

    public static boolean decodeSignature(Signature signature, Message message, ChannelBuffer buffer) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException, IOException {
        Number160 number2;
        if (buffer.readableBytes() < 40) {
            return false;
        }
        Number160 number1 = MessageCodec.readID(buffer);
        SHA1Signature signatureEncode = new SHA1Signature(number1, number2 = MessageCodec.readID(buffer));
        byte[] signatureReceived = signatureEncode.encode();
        if (!signature.verify(signatureReceived)) {
            message.setPublicKey0(null);
        }
        return true;
    }

    private static class ChannelDecoder
    implements DataInput {
        private final ChannelBuffer buffer;

        private ChannelDecoder(ChannelBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public byte[] array() {
            return this.buffer.array();
        }

        @Override
        public int arrayOffset() {
            return this.buffer.arrayOffset();
        }

        @Override
        public void readBytes(byte[] buf) {
            this.buffer.readBytes(buf);
        }

        @Override
        public int readInt() {
            return this.buffer.readInt();
        }

        @Override
        public int readUnsignedByte() {
            return this.buffer.readUnsignedByte();
        }

        @Override
        public int getUnsignedByte() {
            return this.buffer.getUnsignedByte(this.buffer.readerIndex());
        }

        @Override
        public int readUnsignedShort() {
            return this.buffer.readUnsignedShort();
        }

        @Override
        public int readerIndex() {
            return this.buffer.readerIndex();
        }

        @Override
        public void skipBytes(int size) {
            this.buffer.skipBytes(size);
        }

        @Override
        public int readableBytes() {
            return this.buffer.readableBytes();
        }
    }
}

