/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.VotingSchemeTracker;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.TrackerData;

public class FutureTracker
extends BaseFutureImpl {
    private final EvaluatingSchemeTracker evaluatingSchemeTracker;
    private final Set<Number160> knownPeers;
    private volatile FutureCreate<BaseFuture> futureCreate;
    private Set<PeerAddress> potentialTrackers;
    private Set<PeerAddress> directTrackers;
    private Map<PeerAddress, Collection<TrackerData>> peersOnTracker;
    private ScheduledFuture<?> scheduledFuture;
    private List<ScheduledFuture<?>> scheduledFutures;
    private boolean cancelSchedule = false;

    public FutureTracker() {
        this(new VotingSchemeTracker(), null);
    }

    public FutureTracker(EvaluatingSchemeTracker evaluatingSchemeTracker, Set<Number160> knownPeers) {
        this.evaluatingSchemeTracker = evaluatingSchemeTracker;
        this.knownPeers = knownPeers;
    }

    public void setFutureCreate(FutureCreate<BaseFuture> futureCreate) {
        if (futureCreate == null) {
            return;
        }
        this.futureCreate = futureCreate;
    }

    public void repeated(BaseFuture future) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackers(Set<PeerAddress> potentialTrackers, Set<PeerAddress> directTrackers, Map<PeerAddress, Collection<TrackerData>> peersOnTracker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.potentialTrackers = potentialTrackers;
            this.directTrackers = directTrackers;
            this.peersOnTracker = peersOnTracker;
            BaseFuture.FutureType futureType = this.type = potentialTrackers.size() == 0 && directTrackers.size() == 0 ? BaseFuture.FutureType.FAILED : BaseFuture.FutureType.OK;
            if (this.type == BaseFuture.FutureType.FAILED) {
                this.reason = "we did not find anything, are you sure you are serching for the right tracker?";
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPotentialTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.potentialTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getDirectTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.directTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Collection<TrackerData>> getRawPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TrackerData> getTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluatingSchemeTracker.evaluateSingle(this.peersOnTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Number160> getKnownPeers() {
        Object object = this.lock;
        synchronized (object) {
            return this.knownPeers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture, List<ScheduledFuture<?>> scheduledFutures) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduledFuture = scheduledFuture;
            this.scheduledFutures = scheduledFutures;
            if (this.cancelSchedule) {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelSchedule = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (this.scheduledFutures != null) {
                this.scheduledFutures.remove(this.scheduledFuture);
            }
        }
        super.cancel();
    }
}

