/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorage
extends StorageMemory {
    private static final Logger logger = LoggerFactory.getLogger(TrackerStorage.class);
    private final int trackerSize = 20;
    private int trackerStoreSize = 40;
    private final Random rnd;
    private volatile int trackerTimoutSeconds = Integer.MAX_VALUE;

    public TrackerStorage(long seed) {
        this.rnd = new Random(seed);
    }

    public int getTrackerSize() {
        return 20;
    }

    public int getTrackerTimoutSeconds() {
        return this.trackerTimoutSeconds;
    }

    public void setTrackerTimoutSeconds(int trackerTimoutSeconds) {
        this.trackerTimoutSeconds = trackerTimoutSeconds;
    }

    public boolean put(Number160 locationKey, Number160 domainKey, PublicKey publicKey, Data data) throws IOException {
        data.setTTLSeconds(this.getTrackerTimoutSeconds());
        Number480 number480 = new Number480(locationKey, domainKey, data.getPeerAddress().getID());
        return this.put(number480, data, publicKey, false, publicKey != null);
    }

    public int size(Number160 locationKey, Number160 domainKey) {
        DigestInfo digest = this.digest(new Number320(locationKey, domainKey));
        return digest.getSize();
    }

    public SortedMap<Number480, Data> getSelection(Number320 number320, int nr, SimpleBloomFilter<Number160> knownPeers) {
        List<Number480> keys = this.getKeys(number320);
        if (knownPeers != null) {
            Iterator<Number480> i = keys.iterator();
            while (i.hasNext()) {
                Number480 number480 = i.next();
                if (!knownPeers.contains(number480.getContentKey())) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("We won't deliver " + number480.getContentKey() + " as the peer indicates that its already known.");
                }
                i.remove();
            }
        }
        int size = keys.size();
        TreeMap<Number480, Data> result = new TreeMap<Number480, Data>();
        for (int i = 0; i < nr && i < size; ++i) {
            Number480 rndKey = keys.remove(this.rnd.nextInt(size - i));
            result.put(rndKey, this.get(rndKey));
        }
        return result;
    }

    public int getTrackerStoreSize() {
        return this.trackerStoreSize;
    }

    public void setTrackerStoreSize(int trackerStoreSize) {
        this.trackerStoreSize = trackerStoreSize;
    }
}

