/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.tomp2p.message.DataInput;
import net.tomp2p.message.DataOutput;
import net.tomp2p.message.DataOutputFactory;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.SHA1Signature;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class MessageCodec {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int MAX_BYTE = 255;
    public static final int HEADER_SIZE = 60;
    private static final ChannelFactory factory = new ChannelFactory();

    public static ChannelBuffer encodeHeader(ChannelBuffer buffer, Message message) {
        buffer.writeInt(message.getVersion());
        buffer.writeInt(message.getMessageId());
        buffer.writeByte((message.getType().ordinal() << 4) + message.getCommand().ordinal());
        buffer.writeBytes(message.getSender().getID().toByteArray());
        buffer.writeShort((int)((short)message.getSender().portTCP()));
        buffer.writeShort((int)((short)message.getSender().portUDP()));
        buffer.writeBytes(message.getRecipient().getID().toByteArray());
        buffer.writeInt(message.getContentLength());
        int content = message.getContentType4().ordinal() << 12 | message.getContentType3().ordinal() << 8 | message.getContentType2().ordinal() << 4 | message.getContentType1().ordinal();
        buffer.writeShort((int)((short)content));
        buffer.writeByte((int)message.getSender().createType());
        return buffer;
    }

    public static void encodePayload(Message message, List<ChannelBuffer> payloadBuffers) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        int contentLength = 0;
        if (message.getContentType1() != Message.Content.EMPTY) {
            contentLength += MessageCodec.encodePayloadType(message.getContentType1(), payloadBuffers, message);
            if (message.getContentType2() != Message.Content.EMPTY) {
                contentLength += MessageCodec.encodePayloadType(message.getContentType2(), payloadBuffers, message);
                if (message.getContentType3() != Message.Content.EMPTY) {
                    contentLength += MessageCodec.encodePayloadType(message.getContentType3(), payloadBuffers, message);
                    if (message.getContentType4() != Message.Content.EMPTY) {
                        contentLength += MessageCodec.encodePayloadType(message.getContentType4(), payloadBuffers, message);
                    }
                }
            }
        }
        message.setContentLength(contentLength);
    }

    private static int encodePayloadType(Message.Content content, List<ChannelBuffer> buffers, Message message) {
        if (message.isHintSign()) {
            throw new IllegalArgumentException("can set signing only at the end, but you called after signig " + (Object)((Object)content));
        }
        switch (content) {
            case KEY: {
                buffers.add(ChannelBuffers.wrappedBuffer((byte[])message.getKey3().toByteArray()));
                return 20;
            }
            case KEY_KEY: {
                buffers.add(ChannelBuffers.wrappedBuffer((byte[])message.getKey1().toByteArray()));
                buffers.add(ChannelBuffers.wrappedBuffer((byte[])message.getKey2().toByteArray()));
                return 40;
            }
            case MAP_KEY_DATA: {
                int count = 4;
                ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                if (message.isConvertNumber480to160()) {
                    Map<Number480, Data> dataMap = message.getDataMapConvert();
                    buffer.writeInt(dataMap.size());
                    buffers.add(buffer);
                    for (Map.Entry<Number480, Data> entry : dataMap.entrySet()) {
                        buffers.add(ChannelBuffers.wrappedBuffer((byte[])entry.getKey().getContentKey().toByteArray()));
                        count += 20;
                        ArrayList<DataOutput> tmp2 = new ArrayList<DataOutput>(4);
                        count += MessageCodec.encodeData(tmp2, factory, message, entry.getValue());
                        for (DataOutput output : tmp2) {
                            buffers.add(((ChannelEncoder)output).getChannelBuffer());
                        }
                    }
                    return count;
                }
                buffer.writeInt(message.getDataMap().size());
                buffers.add(buffer);
                for (Map.Entry<Number160, Data> entry : message.getDataMap().entrySet()) {
                    buffers.add(ChannelBuffers.wrappedBuffer((byte[])entry.getKey().toByteArray()));
                    count += 20;
                    ArrayList<DataOutput> tmp2 = new ArrayList<DataOutput>(4);
                    count += MessageCodec.encodeData(tmp2, factory, message, entry.getValue());
                    for (DataOutput output : tmp2) {
                        buffers.add(((ChannelEncoder)output).getChannelBuffer());
                    }
                }
                return count;
            }
            case MAP_KEY_KEY: {
                Map<Number160, Number160> keyMap = message.getKeyMap();
                int size = keyMap.size();
                ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                buffer.writeInt(size);
                buffers.add(buffer);
                for (Map.Entry<Number160, Number160> entry : keyMap.entrySet()) {
                    buffers.add(ChannelBuffers.wrappedBuffer((byte[])entry.getKey().toByteArray()));
                    buffers.add(ChannelBuffers.wrappedBuffer((byte[])entry.getValue().toByteArray()));
                }
                return 4 + size * 40;
            }
            case SET_KEYS: {
                if (message.isConvertNumber480to160()) {
                    Collection<Number480> keys = message.getKeysConvert();
                    int size = keys.size();
                    ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                    buffer.writeInt(size);
                    buffers.add(buffer);
                    for (Number480 key : keys) {
                        buffers.add(ChannelBuffers.wrappedBuffer((byte[])key.getContentKey().toByteArray()));
                    }
                    return 4 + size * 20;
                }
                int size = message.getKeys().size();
                ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                buffer.writeInt(size);
                buffers.add(buffer);
                for (Number160 key : message.getKeys()) {
                    buffers.add(ChannelBuffers.wrappedBuffer((byte[])key.toByteArray()));
                }
                return 4 + size * 20;
            }
            case SET_NEIGHBORS: {
                int count = 1;
                int size = Math.min(message.getNeighbors().size(), Math.min(message.getUseAtMostNeighbors(), 255));
                ChannelBuffer buffer = ChannelBuffers.buffer((int)1);
                buffer.writeByte(size);
                buffers.add(buffer);
                Iterator<PeerAddress> iterator = message.getNeighbors().iterator();
                for (int i = 0; iterator.hasNext() && i < size; ++i) {
                    ChannelBuffer buffer2 = MessageCodec.writePeerAddress(iterator.next());
                    buffers.add(buffer2);
                    count += buffer2.capacity();
                }
                return count;
            }
            case CHANNEL_BUFFER: {
                ChannelBuffer tmpBuffer = message.getPayload();
                int size = tmpBuffer.writerIndex();
                ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                buffer.writeInt(size);
                buffers.add(buffer);
                buffers.add(tmpBuffer.slice());
                return 4 + size;
            }
            case LONG: {
                ChannelBuffer buffer = ChannelBuffers.buffer((int)8);
                buffer.writeLong(message.getLong());
                buffers.add(buffer);
                return 8;
            }
            case INTEGER: {
                ChannelBuffer buffer = ChannelBuffers.buffer((int)4);
                buffer.writeInt(message.getInteger());
                buffers.add(buffer);
                return 4;
            }
            case PUBLIC_KEY: {
                byte[] data = message.getPublicKey().getEncoded();
                int size = data.length;
                ChannelBuffer buffer = ChannelBuffers.buffer((int)(2 + size));
                buffer.writeShort(size);
                buffer.writeBytes(data);
                buffers.add(buffer);
                return 2 + size;
            }
            case PUBLIC_KEY_SIGNATURE: {
                byte[] data = message.getPublicKey().getEncoded();
                int size = data.length;
                ChannelBuffer buffer = ChannelBuffers.buffer((int)(2 + size));
                buffer.writeShort(size);
                buffer.writeBytes(data);
                buffers.add(buffer);
                message.setHintSign(true);
                return 42 + size;
            }
        }
        return 0;
    }

    public static void encodeSecurity(Message message, List<ChannelBuffer> buffers) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, IOException {
        if (!message.isHintSign()) {
            return;
        }
        Signature signature = Signature.getInstance("SHA1withDSA");
        signature.initSign(message.getPrivateKey());
        for (ChannelBuffer buffer2 : buffers) {
            signature.update(buffer2.array(), buffer2.arrayOffset(), buffer2.writerIndex());
        }
        byte[] signatureData = signature.sign();
        SHA1Signature decodedSignature = new SHA1Signature();
        decodedSignature.decode(signatureData);
        buffers.add(ChannelBuffers.wrappedBuffer((byte[])decodedSignature.getNumber1().toByteArray()));
        buffers.add(ChannelBuffers.wrappedBuffer((byte[])decodedSignature.getNumber2().toByteArray()));
    }

    public static int encodeData(Collection<DataOutput> result, DataOutputFactory factory, Message message, Data data) {
        int dataHeaderLength;
        int count = dataHeaderLength = 11;
        DataOutput output1 = factory.create(dataHeaderLength);
        int seconds = data.getTTLSeconds();
        seconds = data.isProtectedEntry() ? seconds | Integer.MIN_VALUE : seconds & Integer.MAX_VALUE;
        output1.writeInt(seconds);
        output1.writeInt(data.getLength());
        result.add(output1);
        byte[] serializedPublicKey = null;
        PublicKey publicKey = data.getDataPublicKey();
        if (publicKey == null) {
            output1.writeShort(0);
        } else if (message != null && data.getDataPublicKey().equals(message.getPublicKey())) {
            output1.writeShort(-1);
        } else {
            serializedPublicKey = publicKey.getEncoded();
            int publicKeyLength = serializedPublicKey.length;
            output1.writeShort(publicKeyLength);
            count += publicKeyLength;
        }
        byte[] signature = data.getSignature();
        if (signature == null || signature.length == 0) {
            output1.writeByte(0);
        } else {
            int signatureLength = signature.length;
            output1.writeByte(signatureLength);
            count += signatureLength;
        }
        if (data.getPeerAddress() == null) {
            DataOutput outputPeerAddress = factory.create(new byte[1]);
            result.add(outputPeerAddress);
            ++count;
        } else {
            byte[] peerAddress = data.getPeerAddress().toByteArray();
            DataOutput outputPeerAddress = factory.create(peerAddress);
            result.add(outputPeerAddress);
            count += peerAddress.length;
        }
        DataOutput output2 = factory.create(data.getData(), data.getOffset(), data.getLength());
        result.add(output2);
        count += data.getLength();
        if (serializedPublicKey != null) {
            DataOutput output3 = factory.create(serializedPublicKey);
            result.add(output3);
        }
        if (signature != null && signature.length > 0) {
            DataOutput output4 = factory.create(signature);
            result.add(output4);
        }
        return count;
    }

    public static Message decodeHeader(ChannelBuffer buffer, InetAddress sender) throws DecoderException {
        Message message = new Message();
        message.setVersion(buffer.readInt());
        message.setMessageId(buffer.readInt());
        short commandType = buffer.readUnsignedByte();
        message.setCommand(Message.Command.values()[commandType & 0xF]);
        message.setType(Message.Type.values()[commandType >>> 4]);
        Number160 senderID = MessageCodec.readID(buffer);
        int portTCP = buffer.readUnsignedShort();
        int portUDP = buffer.readUnsignedShort();
        Number160 recipientID = MessageCodec.readID(buffer);
        message.setRecipient(new PeerAddress(recipientID));
        message.setContentLength(buffer.readInt());
        int contentType = buffer.readUnsignedShort();
        message.setContentType(Message.Content.values()[contentType & 0xF], Message.Content.values()[contentType >>> 4 & 0xF], Message.Content.values()[contentType >>> 8 & 0xF], Message.Content.values()[contentType >>> 12]);
        message.setRealSender(new PeerAddress(senderID, sender, portTCP, portUDP));
        byte optionType = buffer.readByte();
        PeerAddress peerAddress = new PeerAddress(senderID, sender, portTCP, portUDP, optionType);
        message.setSender(peerAddress);
        return message;
    }

    public static void decodePayload(Message.Content content, ChannelBuffer buffer, Message message) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        switch (content) {
            case KEY: {
                message.setKey0(MessageCodec.readID(buffer));
                break;
            }
            case KEY_KEY: {
                message.setKeyKey0(MessageCodec.readID(buffer), MessageCodec.readID(buffer));
                break;
            }
            case MAP_KEY_DATA: {
                int size = buffer.readInt();
                HashMap<Number160, Data> result = new HashMap<Number160, Data>(size);
                for (int i = 0; i < size; ++i) {
                    Number160 key = MessageCodec.readID(buffer);
                    Data data = MessageCodec.decodeData(new ChannelDecoder(buffer), message);
                    result.put(key, data);
                }
                message.setDataMap0(result);
                break;
            }
            case MAP_KEY_KEY: {
                int len = buffer.readInt();
                HashMap<Number160, Number160> keyMap = new HashMap<Number160, Number160>();
                for (int i = 0; i < len; ++i) {
                    Number160 key1 = MessageCodec.readID(buffer);
                    Number160 key2 = MessageCodec.readID(buffer);
                    keyMap.put(key1, key2);
                }
                message.setKeyMap0(keyMap);
                break;
            }
            case SET_KEYS: {
                int len = buffer.readInt();
                ArrayList<Number160> tmp = new ArrayList<Number160>(len);
                for (int i = 0; i < len; ++i) {
                    Number160 key = MessageCodec.readID(buffer);
                    tmp.add(key);
                }
                message.setKeys0(tmp);
                break;
            }
            case SET_NEIGHBORS: {
                int len = buffer.readUnsignedByte();
                ArrayList<PeerAddress> neighbors = new ArrayList<PeerAddress>(len);
                for (int i = 0; i < len; ++i) {
                    neighbors.add(MessageCodec.readPeerAddress(buffer));
                }
                message.setNeighbors0(neighbors);
                break;
            }
            case CHANNEL_BUFFER: {
                int len = buffer.readInt();
                ChannelBuffer tmpBuffer = buffer.copy(buffer.readerIndex(), len);
                buffer.skipBytes(len);
                message.setPayload0(tmpBuffer);
                break;
            }
            case LONG: {
                message.setLong0(buffer.readLong());
                break;
            }
            case INTEGER: {
                message.setInteger0(buffer.readInt());
                break;
            }
            case PUBLIC_KEY: {
                int len = buffer.readUnsignedShort();
                byte[] me = new byte[len];
                message.setPublicKey0(MessageCodec.decodePublicKey(new ChannelDecoder(buffer), me));
                break;
            }
            case PUBLIC_KEY_SIGNATURE: {
                int len = buffer.readUnsignedShort();
                byte[] me = new byte[len];
                PublicKey receivedPublicKey = MessageCodec.decodePublicKey(new ChannelDecoder(buffer), me);
                Signature signatureAlgorithm = Signature.getInstance("SHA1withDSA");
                signatureAlgorithm.initVerify(receivedPublicKey);
                signatureAlgorithm.update(buffer.array(), buffer.arrayOffset(), buffer.readerIndex());
                Number160 number1 = MessageCodec.readID(buffer);
                Number160 number2 = MessageCodec.readID(buffer);
                SHA1Signature signatureEncode = new SHA1Signature(number1, number2);
                byte[] signatureReceived = signatureEncode.encode();
                if (signatureAlgorithm.verify(signatureReceived)) {
                    message.setPublicKey0(receivedPublicKey);
                }
                if (!message.isHintDataPublickKey()) break;
                for (Data data : message.getDataMap().values()) {
                    if (!Data.FROM_MESSAGE.equals(data.getDataPublicKey())) continue;
                    data.setDataPublicKey(receivedPublicKey);
                }
                break;
            }
        }
    }

    public static Data decodeData(DataInput buffer, Message message) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, UnknownHostException {
        int ttl = buffer.readInt();
        boolean protectedEntry = (ttl & Integer.MIN_VALUE) != 0;
        ttl &= Integer.MAX_VALUE;
        int valueSize = buffer.readInt();
        int publicKeyLength = buffer.readUnsignedShort();
        int sigLength = buffer.readUnsignedByte();
        int type = buffer.getUnsignedByte();
        PeerAddress originator = null;
        if (type == 0) {
            buffer.skipBytes(1);
            if (message != null) {
                message.getSender();
            }
        } else {
            int len = PeerAddress.expectedLength(type);
            byte[] me = new byte[len];
            buffer.readBytes(me);
            originator = new PeerAddress(me, 0);
        }
        Data data = MessageCodec.createData(buffer.array(), buffer.arrayOffset() + buffer.readerIndex(), valueSize, ttl, protectedEntry, originator);
        buffer.skipBytes(valueSize);
        if (message != null && publicKeyLength == -1) {
            message.setHintDataPublickKey(true);
            data.setDataPublicKey(Data.FROM_MESSAGE);
        } else if (publicKeyLength > 0) {
            byte[] receivedRawPublicKey = new byte[publicKeyLength];
            PublicKey receivedPublicKey = MessageCodec.decodePublicKey(buffer, receivedRawPublicKey);
            data.setDataPublicKey(receivedPublicKey);
        }
        if (sigLength > 0) {
            byte[] signature = new byte[sigLength];
            buffer.readBytes(signature);
            data.setSignature(signature);
        }
        return data;
    }

    public static Data createData(byte[] me, int offset, int length, int ttl, boolean protectedEntry, PeerAddress originator) {
        Data data;
        if (length == 0) {
            data = new Data(EMPTY_BYTE_ARRAY, originator);
        } else {
            boolean copy = true;
            byte[] me2 = new byte[length];
            System.arraycopy(me, offset, me2, 0, length);
            data = new Data(me2, 0, length, originator);
        }
        data.setTTLSeconds(ttl);
        data.setProtectedEntry(protectedEntry);
        return data;
    }

    private static Number160 readID(ChannelBuffer buffer) {
        byte[] me = new byte[20];
        buffer.readBytes(me);
        return new Number160(me);
    }

    private static ChannelBuffer writePeerAddress(PeerAddress peerAddress) {
        int size = peerAddress.isIPv6() ? 41 : 29;
        ChannelBuffer result = ChannelBuffers.buffer((int)size);
        result.writeBytes(peerAddress.getID().toByteArray());
        result.writeShort(peerAddress.portTCP());
        result.writeShort(peerAddress.portUDP());
        byte type = peerAddress.createType();
        result.writeByte((int)type);
        result.writeBytes(peerAddress.getInetAddress().getAddress());
        return result;
    }

    private static PeerAddress readPeerAddress(ChannelBuffer buffer) throws UnknownHostException {
        Number160 id = MessageCodec.readID(buffer);
        int tcpPort = buffer.readUnsignedShort();
        int udpPort = buffer.readUnsignedShort();
        byte type = buffer.readByte();
        if (!PeerAddress.isNet6(type)) {
            byte[] tmp = new byte[4];
            buffer.readBytes(tmp);
            return new PeerAddress(id, InetAddress.getByAddress(tmp), tcpPort, udpPort);
        }
        byte[] tmp = new byte[16];
        buffer.readBytes(tmp);
        return new PeerAddress(id, InetAddress.getByAddress(tmp), tcpPort, udpPort);
    }

    public static PublicKey decodePublicKey(DataInput buffer, byte[] receivedRawPublicKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        buffer.readBytes(receivedRawPublicKey);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(receivedRawPublicKey);
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        PublicKey receivedPublicKey = keyFactory.generatePublic(pubKeySpec);
        return receivedPublicKey;
    }

    private static class ChannelDecoder
    implements DataInput {
        private final ChannelBuffer buffer;

        private ChannelDecoder(ChannelBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public byte[] array() {
            return this.buffer.array();
        }

        @Override
        public int arrayOffset() {
            return this.buffer.arrayOffset();
        }

        @Override
        public void readBytes(byte[] buf) {
            this.buffer.readBytes(buf);
        }

        @Override
        public int readInt() {
            return this.buffer.readInt();
        }

        @Override
        public int readUnsignedByte() {
            return this.buffer.readUnsignedByte();
        }

        @Override
        public int getUnsignedByte() {
            return this.buffer.getUnsignedByte(this.buffer.readerIndex());
        }

        @Override
        public int readUnsignedShort() {
            return this.buffer.readUnsignedShort();
        }

        @Override
        public int readerIndex() {
            return this.buffer.readerIndex();
        }

        @Override
        public void skipBytes(int size) {
            this.buffer.skipBytes(size);
        }
    }

    private static class ChannelEncoder
    implements DataOutput {
        private final ChannelBuffer buffer;

        private ChannelEncoder(ChannelBuffer buffer) {
            this.buffer = buffer;
        }

        public ChannelBuffer getChannelBuffer() {
            return this.buffer;
        }

        @Override
        public void writeByte(int intVal) {
            this.buffer.writeByte(intVal);
        }

        @Override
        public void writeInt(int intVal) {
            this.buffer.writeInt(intVal);
        }

        @Override
        public void writeShort(int intVal) {
            this.buffer.writeShort(intVal);
        }
    }

    private static class ChannelFactory
    implements DataOutputFactory {
        private ChannelFactory() {
        }

        @Override
        public DataOutput create(int count) {
            return new ChannelEncoder(ChannelBuffers.buffer((int)count));
        }

        @Override
        public DataOutput create(byte[] data, int offset, int length) {
            return new ChannelEncoder(ChannelBuffers.wrappedBuffer((byte[])data, (int)offset, (int)length));
        }

        @Override
        public DataOutput create(byte[] data) {
            return new ChannelEncoder(ChannelBuffers.wrappedBuffer((byte[])data));
        }
    }
}

