/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageRunner;
import net.tomp2p.utils.Utils;

public abstract class Storage {
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private ProtectionEntryInDomain protectionEntryInDomain = ProtectionEntryInDomain.ENTRY_LEAVE;
    private Collection<Number160> removedDomains = new HashSet<Number160>();

    public abstract boolean put(Number480 var1, Data var2, PublicKey var3, boolean var4, boolean var5);

    public abstract Data get(Number480 var1);

    public abstract SortedMap<Number480, Data> get(Number480 var1, Number480 var2);

    public abstract SortedMap<Number480, Data> remove(Number480 var1, Number480 var2, PublicKey var3);

    public abstract Data remove(Number480 var1, PublicKey var2);

    public SortedMap<Number480, Data> remove(Number320 number320, PublicKey publicKey) {
        return this.remove(number320.min(), number320.max(), publicKey);
    }

    public abstract boolean contains(Number480 var1);

    public abstract DigestInfo digest(Number480 var1, Number480 var2);

    public abstract DigestInfo digest(Collection<Number480> var1);

    public abstract void iterateAndRun(Number160 var1, StorageRunner var2);

    public abstract void close();

    public abstract Collection<Number160> findResponsibleData(Number160 var1);

    public abstract Number160 findResponsiblePeerID(Number160 var1);

    public abstract boolean updateResponsibilities(Number160 var1, Number160 var2);

    public abstract Collection<Number480> storedDirectReplication();

    public DigestInfo digest(Number320 key) {
        return this.digest(key.min(), key.max());
    }

    public Map<Number160, Data> get(Collection<Number480> keys) {
        return this.get(keys, null);
    }

    public Map<Number160, Data> get(Collection<Number480> keys, PublicKey publicKey) {
        HashMap<Number160, Data> result = new HashMap<Number160, Data>();
        for (Number480 key : keys) {
            Data data = this.get(key);
            if (data == null || publicKey != null && !publicKey.equals(data.getDataPublicKey())) continue;
            result.put(key.getContentKey(), data);
        }
        return result;
    }

    public SortedMap<Number480, Data> get(Number320 key) {
        return this.get(key.min(), key.max());
    }

    public void setProtection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode, ProtectionEntryInDomain protectionEntryInDomain) {
        this.setProtectionDomainEnable(protectionDomainEnable);
        this.setProtectionDomainMode(protectionDomainMode);
        this.setProtectionEntryEnable(protectionEntryEnable);
        this.setProtectionEntryMode(protectionEntryMode);
        this.setProtectionEntryInDomain(protectionEntryInDomain);
    }

    public void setProtectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode getProtectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void setProtectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable getProtectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void setProtectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode getProtectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void setProtectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable getProtectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void setProtectionEntryInDomain(ProtectionEntryInDomain protectionEntryInDomain) {
        this.protectionEntryInDomain = protectionEntryInDomain;
    }

    public ProtectionEntryInDomain getProtectionEntryInDomain() {
        return this.protectionEntryInDomain;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    boolean canProtectDomain(Number320 partKey, PublicKey publicKey) {
        if (this.getProtectionDomainEnable() == ProtectionEnable.ALL && !this.isDomainRemoved(partKey.getDomainKey())) {
            return true;
        }
        if (!this.isDomainRemoved(partKey.getDomainKey())) {
            return this.foreceOverrideDomain(partKey.getDomainKey(), publicKey);
        }
        return false;
    }

    boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.getProtectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return Storage.isMine(domainKey, publicKey);
        }
        return false;
    }

    boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.getProtectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return Storage.isMine(entryKey, publicKey);
        }
        return false;
    }

    boolean canUpdateEntry(Number480 key, Data oldData, Data newData, boolean protectEntry) {
        if (protectEntry) {
            return this.canProtectEntry(key, oldData, newData);
        }
        return true;
    }

    private boolean canProtectEntry(Number480 key, Data oldData, Data newData) {
        if (this.getProtectionEntryEnable() == ProtectionEnable.ALL) {
            if (oldData == null) {
                return true;
            }
            if (oldData.getDataPublicKey() == null) {
                return true;
            }
            if (oldData.getDataPublicKey().equals(newData.getDataPublicKey())) {
                return true;
            }
        }
        return this.foreceOverrideEntry(key.getContentKey(), newData.getDataPublicKey());
    }

    static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals(Utils.makeSHAHash(publicKey.getEncoded()));
    }

    public static enum ProtectionEntryInDomain {
        ENTRY_REMOVE_IF_DOMAIN_CLAIMED,
        ENTRY_LEAVE;

    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

