/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import net.tomp2p.message.IntermediateMessage;
import net.tomp2p.message.Message;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageLogger {
    private static final Logger logger = LoggerFactory.getLogger(MessageLogger.class);
    private final PrintWriter pw;
    private final GZIPOutputStream gz;
    private boolean open = false;
    private final ChannelUpstreamHandler channelUpstreamHandler;
    private final ChannelDownstreamHandler channelDownstreamHandler;

    public MessageLogger(File messageLogger) throws FileNotFoundException, IOException {
        this.gz = new GZIPOutputStream(new FileOutputStream(messageLogger));
        this.pw = new PrintWriter(this.gz);
        this.open = true;
        this.channelUpstreamHandler = new LoggerChannelUpstreamHandler();
        this.channelDownstreamHandler = new LoggerChannelDownstreamHandler();
    }

    public ChannelUpstreamHandler getChannelUpstreamHandler() {
        return this.channelUpstreamHandler;
    }

    public ChannelDownstreamHandler getChannelDownstreamHandler() {
        return this.channelDownstreamHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customMessage(String customMessage) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            if (this.open) {
                this.pw.println("C:".concat(customMessage));
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(MessageEvent e) throws Exception {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            if (this.open && e.getMessage() instanceof Message) {
                this.pw.println("R:".concat(e.getMessage().toString()));
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequested(MessageEvent e) throws Exception {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            if (this.open && e.getMessage() instanceof IntermediateMessage) {
                this.pw.println("W:".concat(e.getMessage().toString()));
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.pw.flush();
            try {
                this.gz.finish();
                this.gz.close();
            }
            catch (IOException e) {
                logger.error(e.toString());
                e.printStackTrace();
            }
            this.pw.close();
            this.open = false;
        }
    }

    @ChannelHandler.Sharable
    private class LoggerChannelDownstreamHandler
    implements ChannelDownstreamHandler {
        private LoggerChannelDownstreamHandler() {
        }

        public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof MessageEvent) {
                MessageLogger.this.writeRequested((MessageEvent)e);
            }
            ctx.sendDownstream(e);
        }
    }

    @ChannelHandler.Sharable
    private class LoggerChannelUpstreamHandler
    implements ChannelUpstreamHandler {
        private LoggerChannelUpstreamHandler() {
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            if (e instanceof MessageEvent) {
                MessageLogger.this.messageReceived((MessageEvent)e);
            }
            ctx.sendUpstream(e);
        }
    }
}

