/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Bindings {
    private final List<InetAddress> listenAddresses4 = new ArrayList<InetAddress>(1);
    private final List<InetAddress> listenAddresses6 = new ArrayList<InetAddress>(1);
    private final List<InetAddress> broadcastAddresses = new ArrayList<InetAddress>(1);
    private final List<String> listenInterfaceHints = new ArrayList<String>(1);
    private final List<Protocol> listenProtocolHints = new ArrayList<Protocol>(0);
    private final boolean listenBroadcast;
    private InetAddress outsideAddress = null;
    private int outsideTCPPort = 0;
    private int outsideUDPPort = 0;
    private boolean behindFirewall = false;

    public Bindings() {
        this(true);
    }

    public Bindings(InetAddress bind) {
        this.addAddress(bind);
        this.listenBroadcast = true;
    }

    public Bindings(boolean listenBroadcast) {
        this.listenBroadcast = listenBroadcast;
    }

    public Bindings(Protocol protocol) {
        this.addProtocol(protocol);
        this.listenBroadcast = true;
    }

    public Bindings(String iface) {
        this.addInterface(iface);
        this.listenBroadcast = true;
    }

    public Bindings(Protocol protocol, String iface) {
        this.addInterface(iface);
        this.addProtocol(protocol);
        this.listenBroadcast = true;
    }

    public Bindings(Protocol protocol, String iface, InetAddress outsideAddress, int outsideTCPPort, int outsideUDPPort, boolean listenBroadcast) {
        this.addInterface(iface);
        this.addProtocol(protocol);
        this.outsideAddress = outsideAddress;
        this.outsideTCPPort = outsideTCPPort;
        this.outsideUDPPort = outsideUDPPort;
        this.listenBroadcast = listenBroadcast;
    }

    public void addAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        if (address instanceof Inet4Address) {
            this.listenAddresses4.add(address);
        } else {
            this.listenAddresses6.add(address);
        }
    }

    public void addBroadcastAddress(InetAddress broadcastAddress) {
        if (broadcastAddress == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.broadcastAddresses.add(broadcastAddress);
    }

    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> listenAddresses = new ArrayList<InetAddress>();
        listenAddresses.addAll(this.listenAddresses4);
        listenAddresses.addAll(this.listenAddresses6);
        return listenAddresses;
    }

    public List<InetAddress> getBroadcastAddresses() {
        return this.broadcastAddresses;
    }

    public void addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenInterfaceHints.add(interfaceHint);
    }

    public List<String> getInterfaces() {
        return this.listenInterfaceHints;
    }

    public void addProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenProtocolHints.add(protocol);
    }

    public List<Protocol> getProtocols() {
        return this.listenProtocolHints;
    }

    public void setAllInterfaces() {
        this.listenInterfaceHints.clear();
    }

    public boolean useAllInterfaces() {
        return this.listenInterfaceHints.size() == 0;
    }

    public void setAllProtocols() {
        this.listenProtocolHints.clear();
    }

    public boolean useAllProtocols() {
        return this.listenProtocolHints.size() == 0;
    }

    public boolean useIPv4() {
        return this.useAllProtocols() || this.listenInterfaceHints.contains((Object)Protocol.IPv4);
    }

    public boolean useIPv6() {
        return this.useAllProtocols() || this.listenInterfaceHints.contains((Object)Protocol.IPv6);
    }

    private StringBuilder discoverNetwork(NetworkInterface networkInterface) {
        StringBuilder sb = new StringBuilder();
        for (InterfaceAddress iface : networkInterface.getInterfaceAddresses()) {
            InetAddress inet = iface.getAddress();
            if (this.getAddresses().contains(inet)) continue;
            if (this.useAllProtocols()) {
                sb.append(",").append(inet);
                this.addAddress(inet);
            } else {
                if (inet instanceof Inet4Address && this.getProtocols().contains((Object)Protocol.IPv4)) {
                    sb.append(",").append(inet);
                    this.addAddress(inet);
                }
                if (inet instanceof Inet6Address && this.getProtocols().contains((Object)Protocol.IPv6)) {
                    sb.append(",").append(inet);
                    this.addAddress(inet);
                }
            }
            if (iface.getBroadcast() == null) continue;
            this.addBroadcastAddress(iface.getBroadcast());
        }
        return sb.replace(0, 1, "(").append(")");
    }

    public String discoverLocalInterfaces() throws SocketException, UnknownHostException {
        StringBuilder sb = new StringBuilder("Status: ");
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            if (this.useAllInterfaces()) {
                sb.append(" +").append(networkInterface.getName());
                sb.append((CharSequence)this.discoverNetwork(networkInterface)).append(",");
                continue;
            }
            if (this.getInterfaces().contains(networkInterface.getName())) {
                sb.append(" +").append(networkInterface.getName());
                sb.append((CharSequence)this.discoverNetwork(networkInterface)).append(",");
                continue;
            }
            sb.append(" -").append(networkInterface.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean isListenBroadcast() {
        return this.listenBroadcast;
    }

    public void setOutsideAddress(InetAddress outsideAddress, int outsideTCPPort, int outsideUDPPort) {
        if (outsideAddress == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        if (outsideTCPPort <= 0 || outsideUDPPort <= 0) {
            throw new IllegalArgumentException("port needs to be > 0");
        }
        this.outsideAddress = outsideAddress;
        this.outsideTCPPort = outsideTCPPort;
        this.outsideUDPPort = outsideUDPPort;
    }

    public InetAddress getOutsideAddress() {
        return this.outsideAddress;
    }

    public int getOutsideTCPPort() {
        return this.outsideTCPPort;
    }

    public int getOutsideUDPPort() {
        return this.outsideUDPPort;
    }

    public void setBehindFirewall(boolean behindFirewall) {
        this.behindFirewall = behindFirewall;
    }

    public boolean isBehindFirewall() {
        return this.behindFirewall;
    }

    public static enum Protocol {
        IPv4,
        IPv6;

    }
}

