/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerMap;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultExceptionEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlerUDP
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlerUDP.class);
    private final FutureResponse futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final AtomicBoolean handlingMessage = new AtomicBoolean(false);
    private final MessageID sendMessageID;

    public RequestHandlerUDP(PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this(new FutureResponse(message), peerBean, connectionBean, message);
    }

    public RequestHandlerUDP(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = message;
        this.sendMessageID = new MessageID(message);
    }

    public FutureResponse getFutureResponse() {
        return this.futureResponse;
    }

    public FutureResponse sendUDP() {
        this.connectionBean.getSender().sendUDP(this.message, this);
        return this.futureResponse;
    }

    public FutureResponse sendBroadcastUDP() {
        this.connectionBean.getSender().sendBroadcastUDP(this.message, this);
        return this.futureResponse;
    }

    public FutureResponse fireAndForgetUDP() {
        this.message.setFireAndForget(true);
        this.connectionBean.getSender().sendUDP(this.message, this);
        return this.futureResponse;
    }

    protected PeerMap getPeerMap() {
        return this.peerBean.getPeerMap();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (this.handlingMessage.compareAndSet(false, true)) {
            this.futureResponse.cancelTimeout();
            ctx.getChannel().close();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Error originating from: " + this.futureResponse.getRequest());
            for (StackTraceElement t : Thread.currentThread().getStackTrace()) {
                logger.debug("\t" + t);
            }
            e.getCause().printStackTrace();
        }
        if (this.futureResponse.isCompleted()) {
            logger.warn("Got exception, but ignored (future response completed): " + this.futureResponse.getFailedReason());
            if (logger.isDebugEnabled()) {
                e.getCause().printStackTrace();
            }
        } else {
            logger.debug("exception caugth, but handled properly: " + e.toString());
            this.futureResponse.setFailed(e.toString());
            if (e.getCause() instanceof PeerException) {
                PeerException pe = (PeerException)e.getCause();
                if (pe.getAbortCause() != PeerException.AbortCause.USER_ABORT) {
                    boolean added = this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), false);
                    if (added) {
                        logger.warn("Peer exception (" + System.currentTimeMillis() + ") " + e.getCause() + " msg " + this.message + " for " + this.futureResponse.getRequest().getRecipient());
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(pe.getMessage() + this.message);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn("error in request " + e.toString());
                    if (logger.isDebugEnabled()) {
                        e.getCause().printStackTrace();
                    }
                }
            } else {
                this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), true);
            }
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (this.handlingMessage.compareAndSet(false, true)) {
            this.futureResponse.cancelTimeout();
            ctx.getChannel().close();
        }
        if (e.getMessage() instanceof Message) {
            Message message = (Message)e.getMessage();
            MessageID recvMessageID = new MessageID(message);
            if (message.getType() == Message.Type.UNKNOWN_ID) {
                String msg = "Message was not delivered successfully: " + this.message;
                this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            } else if (message.getType() == Message.Type.EXCEPTION) {
                String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
                this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            } else if (!this.sendMessageID.equals(recvMessageID)) {
                String msg = "Message [" + message + "] sent to the node is not the same as we expect. We sent [" + this.message + "]";
                if (logger.isWarnEnabled()) {
                    logger.warn(msg);
                }
                this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("perfect: " + message);
                }
                if (message.isOk() || message.isNotOk()) {
                    this.getPeerMap().peerOnline(message.getSender(), null);
                }
                this.futureResponse.setResponse(message);
            }
        } else {
            String msg = "Message [" + e.getMessage() + "] is not of type Message";
            logger.error(msg);
            this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
        }
        ctx.sendUpstream((ChannelEvent)e);
    }
}

