/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import net.tomp2p.storage.StorageRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTrackerReplication
implements ResponsibilityListener {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTrackerReplication.class);
    private final Storage storage;
    private final TrackerRPC trackerRPC;
    private final Map<BaseFuture, Long> pendingFutures;
    private final Statistics statistics;

    public DefaultTrackerReplication(Storage storage, TrackerRPC trackerRPC, Map<BaseFuture, Long> pendingFutures, Statistics statistics) {
        this.storage = storage;
        this.trackerRPC = trackerRPC;
        this.pendingFutures = pendingFutures;
        this.statistics = statistics;
    }

    @Override
    public void otherResponsible(Number160 locationKey, final PeerAddress other) {
        if (logger.isDebugEnabled()) {
            logger.debug("[tracker] Other peer " + other + " is responsible for " + locationKey);
        }
        this.storage.iterateAndRun(locationKey, new StorageRunner(){

            @Override
            public void call(Number160 locationKey, Number160 domainKey, Number160 contentKey, Data data) {
                if (DefaultTrackerReplication.this.isPrimaryTracker(locationKey, DefaultTrackerReplication.this.trackerRPC.getPeerAddress())) {
                    FutureResponse futureResponse = DefaultTrackerReplication.this.trackerRPC.addToTrackerReplication(other, locationKey, domainKey, data, false);
                    DefaultTrackerReplication.this.pendingFutures.put(futureResponse, System.currentTimeMillis());
                    if (logger.isDebugEnabled()) {
                        logger.debug("transfer from " + DefaultTrackerReplication.this.trackerRPC.getPeerAddress() + " to " + other);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("No transfer from " + DefaultTrackerReplication.this.trackerRPC.getPeerAddress() + " to " + other + " becaues I'm a secondary tracker");
                }
            }
        });
    }

    private boolean isPrimaryTracker(Number160 locationKey, PeerAddress self) {
        double distance = self.getID().xor(locationKey).doubleValue();
        if (logger.isDebugEnabled()) {
            logger.debug("distance: " + distance + " avgGap*5:" + this.statistics.getAvgGap() * 10.0);
        }
        return true;
    }

    @Override
    public void meResponsible(Number160 locationKey) {
        if (logger.isDebugEnabled()) {
            logger.debug("[tracker] I now responsible for " + locationKey);
        }
    }
}

