/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.TCPChannelCache;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.rpc.ReplyHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class DispatcherRequest
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherRequest.class);
    private volatile Map<Number160, Map<Message.Command, ReplyHandler>> listenersRequest = null;
    private volatile Set<ReplyHandler> handlers = null;
    private final int p2pID;
    private final PeerBean peerBean;
    private final int timeoutUPDMillis;
    private final int timeoutTCPMillis;
    private final ChannelGroup channelGroup;
    private final PeerMap peerMap;
    private final List<PeerListener> listeners;
    private final TCPChannelCache channelChache;

    public DispatcherRequest(int p2pID, PeerBean peerBean, int timeoutUPDMillis, int timeoutTCPMillis, ChannelGroup channelGroup, PeerMap peerMap, List<PeerListener> listeners, TCPChannelCache channelChache) {
        this.p2pID = p2pID;
        this.peerBean = peerBean;
        this.timeoutUPDMillis = timeoutUPDMillis;
        this.timeoutTCPMillis = timeoutTCPMillis;
        this.channelGroup = channelGroup;
        this.peerMap = peerMap;
        this.listeners = listeners;
        this.channelChache = channelChache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIoHandler(PeerAddress sender, ReplyHandler ioHandler, Message.Command ... names) {
        DispatcherRequest dispatcherRequest = this;
        synchronized (dispatcherRequest) {
            HashSet<ReplyHandler> copy1 = this.handlers == null ? new HashSet<ReplyHandler>() : new HashSet<ReplyHandler>(this.handlers);
            copy1.add(ioHandler);
            this.handlers = Collections.unmodifiableSet(copy1);
            HashMap copy2 = this.listenersRequest == null ? new HashMap() : new HashMap<Number160, Map<Message.Command, ReplyHandler>>(this.listenersRequest);
            HashMap<Message.Command, ReplyHandler> types = (HashMap<Message.Command, ReplyHandler>)copy2.get(sender.getID());
            if (types == null) {
                types = new HashMap<Message.Command, ReplyHandler>();
                copy2.put(sender.getID(), types);
            }
            for (Message.Command name : names) {
                types.put(name, ioHandler);
            }
            this.listenersRequest = Collections.unmodifiableMap(copy2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIoHandler(Number160 ... ids) {
        DispatcherRequest dispatcherRequest = this;
        synchronized (dispatcherRequest) {
            if (this.listenersRequest != null) {
                HashMap<Number160, Map<Message.Command, ReplyHandler>> copy2 = new HashMap<Number160, Map<Message.Command, ReplyHandler>>(this.listenersRequest);
                HashSet<ReplyHandler> copy1 = new HashSet<ReplyHandler>(this.handlers);
                for (Number160 id : ids) {
                    Map types = (Map)copy2.remove(id);
                    if (types == null) continue;
                    copy1.removeAll(types.values());
                }
                this.handlers = Collections.unmodifiableSet(copy1);
                this.listenersRequest = Collections.unmodifiableMap(copy2);
            }
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channelGroup.add((Object)ctx.getChannel());
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.warn("error in dispatcher request" + e.toString());
        if (logger.isDebugEnabled()) {
            e.getCause().printStackTrace();
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        PeerAddress newServerAddress;
        int timeout;
        if (!(e.getMessage() instanceof Message)) {
            logger.error("Message received, but not of type Message: " + e.getMessage());
            DispatcherRequest.close(ctx);
            return;
        }
        Message message = (Message)e.getMessage();
        if (logger.isDebugEnabled()) {
            logger.debug("received request " + message);
        }
        if (message.getVersion() != this.p2pID) {
            logger.error("Wrong version. We are looking for " + this.p2pID + " but we got " + message.getVersion() + ", received: " + message);
            DispatcherRequest.close(ctx);
            this.peerMap.peerOffline(message.getSender(), true);
            return;
        }
        int n = timeout = ctx.getChannel() instanceof DatagramChannel ? this.timeoutUPDMillis : this.timeoutTCPMillis;
        if (System.currentTimeMillis() > message.getFinished() + (long)timeout) {
            logger.info("We are very busy and cannto reply in time (timeout=" + timeout + "), so we drop:" + message);
            DispatcherRequest.close(ctx);
            return;
        }
        PeerAddress serverAddress = this.peerBean.getServerPeerAddress();
        if (serverAddress.isFirewalledUDP() && ctx.getChannel() instanceof DatagramChannel) {
            newServerAddress = serverAddress.notFirewalledUDP();
            this.peerBean.setServerPeerAddress(newServerAddress);
            for (PeerListener listener : this.listeners) {
                listener.serverAddressChanged(newServerAddress);
            }
        } else if (serverAddress.isFirewalledTCP() && !(ctx.getChannel() instanceof DatagramChannel)) {
            newServerAddress = serverAddress.notFirewalledTCP();
            this.peerBean.setServerPeerAddress(newServerAddress);
            for (PeerListener listener : this.listeners) {
                listener.serverAddressChanged(newServerAddress);
            }
        }
        Message responseMessage = null;
        ReplyHandler myHandler = this.getAssociatedHandler(message);
        if (myHandler != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("about to respond to " + message);
            }
            if ((responseMessage = myHandler.forwardMessage(message)) == null) {
                logger.warn("Repsonse message was null, probaly a custom handler failed " + message);
                message.setRecipient(message.getSender()).setSender(this.peerBean.getServerPeerAddress()).setType(Message.Type.EXCEPTION);
                responseMessage = message;
            }
        } else {
            logger.warn("No handler found for " + message);
            message.setRecipient(message.getSender()).setSender(this.peerBean.getServerPeerAddress()).setType(Message.Type.UNKNOWN_ID);
            responseMessage = message;
        }
        this.response(ctx, e, responseMessage);
    }

    private void response(final ChannelHandlerContext ctx, MessageEvent e, final Message response) {
        if (ctx.getChannel() instanceof DatagramChannel) {
            if (logger.isDebugEnabled()) {
                logger.debug("reply UDP message " + response);
            }
            e.getChannel().write((Object)response, e.getRemoteAddress());
        } else {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("reply TCP message " + response);
                }
                ChannelFuture cf = ctx.getChannel().write((Object)response);
                cf.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            DispatcherRequest.this.channelChache.addChannel(response.getSender().getID(), response.getRecipient().getID(), response.getRecipient().getInetAddress(), ctx.getChannel());
                        }
                    }
                });
            }
            catch (Throwable e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void close(ChannelHandlerContext ctx) {
        if (!(ctx.getChannel() instanceof DatagramChannel)) {
            ctx.getChannel().close();
        }
    }

    private ReplyHandler getAssociatedHandler(Message message) {
        if (message == null || !message.isRequest()) {
            return null;
        }
        PeerAddress recipient = message.getRecipient();
        if (recipient.getID().isZero() && message.getCommand() == Message.Command.PING) {
            return this.searchHandler(this.peerBean.getServerPeerAddress().getID(), Message.Command.PING);
        }
        return this.searchHandler(recipient.getID(), message.getCommand());
    }

    private ReplyHandler searchHandler(Number160 recipientID, Message.Command command) {
        Map<Number160, Map<Message.Command, ReplyHandler>> listenersRequest2 = this.listenersRequest;
        if (listenersRequest2 == null) {
            return null;
        }
        Map<Message.Command, ReplyHandler> types = listenersRequest2.get(recipientID);
        if (types != null && types.containsKey((Object)command)) {
            return types.get((Object)command);
        }
        logger.error("Handler not found for type " + (Object)((Object)command) + ", we are looking for the server with ID " + recipientID);
        return null;
    }
}

