/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageCodec;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.TrackerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(TrackerRPC.class);

    public TrackerRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.TRACKER_ADD, Message.Command.TRACKER_GET);
    }

    public PeerAddress getPeerAddress() {
        return this.peerBean.getServerPeerAddress();
    }

    public FutureResponse addToTrackerReplication(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Data data, boolean signMessage) {
        this.nullCheck(remoteNode, locationKey, domainKey);
        Message message = this.createMessage(remoteNode, Message.Command.TRACKER_ADD, Message.Type.REQUEST_2);
        message.setKeyKey(locationKey, domainKey);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        RequestHandlerTCP requestHandler = new RequestHandlerTCP(this.peerBean, this.connectionBean, message);
        HashMap<Number160, Data> c = new HashMap<Number160, Data>(1);
        c.put(data.getHash(), data);
        message.setDataMap(c);
        return requestHandler.sendTCP();
    }

    public FutureResponse addToTracker(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, Data attachement, boolean signMessage, boolean primary) {
        this.nullCheck(remoteNode, locationKey, domainKey);
        Message message = this.createMessage(remoteNode, Message.Command.TRACKER_ADD, primary ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        message.setKeyKey(locationKey, domainKey);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        if (attachement != null) {
            RequestHandlerTCP requestHandler = new RequestHandlerTCP(this.peerBean, this.connectionBean, message);
            HashMap<Number160, Data> c = new HashMap<Number160, Data>(1);
            c.put(attachement.getHash(), attachement);
            message.setDataMap(c);
            return requestHandler.sendTCP();
        }
        RequestHandlerUDP requestHandler = new RequestHandlerUDP(this.peerBean, this.connectionBean, message);
        return requestHandler.sendUDP();
    }

    public FutureResponse getFromTracker(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, boolean expectAttachement, boolean signMessage) {
        this.nullCheck(remoteNode, locationKey, domainKey);
        Message message = this.createMessage(remoteNode, Message.Command.TRACKER_GET, Message.Type.REQUEST_1);
        message.setKeyKey(locationKey, domainKey);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        if (expectAttachement) {
            RequestHandlerTCP requestHandler = new RequestHandlerTCP(this.peerBean, this.connectionBean, message);
            return requestHandler.sendTCP();
        }
        RequestHandlerUDP requestHandler = new RequestHandlerUDP(this.peerBean, this.connectionBean, message);
        return requestHandler.sendUDP();
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_3) && message.getKey1() != null && message.getKey2() != null;
    }

    @Override
    public Message handleResponse(Message message) throws Exception {
        boolean direct = message.getType() == Message.Type.REQUEST_1;
        boolean primary = message.getType() == Message.Type.REQUEST_3;
        Message responseMessage = this.createMessage(message.getSender(), message.getCommand(), Message.Type.OK);
        responseMessage.setMessageId(message.getMessageId());
        TrackerStorage trackerStorage = this.peerBean.getTrackerStorage();
        Number160 locationKey = message.getKey1();
        Number160 domainKey = message.getKey2();
        if (direct || primary) {
            SortedMap<Number480, Data> peerDataMap = trackerStorage.getSelection(new Number320(locationKey, domainKey), trackerStorage.getTrackerSize());
            if (peerDataMap == null) {
                responseMessage.setDataMap(new HashMap<Number160, Data>());
            } else {
                responseMessage.setDataMapConvert(peerDataMap);
            }
            PeerAddress senderAddress = message.getSender();
            if (message.getCommand() == Message.Command.TRACKER_ADD) {
                if (trackerStorage.size(locationKey, domainKey) >= trackerStorage.getTrackerStoreSize()) {
                    responseMessage.setType(Message.Type.DENIED);
                } else {
                    Map<Number160, Data> dataMap;
                    if (logger.isDebugEnabled()) {
                        logger.debug("tracker put on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + senderAddress);
                    }
                    if (primary && this.peerBean.getReplicationTracker() != null) {
                        this.peerBean.getReplicationTracker().updatePeerMapIfCloser(locationKey, message.getSender().getID());
                    }
                    Data attachement = (dataMap = message.getDataMap()) != null && dataMap.size() >= 1 ? dataMap.values().iterator().next() : new Data(MessageCodec.EMPTY_BYTE_ARRAY, null);
                    attachement.setPeerAddress(senderAddress);
                    PublicKey publicKey = message.getPublicKey();
                    if (!trackerStorage.put(locationKey, domainKey, publicKey, attachement)) {
                        responseMessage.setType(Message.Type.DENIED);
                    } else if (primary && this.peerBean.getReplicationTracker() != null) {
                        this.peerBean.getReplicationTracker().checkResponsibility(locationKey);
                    }
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("tracker get on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + senderAddress);
                }
                if (peerDataMap == null) {
                    responseMessage.setType(Message.Type.NOT_FOUND);
                }
            }
        } else {
            Map<Number160, Data> dataMap;
            Data data;
            if (this.peerBean.getReplicationTracker() != null) {
                this.peerBean.getReplicationTracker().updatePeerMapIfCloser(locationKey, message.getSender().getID());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("tracker replication on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + message.getSender());
            }
            if (!trackerStorage.put(locationKey, domainKey, null, data = (dataMap = message.getDataMap()).values().iterator().next())) {
                responseMessage.setType(Message.Type.DENIED);
            } else if (this.peerBean.getReplicationTracker() != null) {
                this.peerBean.getReplicationTracker().checkResponsibility(locationKey);
            }
        }
        return responseMessage;
    }
}

