/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerUDP;

public class QuitRPC
extends ReplyHandler {
    public QuitRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.QUIT);
    }

    public FutureResponse quit(PeerAddress remoteNode) {
        Message message = this.createMessage(remoteNode, Message.Command.QUIT, Message.Type.REQUEST_1);
        RequestHandlerUDP requestHandler = new RequestHandlerUDP(this.peerBean, this.connectionBean, message);
        return requestHandler.fireAndForgetUDP();
    }

    @Override
    public boolean checkMessage(Message message) {
        return message.getType() == Message.Type.REQUEST_1 && message.getCommand() == Message.Command.QUIT;
    }

    @Override
    public Message handleResponse(Message message) throws Exception {
        this.peerBean.getPeerMap().peerOffline(message.getSender(), true);
        return null;
    }
}

