/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.utils.AbstractTrafficShapingHandler;
import org.jboss.netty.channel.ChannelHandlerContext;

public class TrafficCounter {
    private final AtomicLong currentWrittenBytes = new AtomicLong(0L);
    private final AtomicLong currentReadBytes = new AtomicLong(0L);
    private final AtomicLong cumulativeWrittenBytes = new AtomicLong(0L);
    private final AtomicLong cumulativeReadBytes = new AtomicLong(0L);
    private long lastCumulativeTime;
    private long lastWriteThroughput = 0L;
    private long lastReadThroughput = 0L;
    private final AtomicLong lastTime = new AtomicLong(0L);
    private long lastWrittenBytes = 0L;
    private long lastReadBytes = 0L;
    AtomicLong checkInterval = new AtomicLong(1000L);
    private final String name;
    private AbstractTrafficShapingHandler trafficShapingHandler = null;
    private Executor executor = null;
    AtomicBoolean monitorActive = new AtomicBoolean(false);
    private TrafficMonitoring trafficMonitoring = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AtomicLong atomicLong = this.lastTime;
        synchronized (atomicLong) {
            if (this.monitorActive.get()) {
                return;
            }
            this.lastTime.set(System.currentTimeMillis());
            if (this.checkInterval.get() > 0L) {
                this.monitorActive.set(true);
                this.trafficMonitoring = new TrafficMonitoring(this.trafficShapingHandler, this);
                this.executor.execute(this.trafficMonitoring);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AtomicLong atomicLong = this.lastTime;
        synchronized (atomicLong) {
            if (!this.monitorActive.get()) {
                return;
            }
            this.monitorActive.set(false);
            this.resetAccounting(System.currentTimeMillis());
            if (this.trafficShapingHandler != null) {
                this.trafficShapingHandler.doAccounting(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetAccounting(long newLastTime) {
        AtomicLong atomicLong = this.lastTime;
        synchronized (atomicLong) {
            long interval = newLastTime - this.lastTime.getAndSet(newLastTime);
            if (interval == 0L) {
                return;
            }
            this.lastReadBytes = this.currentReadBytes.getAndSet(0L);
            this.lastWrittenBytes = this.currentWrittenBytes.getAndSet(0L);
            this.lastReadThroughput = this.lastReadBytes / interval * 1000L;
            this.lastWriteThroughput = this.lastWrittenBytes / interval * 1000L;
        }
    }

    public TrafficCounter(AbstractTrafficShapingHandler trafficShapingHandler, Executor executor, String name, long checkInterval) {
        this.trafficShapingHandler = trafficShapingHandler;
        this.executor = executor;
        this.name = name;
        this.lastCumulativeTime = System.currentTimeMillis();
        this.configure(checkInterval);
    }

    public void configure(long newcheckInterval) {
        if (this.checkInterval.get() != newcheckInterval) {
            this.checkInterval.set(newcheckInterval);
            if (newcheckInterval <= 0L) {
                this.stop();
                this.lastTime.set(System.currentTimeMillis());
            } else {
                this.start();
            }
        }
    }

    void bytesRecvFlowControl(ChannelHandlerContext ctx, long recv) throws InterruptedException {
        this.currentReadBytes.addAndGet(recv);
        this.cumulativeReadBytes.addAndGet(recv);
    }

    void bytesWriteFlowControl(long write) throws InterruptedException {
        this.currentWrittenBytes.addAndGet(write);
        this.cumulativeWrittenBytes.addAndGet(write);
    }

    public long getCheckInterval() {
        return this.checkInterval.get();
    }

    public long getLastReadThroughput() {
        return this.lastReadThroughput;
    }

    public long getLastWriteThroughput() {
        return this.lastWriteThroughput;
    }

    public long getLastReadBytes() {
        return this.lastReadBytes;
    }

    public long getLastWrittenBytes() {
        return this.lastWrittenBytes;
    }

    public long getCurrentReadBytes() {
        return this.currentReadBytes.get();
    }

    public long getCurrentWrittenBytes() {
        return this.currentWrittenBytes.get();
    }

    public long getLastTime() {
        return this.lastTime.get();
    }

    public long getCumulativeWrittenBytes() {
        return this.cumulativeWrittenBytes.get();
    }

    public long getCumulativeReadBytes() {
        return this.cumulativeReadBytes.get();
    }

    public long getLastCumulativeTime() {
        return this.lastCumulativeTime;
    }

    public void resetCumulativeTime() {
        this.lastCumulativeTime = System.currentTimeMillis();
        this.cumulativeReadBytes.set(0L);
        this.cumulativeWrittenBytes.set(0L);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Monitor " + this.name + " Current Speed Read: " + (this.lastReadThroughput >> 10) + " KB/s, Write: " + (this.lastWriteThroughput >> 10) + " KB/s Current Read: " + (this.currentReadBytes.get() >> 10) + " KB Current Write: " + (this.currentWrittenBytes.get() >> 10) + " KB";
    }

    private class TrafficMonitoring
    implements Runnable {
        private final AbstractTrafficShapingHandler trafficShapingHandler1;
        private final TrafficCounter counter;

        protected TrafficMonitoring(AbstractTrafficShapingHandler trafficShapingHandler, TrafficCounter counter) {
            this.trafficShapingHandler1 = trafficShapingHandler;
            this.counter = counter;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread().setName(TrafficCounter.this.name);
                while (TrafficCounter.this.monitorActive.get()) {
                    long check = this.counter.checkInterval.get();
                    if (check <= 0L) {
                        return;
                    }
                    Thread.sleep(check);
                    long endTime = System.currentTimeMillis();
                    this.counter.resetAccounting(endTime);
                    if (this.trafficShapingHandler1 == null) continue;
                    this.trafficShapingHandler1.doAccounting(this.counter);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

