/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapChangeListener;
import net.tomp2p.peers.PeerMapStat;
import net.tomp2p.peers.PeerOfflineListener;
import net.tomp2p.utils.CacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerMapKadImpl
implements PeerMap {
    private static final Logger logger = LoggerFactory.getLogger(PeerMapKadImpl.class);
    private final int bagSize;
    private final int maxPeers;
    private final Number160 self;
    private final List<Map<Number160, PeerAddress>> peerMap = new ArrayList<Map<Number160, PeerAddress>>();
    private final Map<PeerAddress, Log> peerOfflineLogs;
    private final int cacheTimeout;
    private final int maxFail;
    private final AtomicInteger peerCount = new AtomicInteger();
    private final List<PeerMapChangeListener> peerMapChangeListeners = new ArrayList<PeerMapChangeListener>();
    private final List<PeerOfflineListener> peerListeners = new ArrayList<PeerOfflineListener>();
    private final int[] maintenanceTimeoutsSeconds;
    private final Map<PeerAddress, Long> maintenance = new LinkedHashMap<PeerAddress, Long>();
    private final Collection<InetAddress> filteredAddresses = Collections.synchronizedSet(new HashSet());
    private final PeerMapStat peerMapStat;
    private final Statistics statistics;

    public PeerMapKadImpl(Number160 self, int bagSize, int cacheSize, int cacheTimeout, int maxFail, int[] maintenanceTimeoutsSeconds) {
        if (self == null || self.isZero()) {
            throw new IllegalArgumentException("Zero or null are not a valid IDs");
        }
        this.self = self;
        this.peerMapStat = new PeerMapStat();
        this.bagSize = bagSize;
        this.maxPeers = bagSize * 160;
        this.cacheTimeout = cacheTimeout;
        this.maxFail = maxFail;
        this.maintenanceTimeoutsSeconds = maintenanceTimeoutsSeconds;
        this.peerOfflineLogs = new CacheMap<PeerAddress, Log>(cacheSize);
        this.statistics = new Statistics(this.peerMap, self, this.maxPeers, bagSize);
        for (int i = 0; i < 160; ++i) {
            this.peerMap.add(Collections.synchronizedMap(new HashMap()));
        }
    }

    @Override
    public void addPeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        this.peerMapChangeListeners.add(peerMapChangeListener);
    }

    @Override
    public void removePeerMapChangeListener(PeerMapChangeListener peerMapChangeListener) {
        this.peerMapChangeListeners.add(peerMapChangeListener);
    }

    @Override
    public void addPeerOfflineListener(PeerOfflineListener peerListener) {
        this.peerListeners.add(peerListener);
    }

    @Override
    public void removePeerOfflineListener(PeerOfflineListener peerListener) {
        this.peerListeners.remove(peerListener);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    private void notifyInsert(PeerAddress peerAddress) {
        this.statistics.triggerStatUpdate(true, this.size());
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerInserted(peerAddress);
        }
    }

    private void notifyRemove(PeerAddress peerAddress) {
        this.statistics.triggerStatUpdate(false, this.size());
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerRemoved(peerAddress);
        }
    }

    private void notifyUpdate(PeerAddress peerAddress) {
        for (PeerMapChangeListener listener : this.peerMapChangeListeners) {
            listener.peerUpdated(peerAddress);
        }
    }

    private void notifyOffline(PeerAddress peerAddress) {
        for (PeerOfflineListener listener : this.peerListeners) {
            listener.peerOffline(peerAddress);
        }
    }

    private void notifyPeerFail(PeerAddress peerAddress) {
        for (PeerOfflineListener listener : this.peerListeners) {
            listener.peerFail(peerAddress);
        }
    }

    @Override
    public int size() {
        return this.peerCount.get();
    }

    @Override
    public Number160 self() {
        return this.self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerOnline(PeerAddress remotePeer, PeerAddress referrer) {
        boolean firstHand;
        boolean bl = firstHand = referrer == null;
        if (firstHand) {
            Map<PeerAddress, Log> map = this.peerOfflineLogs;
            synchronized (map) {
                this.peerOfflineLogs.remove(remotePeer);
            }
        }
        if (remotePeer.getID().isZero() || this.self().equals(remotePeer.getID()) || this.isPeerRemovedTemporarly(remotePeer) || this.filteredAddresses.contains(remotePeer.getInetAddress()) || remotePeer.isFirewalledTCP()) {
            return false;
        }
        int classMember = this.classMember(remotePeer.getID());
        Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
        if (this.size() < this.maxPeers || map.containsKey(remotePeer.getID())) {
            this.prepareInsertOrUpdate(remotePeer, firstHand);
            return this.insertOrUpdate(map, remotePeer, classMember);
        }
        PeerAddress toRemove = this.removeLatestEntryExceedingBagSize();
        if (this.classMember(toRemove.getID()) > this.classMember(remotePeer.getID()) && this.remove(toRemove)) {
            this.prepareInsertOrUpdate(remotePeer, firstHand);
            return this.insertOrUpdate(map, remotePeer, classMember);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean peerOffline(PeerAddress remotePeer, boolean force) {
        Log log;
        if (logger.isDebugEnabled()) {
            logger.info("peer " + remotePeer + " is offline");
        }
        if (remotePeer.getID().isZero() || this.self().equals(remotePeer.getID())) {
            return false;
        }
        this.notifyPeerFail(remotePeer);
        Object object = this.peerOfflineLogs;
        synchronized (object) {
            log = this.peerOfflineLogs.get(remotePeer);
            if (log == null) {
                log = new Log();
                this.peerOfflineLogs.put(remotePeer, log);
            }
        }
        object = log;
        synchronized (object) {
            if (!force) {
                if (this.shouldPeerBeRemoved(log)) {
                    this.remove(remotePeer);
                    return true;
                }
                log.inc();
                if (!this.shouldPeerBeRemoved(log)) {
                    this.peerMapStat.removeStat(remotePeer);
                    this.addToMaintenanceQueue(remotePeer);
                    return false;
                }
            } else {
                log.set(this.maxFail);
            }
        }
        this.remove(remotePeer);
        return true;
    }

    private boolean remove(PeerAddress remotePeer) {
        boolean retVal;
        int classMember = this.classMember(remotePeer.getID());
        Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
        boolean bl = retVal = map.remove(remotePeer.getID()) != null;
        if (retVal) {
            this.removeFromMaintenance(remotePeer);
            this.peerCount.decrementAndGet();
            this.notifyRemove(remotePeer);
        }
        this.notifyOffline(remotePeer);
        return retVal;
    }

    private void prepareInsertOrUpdate(PeerAddress remotePeer, boolean firstHand) {
        if (firstHand) {
            long time;
            this.peerMapStat.setSeenOnlineTime(remotePeer);
            long online = this.peerMapStat.online(remotePeer);
            if (this.maintenanceTimeoutsSeconds.length > 0 && online >= (time = (long)this.maintenanceTimeoutsSeconds[this.peerMapStat.getChecked(remotePeer)] * 1000L)) {
                this.peerMapStat.incChecked(remotePeer);
            }
        }
        this.addToMaintenanceQueue(remotePeer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMaintenanceQueue(PeerAddress remotePeer) {
        long scheduledCheck;
        if (this.maintenanceTimeoutsSeconds.length == 0) {
            return;
        }
        if (this.peerMapStat.getLastSeenOnlineTime(remotePeer) == 0L) {
            scheduledCheck = System.currentTimeMillis();
        } else {
            int checked = this.peerMapStat.getChecked(remotePeer);
            if (checked >= this.maintenanceTimeoutsSeconds.length) {
                checked = this.maintenanceTimeoutsSeconds.length - 1;
            }
            scheduledCheck = System.currentTimeMillis() + (long)this.maintenanceTimeoutsSeconds[checked] * 1000L;
        }
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            this.maintenance.put(remotePeer, scheduledCheck);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PeerAddress> peersForMaintenance() {
        ArrayList<PeerAddress> result = new ArrayList<PeerAddress>();
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            Iterator<Map.Entry<PeerAddress, Long>> iterator = this.maintenance.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PeerAddress, Long> entry = iterator.next();
                if (entry.getValue() >= System.currentTimeMillis()) continue;
                iterator.remove();
                result.add(entry.getKey());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMaintenance(PeerAddress peerAddress) {
        Map<PeerAddress, Long> map = this.maintenance;
        synchronized (map) {
            this.maintenance.remove(peerAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertOrUpdate(Map<Number160, PeerAddress> map, PeerAddress remotePeer, int classMember) {
        boolean retVal;
        Map<Number160, PeerAddress> map2 = map;
        synchronized (map2) {
            retVal = !map.containsKey(remotePeer.getID());
            map.put(remotePeer.getID(), remotePeer);
        }
        if (retVal) {
            this.peerCount.incrementAndGet();
            this.notifyInsert(remotePeer);
        } else {
            this.notifyUpdate(remotePeer);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerAddress removeLatestEntryExceedingBagSize() {
        for (int classMember = 159; classMember >= 0; --classMember) {
            Map<Number160, PeerAddress> map = this.peerMap.get(classMember);
            if (map.size() <= this.bagSize) continue;
            long maxValue = Long.MAX_VALUE;
            int counter = 0;
            PeerAddress removePeerAddress = null;
            Map<Number160, PeerAddress> map2 = map;
            synchronized (map2) {
                for (PeerAddress peerAddress : map.values()) {
                    long lastSeenOline = this.peerMapStat.getLastSeenOnlineTime(peerAddress);
                    if (lastSeenOline < maxValue) {
                        maxValue = lastSeenOline;
                        removePeerAddress = peerAddress;
                    }
                    if (maxValue == 0L) break;
                    ++counter;
                }
            }
            if (removePeerAddress == null) continue;
            return removePeerAddress;
        }
        return null;
    }

    private boolean shouldPeerBeRemoved(Log log) {
        return System.currentTimeMillis() - log.getLastOffline() <= (long)this.cacheTimeout && log.getCounter() >= this.maxFail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPeerRemovedTemporarly(PeerAddress remoteNode) {
        Log log;
        Object object = this.peerOfflineLogs;
        synchronized (object) {
            log = this.peerOfflineLogs.get(remoteNode);
        }
        if (log != null) {
            object = log;
            synchronized (object) {
                if (this.shouldPeerBeRemoved(log)) {
                    return true;
                }
                if (System.currentTimeMillis() - log.getLastOffline() > (long)this.cacheTimeout) {
                    Map<PeerAddress, Log> map = this.peerOfflineLogs;
                    synchronized (map) {
                        this.peerOfflineLogs.remove(remoteNode);
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean contains(PeerAddress peerAddress) {
        int classMember = this.classMember(peerAddress.getID());
        Map<Number160, PeerAddress> tmp = this.peerMap.get(classMember);
        return tmp.containsKey(peerAddress.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<PeerAddress> closePeers(Number160 id, int atLeast) {
        Map<Number160, PeerAddress> map;
        int i;
        Map<Number160, PeerAddress> tmp;
        TreeSet<PeerAddress> set = new TreeSet<PeerAddress>(this.createPeerComparator(id));
        if (this.self().equals(id)) {
            for (int j = 0; set.size() < atLeast && j < 160; ++j) {
                Map<Number160, PeerAddress> tmp2;
                Map<Number160, PeerAddress> map2 = tmp2 = this.peerMap.get(j);
                synchronized (map2) {
                    set.addAll(tmp2.values());
                    continue;
                }
            }
            return set;
        }
        int classMember = this.classMember(id);
        Map<Number160, PeerAddress> map3 = tmp = this.peerMap.get(classMember);
        synchronized (map3) {
            set.addAll(tmp.values());
        }
        if (set.size() >= atLeast) {
            return set;
        }
        for (i = classMember - 1; i >= 0; --i) {
            map = tmp = this.peerMap.get(i);
            synchronized (map) {
                set.addAll(tmp.values());
                continue;
            }
        }
        if (set.size() >= atLeast) {
            return set;
        }
        for (i = classMember + 1; set.size() < atLeast && i < 160; ++i) {
            map = tmp = this.peerMap.get(i);
            synchronized (map) {
                set.addAll(tmp.values());
                continue;
            }
        }
        return set;
    }

    @Override
    public int isCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMapKadImpl.isKadCloser(id, rn, rn2);
    }

    @Override
    public int isCloser(Number160 id, Number160 rn, Number160 rn2) {
        return PeerMapKadImpl.distance(id, rn).compareTo(PeerMapKadImpl.distance(id, rn2));
    }

    private static int isKadCloser(Number160 id, PeerAddress rn, PeerAddress rn2) {
        return PeerMapKadImpl.distance(id, rn.getID()).compareTo(PeerMapKadImpl.distance(id, rn2.getID()));
    }

    private int classMember(Number160 remoteID) {
        return PeerMapKadImpl.classMember(this.self(), remoteID);
    }

    static int classMember(Number160 id1, Number160 id2) {
        return PeerMapKadImpl.distance(id1, id2).bitLength() - 1;
    }

    static Number160 distance(Number160 id1, Number160 id2) {
        return id1.xor(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("I'm node ");
        sb.append(this.self()).append("\n");
        for (int i = 0; i < 160; ++i) {
            Map<Number160, PeerAddress> tmp = this.peerMap.get(i);
            if (tmp.size() <= 0) continue;
            sb.append("class:").append(i).append("->\n");
            Map<Number160, PeerAddress> map = tmp;
            synchronized (map) {
                for (PeerAddress node : tmp.values()) {
                    sb.append("node:").append(node).append(",");
                }
                continue;
            }
        }
        return sb.toString();
    }

    @Override
    public Comparator<PeerAddress> createPeerComparator(final Number160 id) {
        return new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress remoteNode, PeerAddress remoteNode2) {
                return PeerMapKadImpl.isKadCloser(id, remoteNode, remoteNode2);
            }
        };
    }

    @Override
    public Comparator<PeerAddress> createPeerComparator() {
        return this.createPeerComparator(this.self);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<PeerAddress> getAll() {
        ArrayList<PeerAddress> all = new ArrayList<PeerAddress>();
        Iterator<Map<Number160, PeerAddress>> i$ = this.peerMap.iterator();
        while (i$.hasNext()) {
            Map<Number160, PeerAddress> map;
            Map<Number160, PeerAddress> map2 = map = i$.next();
            synchronized (map2) {
                all.addAll(map.values());
            }
        }
        return all;
    }

    @Override
    public void addAddressFilter(InetAddress address) {
        this.filteredAddresses.add(address);
    }

    class Log {
        private int counter;
        private long lastOffline;

        Log() {
        }

        private void inc() {
            ++this.counter;
            this.lastOffline = System.currentTimeMillis();
        }

        private void set(int counter) {
            this.counter = counter;
            this.lastOffline = System.currentTimeMillis();
        }

        private int getCounter() {
            return this.counter;
        }

        private long getLastOffline() {
            return this.lastOffline;
        }
    }
}

