/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;
import org.jboss.netty.buffer.ChannelBuffer;

public class FutureDHT
extends BaseFutureImpl {
    private final int min;
    private final EvaluatingSchemeDHT evaluationScheme;
    private volatile FutureCreate<FutureDHT> futureCreate;
    private Map<PeerAddress, Collection<Number160>> rawKeys;
    private Map<PeerAddress, Map<Number160, Data>> rawData;
    private Map<PeerAddress, Object> rawObjects;
    private Map<PeerAddress, ChannelBuffer> rawChannels;
    private ScheduledFuture<?> scheduledFuture;
    private List<ScheduledFuture<?>> scheduledFutures;
    private boolean cancelSchedule = false;
    private boolean minReached;

    public FutureDHT(int min) {
        this(min, new VotingSchemeDHT());
    }

    public FutureDHT(int min, EvaluatingSchemeDHT evaluationScheme) {
        this.min = min;
        this.evaluationScheme = evaluationScheme;
    }

    public void setFutureCreate(FutureCreate<FutureDHT> futureCreate) {
        if (futureCreate == null) {
            return;
        }
        this.futureCreate = futureCreate;
    }

    public void created(FutureDHT futureDHT) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(futureDHT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemovedKeys(Map<PeerAddress, Collection<Number160>> rawKeys) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoredKeys(Map<PeerAddress, Collection<Number160>> rawKeys, boolean ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawKeys = rawKeys;
            boolean bl = this.minReached = rawKeys.size() >= this.min;
            if (ifAbsent) {
                this.type = BaseFuture.FutureType.OK;
                this.reason = "ok, since store if absent";
            } else {
                this.type = BaseFuture.FutureType.FAILED;
                this.reason = "Key size is zero";
                for (Collection<Number160> result : rawKeys.values()) {
                    if (result.size() <= 0) continue;
                    this.type = BaseFuture.FutureType.OK;
                    this.reason = "size ok";
                    break;
                }
            }
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(Map<PeerAddress, Map<Number160, Data>> rawData) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawData = rawData;
            int size = rawData.size();
            this.type = size > 0 ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
            this.reason = size > 0 ? "size ok" : " DHT size is zero";
            this.minReached = rawData.size() >= this.min;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Collection<Number160>> getRawKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> getKeys() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate1(this.rawKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<Number160, Data>> getRawData() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, Data> getData() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate2(this.rawData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMinReached() {
        Object object = this.lock;
        synchronized (object) {
            return this.minReached;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData1(Map<PeerAddress, ChannelBuffer> rawChannels) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawChannels = rawChannels;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, ChannelBuffer> getRawDirectData1() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectData2(Map<PeerAddress, Object> rawObjects) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.rawObjects = rawObjects;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Object> getRawDirectData2() {
        Object object = this.lock;
        synchronized (object) {
            return this.rawObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture, List<ScheduledFuture<?>> scheduledFutures) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduledFuture = scheduledFuture;
            this.scheduledFutures = scheduledFutures;
            if (this.cancelSchedule) {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelSchedule = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (this.scheduledFutures != null) {
                this.scheduledFutures.remove(this.scheduledFuture);
            }
        }
        super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate3(this.rawObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getChannelBuffer() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluationScheme.evaluate4(this.rawChannels);
        }
    }
}

