/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionCollector;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.DispatcherReply;
import net.tomp2p.connection.DispatcherRequest;
import net.tomp2p.connection.IdleStateHandler;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PerformanceFilter;
import net.tomp2p.connection.Sender;
import net.tomp2p.connection.TCPChannelCache;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderStage1;
import net.tomp2p.message.TomP2PEncoderStage2;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.traffic.GlobalTrafficShapingHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);
    private final ConnectionBean connectionBean;
    private final PeerBean peerBean;
    public static final int UDP_LIMIT = 1400;
    private static final PerformanceFilter performanceFilter = new PerformanceFilter();
    private final List<ConnectionHandler> childConnections = new ArrayList<ConnectionHandler>();
    private final Map<InternetGatewayDevice, InetSocketAddress> internetGatewayDevicesUDP = new HashMap<InternetGatewayDevice, InetSocketAddress>();
    private final Map<InternetGatewayDevice, InetSocketAddress> internetGatewayDevicesTCP = new HashMap<InternetGatewayDevice, InetSocketAddress>();
    private final TCPChannelCache channelChache;
    private final Timer timer;
    private final boolean master;
    public static final String THREAD_NAME = "Netty thread (non-blocking)/ ";
    private static final TomP2PEncoderStage1 encoder1 = new TomP2PEncoderStage1();
    private static final TomP2PEncoderStage2 encoder2 = new TomP2PEncoderStage2();
    private final ExecutionHandler executionHandlerSend;
    private final ExecutionHandler executionHandlerRcv;
    private final ChannelFactory udpChannelFactory;
    private final ChannelFactory tcpServerChannelFactory;
    private final ChannelFactory tcpClientChannelFactory;
    private final MessageLogger messageLoggerFilter;
    private final ConnectionConfiguration configuration;
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;

    public ConnectionHandler(int udpPort, int tcpPort, Number160 id, Bindings bindings, int p2pID, ConnectionConfiguration configuration, File messageLogger, KeyPair keyPair, PeerMap peerMap, List<PeerListener> listeners) throws Exception {
        PeerAddress self;
        this.configuration = configuration;
        this.timer = new HashedWheelTimer();
        ThreadPoolExecutor t1 = new ThreadPoolExecutor(5, configuration.getMaxIncomingThreads(), 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(configuration.getMaxIncomingThreads(), true));
        t1.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        ExecutorService t2 = Executors.newCachedThreadPool();
        this.executionHandlerRcv = new ExecutionHandler((Executor)t1);
        this.executionHandlerSend = new ExecutionHandler((Executor)t2);
        this.udpChannelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.tcpServerChannelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.tcpClientChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.globalTrafficShapingHandler = new GlobalTrafficShapingHandler((Executor)Executors.newCachedThreadPool(), configuration.getWriteLimit(), configuration.getReadLimit(), 500L);
        String status = bindings.discoverLocalInterfaces();
        logger.info("Status of interface search: " + status);
        InetAddress outsideAddress = bindings.getOutsideAddress();
        if (outsideAddress != null) {
            self = new PeerAddress(id, outsideAddress, bindings.getOutsideTCPPort(), bindings.getOutsideUDPPort(), true, true, true);
        } else {
            if (bindings.getAddresses().size() == 0) {
                throw new IOException("Not listening to anything. Maybe your binding information is wrong.");
            }
            outsideAddress = bindings.getAddresses().get(0);
            self = new PeerAddress(id, outsideAddress, tcpPort, udpPort);
        }
        this.peerBean = new PeerBean(keyPair);
        this.peerBean.setServerPeerAddress(self);
        this.peerBean.setPeerMap(peerMap);
        logger.info("Visible address to other peers: " + self);
        DefaultChannelGroup channelGroup = new DefaultChannelGroup("TomP2P ConnectionHandler");
        ConnectionCollector connectionPool = new ConnectionCollector(this.tcpClientChannelFactory, this.udpChannelFactory, configuration, this.executionHandlerSend, this.globalTrafficShapingHandler);
        this.channelChache = new TCPChannelCache(connectionPool, this.timer, (ChannelGroup)channelGroup);
        DispatcherRequest dispatcherRequest = new DispatcherRequest(p2pID, this.peerBean, configuration.getIdleUDPMillis(), configuration.getTimeoutTCPMillis(), (ChannelGroup)channelGroup, peerMap, listeners, this.channelChache);
        this.channelChache.setDispatcherRequest(dispatcherRequest);
        this.messageLoggerFilter = messageLogger == null ? null : new MessageLogger(messageLogger);
        Sender sender = new Sender(connectionPool, configuration, this.channelChache, this.timer);
        this.connectionBean = new ConnectionBean(p2pID, dispatcherRequest, sender, (ChannelGroup)channelGroup);
        if (bindings.isListenBroadcast()) {
            logger.info("Listening for broadcasts on port udp: " + udpPort + " and tcp:" + tcpPort);
            if (!this.startupTCP(new InetSocketAddress(tcpPort), dispatcherRequest, configuration.getMaxMessageSize()) || !this.startupUDP(new InetSocketAddress(udpPort), dispatcherRequest)) {
                throw new IOException("cannot bind TCP or UDP");
            }
        } else {
            for (InetAddress addr : bindings.getAddresses()) {
                logger.info("Listening on address: " + addr + " on port udp: " + udpPort + " and tcp:" + tcpPort);
                if (this.startupTCP(new InetSocketAddress(addr, tcpPort), dispatcherRequest, configuration.getMaxMessageSize()) && this.startupUDP(new InetSocketAddress(addr, udpPort), dispatcherRequest)) continue;
                throw new IOException("cannot bind TCP or UDP");
            }
        }
        this.master = true;
    }

    public ConnectionHandler(ConnectionHandler parent, Number160 id, KeyPair keyPair, PeerMap peerMap) {
        parent.childConnections.add(this);
        this.connectionBean = parent.connectionBean;
        PeerAddress self = new PeerAddress(id, parent.getPeerBean().getServerPeerAddress());
        this.peerBean = new PeerBean(keyPair);
        this.peerBean.setServerPeerAddress(self);
        this.peerBean.setPeerMap(peerMap);
        this.executionHandlerSend = parent.executionHandlerSend;
        this.executionHandlerRcv = parent.executionHandlerRcv;
        this.messageLoggerFilter = parent.messageLoggerFilter;
        this.udpChannelFactory = parent.udpChannelFactory;
        this.tcpServerChannelFactory = parent.tcpServerChannelFactory;
        this.tcpClientChannelFactory = parent.tcpClientChannelFactory;
        this.channelChache = parent.channelChache;
        this.configuration = parent.configuration;
        this.timer = parent.timer;
        this.globalTrafficShapingHandler = parent.globalTrafficShapingHandler;
        this.master = false;
    }

    public ConnectionBean getConnectionBean() {
        return this.connectionBean;
    }

    public boolean startupUDP(InetSocketAddress listenAddressesUDP, final DispatcherRequest dispatcher) throws Exception {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline p = Channels.pipeline();
                p.addLast("encoder2", (ChannelHandler)encoder2);
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    p.addLast("loggerDownstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter.getChannelDownstreamHandler());
                }
                p.addLast("encoder1", (ChannelHandler)encoder1);
                p.addLast("decoder", (ChannelHandler)new TomP2PDecoderUDP());
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    p.addLast("loggerUpstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter.getChannelUpstreamHandler());
                }
                p.addLast("performance", (ChannelHandler)performanceFilter);
                p.addLast("executor", (ChannelHandler)ConnectionHandler.this.executionHandlerRcv);
                p.addLast("handler", (ChannelHandler)dispatcher);
                return p;
            }
        });
        bootstrap.setOption("broadcast", (Object)"false");
        Channel channel = bootstrap.bind((SocketAddress)listenAddressesUDP);
        logger.info("Listening on UDP socket: " + listenAddressesUDP);
        this.connectionBean.getChannelGroup().add((Object)channel);
        return channel.isBound();
    }

    public boolean startupTCP(InetSocketAddress listenAddressesTCP, DispatcherRequest dispatcher, int maxMessageSize) throws Exception {
        ServerBootstrap bootstrap = new ServerBootstrap(this.tcpServerChannelFactory);
        this.setupBootstrapTCP((Bootstrap)bootstrap, dispatcher, maxMessageSize);
        Channel channel = bootstrap.bind((SocketAddress)listenAddressesTCP);
        this.connectionBean.getChannelGroup().add((Object)channel);
        logger.info("Listening on TCP socket: " + listenAddressesTCP);
        return channel.isBound();
    }

    private void setupBootstrapTCP(Bootstrap bootstrap, final DispatcherRequest dispatcher, final int maxMessageSize) {
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline p = Channels.pipeline();
                IdleStateHandler timeoutHandler = new IdleStateHandler(ConnectionHandler.this.timer, ConnectionHandler.this.configuration.getIdleTCPMillis(), TimeUnit.MILLISECONDS);
                p.addLast("timeout", (ChannelHandler)timeoutHandler);
                p.addLast("encoder2", (ChannelHandler)encoder2);
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    p.addLast("loggerDownstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter.getChannelDownstreamHandler());
                }
                p.addLast("encoder1", (ChannelHandler)encoder1);
                p.addLast("decoder", (ChannelHandler)new TomP2PDecoderTCP(maxMessageSize));
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    p.addLast("loggerUpstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter.getChannelUpstreamHandler());
                }
                p.addLast("performance", (ChannelHandler)performanceFilter);
                if (ConnectionHandler.this.globalTrafficShapingHandler.hasLimit()) {
                    p.addLast("trafficShaping", (ChannelHandler)ConnectionHandler.this.globalTrafficShapingHandler);
                }
                p.addLast("executor", (ChannelHandler)ConnectionHandler.this.executionHandlerRcv);
                DispatcherReply dispatcherReply = new DispatcherReply(ConnectionHandler.this.timer, ConnectionHandler.this.configuration.getIdleTCPMillis(), dispatcher, ConnectionHandler.this.getConnectionBean().getChannelGroup());
                p.addLast("reply", (ChannelHandler)dispatcherReply);
                return p;
            }
        });
        bootstrap.setOption("broadcast", (Object)"false");
    }

    public PeerBean getPeerBean() {
        return this.peerBean;
    }

    public void customLoggerMessage(String customMessage) {
        if (this.messageLoggerFilter != null) {
            this.messageLoggerFilter.customMessage(customMessage);
        } else {
            logger.error("cannot write to log, as no file was provided");
        }
    }

    public void shutdown() {
        if (this.master) {
            logger.debug("shutdown in progress...");
        }
        this.connectionBean.getDispatcherRequest().removeIoHandler(this.getPeerBean().getServerPeerAddress().getID());
        for (ConnectionHandler handler : this.childConnections) {
            handler.shutdown();
        }
        if (this.master) {
            this.unmapUPNP();
            this.timer.stop();
            if (this.messageLoggerFilter != null) {
                this.messageLoggerFilter.close();
            }
            this.connectionBean.getChannelGroup().close().awaitUninterruptibly();
            this.connectionBean.getSender().shutdown();
            this.executionHandlerSend.releaseExternalResources();
            this.executionHandlerRcv.releaseExternalResources();
            this.udpChannelFactory.releaseExternalResources();
            this.tcpServerChannelFactory.releaseExternalResources();
            this.tcpClientChannelFactory.releaseExternalResources();
            logger.debug("shutdown complete");
        }
    }

    public void unmapUPNP() {
        for (Map.Entry<InternetGatewayDevice, InetSocketAddress> entry : this.internetGatewayDevicesTCP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(entry.getValue().getHostName(), entry.getValue().getPort(), "TCP");
            }
            catch (IOException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + (Object)((Object)e));
            }
            logger.info("removed TCP mapping " + entry.toString());
        }
        for (Map.Entry<InternetGatewayDevice, InetSocketAddress> entry : this.internetGatewayDevicesUDP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(entry.getValue().getHostName(), entry.getValue().getPort(), "UDP");
            }
            catch (IOException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + (Object)((Object)e));
            }
            logger.info("removed UDP mapping " + entry.toString());
        }
    }

    public void mapUPNP(InetAddress internalAddress, int internalPortUDP, int internalPortTCP, InetAddress externalAddress, int externalPortUDP, int externalPortTCP) throws IOException, UPNPResponseException {
        int discoveryTimeoutMillis = 2500;
        Collection IGDs = InternetGatewayDevice.getDevices((int)discoveryTimeoutMillis);
        if (IGDs == null) {
            return;
        }
        for (InternetGatewayDevice igd : IGDs) {
            boolean mappedTCP;
            boolean mappedUDP;
            logger.info("Found device " + igd);
            if (externalPortUDP != -1 && (mappedUDP = igd.addPortMapping("TomP2P mapping UDP", "UDP", externalAddress.getHostName(), externalPortUDP, internalAddress.getHostAddress(), internalPortUDP, 0))) {
                this.addMappingUDP(igd, externalAddress, externalPortUDP);
            }
            if (!(mappedTCP = igd.addPortMapping("TomP2P mapping TCP", "TCP", externalAddress.getHostName(), externalPortTCP, internalAddress.getHostAddress(), internalPortTCP, 0))) continue;
            this.addMappingTCP(igd, externalAddress, externalPortTCP);
        }
    }

    private void addMappingTCP(InternetGatewayDevice igd, InetAddress externalAddress, int externalPortTCP) {
        this.internetGatewayDevicesTCP.put(igd, new InetSocketAddress(externalAddress, externalPortTCP));
    }

    private void addMappingUDP(InternetGatewayDevice igd, InetAddress externalAddress, int externalPortUDP) {
        this.internetGatewayDevicesUDP.put(igd, new InetSocketAddress(externalAddress, externalPortUDP));
    }

    public boolean isListening() {
        return !this.getConnectionBean().getChannelGroup().isEmpty();
    }

    static {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new ThreadNameDeterminer(){

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return ConnectionHandler.THREAD_NAME + currentThreadName;
            }
        });
    }
}

