/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.p2p.EvaluatingSchemeTracker;
import net.tomp2p.p2p.VotingSchemeTracker;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.storage.Data;

public class FutureTracker
extends BaseFutureImpl {
    private final EvaluatingSchemeTracker evaluatingSchemeTracker;
    private volatile FutureCreate<FutureTracker> futureCreate;
    private Set<PeerAddress> potentialTrackers;
    private Set<PeerAddress> directTrackers;
    private Map<PeerAddress, Map<PeerAddress, Data>> peersOnTracker;
    private ScheduledFuture<?> scheduledFuture;
    private List<ScheduledFuture<?>> scheduledFutures;
    private boolean cancelSchedule = false;

    public FutureTracker() {
        this(new VotingSchemeTracker());
    }

    public FutureTracker(EvaluatingSchemeTracker evaluatingSchemeTracker) {
        this.evaluatingSchemeTracker = evaluatingSchemeTracker;
    }

    public void setFutureCreate(FutureCreate<FutureTracker> futureCreate) {
        if (futureCreate == null) {
            return;
        }
        this.futureCreate = futureCreate;
    }

    public void repeated(FutureTracker futureDHT) {
        if (this.futureCreate != null) {
            this.futureCreate.repeated(futureDHT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackers(Set<PeerAddress> potentialTrackers, Set<PeerAddress> directTrackers, Map<PeerAddress, Map<PeerAddress, Data>> peersOnTracker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.potentialTrackers = potentialTrackers;
            this.directTrackers = directTrackers;
            this.peersOnTracker = peersOnTracker;
            this.type = potentialTrackers.size() == 0 && directTrackers.size() == 0 ? BaseFuture.FutureType.FAILED : BaseFuture.FutureType.OK;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPotentialTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.potentialTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getDirectTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.directTrackers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Map<PeerAddress, Data>> getRawPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<PeerAddress> getPeersOnTracker() {
        Object object = this.lock;
        synchronized (object) {
            return this.peersOnTracker.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Data> getTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluatingSchemeTracker.evaluateSingle(this.peersOnTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<PeerAddress, Set<Data>> getCumulativeTrackers() {
        Object object = this.lock;
        synchronized (object) {
            return this.evaluatingSchemeTracker.evaluate(this.peersOnTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduledFuture(ScheduledFuture<?> scheduledFuture, List<ScheduledFuture<?>> scheduledFutures) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduledFuture = scheduledFuture;
            this.scheduledFutures = scheduledFutures;
            if (this.cancelSchedule) {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelSchedule = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if (this.scheduledFutures != null) {
                this.scheduledFutures.remove(this.scheduledFuture);
            }
        }
        super.cancel();
    }
}

