/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfiguration;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.futures.FutureData;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.p2p.DistributedHashHashMap;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.P2PConfiguration;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.Routing;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.p2p.config.ConfigurationDirect;
import net.tomp2p.p2p.config.ConfigurationGet;
import net.tomp2p.p2p.config.ConfigurationRemove;
import net.tomp2p.p2p.config.ConfigurationStore;
import net.tomp2p.p2p.config.ConfigurationTrackerGet;
import net.tomp2p.p2p.config.ConfigurationTrackerStore;
import net.tomp2p.p2p.config.Configurations;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapKadImpl;
import net.tomp2p.replication.DefaultStorageReplication;
import net.tomp2p.replication.DefaultTrackerReplication;
import net.tomp2p.replication.Replication;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.StorageMemory;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    private static final KeyPair EMPTY_KEYPAIR = new KeyPair(null, null);
    private ConnectionHandler connectionHandler;
    private final Number160 peerId;
    private final int p2pID;
    private final KeyPair keyPair;
    private DistributedHashHashMap dht;
    private DistributedTracker tracker;
    private HandshakeRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private Routing routing;
    private Bindings bindings;
    private final P2PConfiguration peerConfiguration;
    private final ConnectionConfiguration connectionConfiguration;
    private ScheduledExecutorService scheduledExecutorServiceMaintenance;
    private ScheduledExecutorService scheduledExecutorServiceReplication;
    private final Map<BaseFuture, Long> pendingFutures = Collections.synchronizedMap(new CacheMap(1000));
    private boolean masterFlag = true;
    private List<ScheduledFuture<?>> scheduledFutures = Collections.synchronizedList(new ArrayList());
    private final List<PeerListener> listeners = new ArrayList<PeerListener>();

    public Peer(KeyPair keyPair) {
        this(Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(Number160 nodeId) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), EMPTY_KEYPAIR);
    }

    public Peer(Number160 nodeId, KeyPair keyPair) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), keyPair);
    }

    public Peer(int p2pID, KeyPair keyPair) {
        this(p2pID, Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, KeyPair keyPair) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfiguration(), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId, ConnectionConfiguration connectionConfiguration) {
        this(p2pID, nodeId, new P2PConfiguration(), connectionConfiguration, EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, P2PConfiguration peerConfiguration, ConnectionConfiguration connectionConfiguration, KeyPair keyPair) {
        this.p2pID = p2pID;
        this.peerId = nodeId;
        this.peerConfiguration = peerConfiguration;
        this.connectionConfiguration = connectionConfiguration;
        this.keyPair = keyPair;
    }

    public void addPeerListener(PeerListener listener) {
        if (this.isRunning()) {
            listener.notifyOnStart();
        }
        this.listeners.add(listener);
    }

    public void removePeerListener() {
        this.listeners.remove(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info("shutdown in progres");
        List<ScheduledFuture<?>> list = this.scheduledFutures;
        synchronized (list) {
            for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        if (this.masterFlag && this.scheduledExecutorServiceMaintenance != null) {
            this.scheduledExecutorServiceMaintenance.shutdownNow();
        }
        if (this.masterFlag && this.scheduledExecutorServiceReplication != null) {
            this.scheduledExecutorServiceReplication.shutdownNow();
        }
        this.getConnectionHandler().shutdown();
        for (PeerListener listener : this.listeners) {
            listener.notifyOnShutdown();
        }
        this.connectionHandler = null;
    }

    public void listen() throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort());
    }

    public void listen(File messageLogger) throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings());
    }

    public void listen(int udpPort, int tcpPort, File messageLogger) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort, InetAddress bind) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(bind), null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings) throws Exception {
        this.listen(udpPort, tcpPort, bindings, null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings, File messageLogger) throws Exception {
        this.masterFlag = true;
        this.bindings = bindings;
        this.scheduledExecutorServiceMaintenance = Executors.newScheduledThreadPool(this.peerConfiguration.getMaintenanceThreads());
        this.scheduledExecutorServiceReplication = Executors.newScheduledThreadPool(this.peerConfiguration.getReplicationThreads());
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration.getBagSize(), this.peerConfiguration.getCacheSize(), this.peerConfiguration.getCacheTimeoutMillis(), this.connectionConfiguration.getMaxNrBeforeExclude(), this.peerConfiguration.getWaitingTimeBetweenNodeMaintenenceSeconds());
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(udpPort, tcpPort, this.peerId, bindings, this.getP2PID(), this.connectionConfiguration, messageLogger, this.keyPair, peerMap, this.listeners), statistics);
    }

    public void listen(Peer master) throws Exception {
        this.masterFlag = false;
        this.bindings = master.bindings;
        this.scheduledExecutorServiceMaintenance = master.scheduledExecutorServiceMaintenance;
        this.scheduledExecutorServiceReplication = master.scheduledExecutorServiceReplication;
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration.getBagSize(), this.peerConfiguration.getCacheSize(), this.peerConfiguration.getCacheTimeoutMillis(), this.connectionConfiguration.getMaxNrBeforeExclude(), this.peerConfiguration.getWaitingTimeBetweenNodeMaintenenceSeconds());
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(master.getConnectionHandler(), this.peerId, this.keyPair, peerMap), statistics);
    }

    protected void init(ConnectionHandler connectionHandler, Statistics statistics) {
        this.connectionHandler = connectionHandler;
        PeerBean peerBean = connectionHandler.getPeerBean();
        peerBean.setStatistics(statistics);
        ConnectionBean connectionBean = connectionHandler.getConnectionBean();
        PeerAddress selfAddress = this.getPeerAddress();
        PeerMap peerMap = connectionHandler.getPeerBean().getPeerMap();
        StorageMemory storage = new StorageMemory();
        peerBean.setStorage(storage);
        Replication replicationStorage = new Replication(storage, selfAddress, peerMap);
        peerBean.setReplicationStorage(replicationStorage);
        TrackerStorage storageTracker = new TrackerStorage();
        peerBean.setTrackerStorage(storageTracker);
        Replication replicationTracker = new Replication(storageTracker, selfAddress, peerMap);
        peerBean.setReplicationTracker(replicationTracker);
        this.handshakeRCP = new HandshakeRPC(peerBean, connectionBean);
        this.storageRPC = new StorageRPC(peerBean, connectionBean);
        this.neighborRPC = new NeighborRPC(peerBean, connectionBean);
        this.quitRCP = new QuitRPC(peerBean, connectionBean);
        this.directDataRPC = new DirectDataRPC(peerBean, connectionBean);
        this.trackerRPC = new TrackerRPC(peerBean, connectionBean);
        this.routing = new Routing(peerBean, this.neighborRPC);
        this.dht = new DistributedHashHashMap(this.routing, this.storageRPC, this.directDataRPC);
        this.tracker = new DistributedTracker(peerBean, this.routing, this.trackerRPC);
        if (this.peerConfiguration.isStartMaintenance()) {
            this.startMaintainance();
        }
        for (PeerListener listener : this.listeners) {
            listener.notifyOnStart();
        }
    }

    public void setDefaultStorageReplication() {
        Replication replicationStorage = this.getPeerBean().getReplicationStorage();
        DefaultStorageReplication defaultStorageReplication = new DefaultStorageReplication(this, replicationStorage.getStorage(), this.storageRPC, this.pendingFutures);
        this.scheduledFutures.add(this.addIndirectReplicaiton(defaultStorageReplication));
        replicationStorage.addResponsibilityListener(defaultStorageReplication);
    }

    public void setDefaultTrackerReplication() {
        Replication replicationTracker = this.getPeerBean().getReplicationTracker();
        DefaultTrackerReplication defaultTrackerReplication = new DefaultTrackerReplication(replicationTracker.getStorage(), this.trackerRPC, this.pendingFutures, this.getPeerBean().getStatistics());
        replicationTracker.addResponsibilityListener(defaultTrackerReplication);
    }

    public Map<BaseFuture, Long> getPendingFutures() {
        return this.pendingFutures;
    }

    public boolean isRunning() {
        return this.connectionHandler != null;
    }

    public boolean isListening() {
        if (!this.isRunning()) {
            return false;
        }
        return this.connectionHandler.isListening();
    }

    void startMaintainance() {
        this.scheduledFutures.add(this.addMaintainance(new Maintenance(this.connectionHandler.getPeerBean().getPeerMap(), this.handshakeRCP, this.peerConfiguration)));
    }

    public void customLoggerMessage(String customMessage) {
        this.getConnectionHandler().customLoggerMessage(customMessage);
    }

    public HandshakeRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.handshakeRCP;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.storageRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.quitRCP;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.trackerRPC;
    }

    public Routing getRouting() {
        if (this.routing == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.routing;
    }

    public ScheduledFuture<?> addIndirectReplicaiton(Runnable runnable) {
        return this.scheduledExecutorServiceReplication.scheduleWithFixedDelay(runnable, this.peerConfiguration.getReplicationRefreshMillis(), this.peerConfiguration.getReplicationRefreshMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> addMaintainance(Runnable runnable) {
        return this.scheduledExecutorServiceMaintenance.scheduleWithFixedDelay(runnable, 0L, this.peerConfiguration.getWaitingTimeBetweenNodeMaintenenceSeconds()[0] / 2, TimeUnit.SECONDS);
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.connectionHandler;
    }

    public DistributedHashHashMap getDHT() {
        if (this.dht == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.dht;
    }

    public DistributedTracker getTracker() {
        if (this.tracker == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.tracker;
    }

    public PeerBean getPeerBean() {
        return this.getConnectionHandler().getPeerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.getConnectionHandler().getConnectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public void setPeerMap(PeerMap peerMap) {
        this.getPeerBean().setPeerMap(peerMap);
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer) {
        return this.send("any", remotePeer, requestBuffer);
    }

    public FutureData send(String channelName, PeerAddress remotePeer, ChannelBuffer requestBuffer) {
        return this.getDirectDataRPC().send(channelName, remotePeer, requestBuffer.slice(), true);
    }

    public FutureData send(PeerAddress remotePeer, Object object) throws IOException {
        return this.send("any", remotePeer, object);
    }

    public FutureData send(String channelName, PeerAddress remotePeer, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.getDirectDataRPC().send(channelName, remotePeer, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    public FutureBootstrap bootstrapBroadcast() {
        return this.bootstrapBroadcast(this.connectionConfiguration.getDefaultPort());
    }

    public FutureBootstrap bootstrapBroadcast(int port) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureForkJoin<FutureResponse> tmp = this.pingBroadcast(port);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                if (future.isSuccess()) {
                    ArrayList<PeerAddress> peerAddresses = new ArrayList<PeerAddress>();
                    PeerAddress sender = future.getLast().getResponse().getSender();
                    peerAddresses.add(sender);
                    result.waitForBootstrap(Peer.this.bootstrap(peerAddresses), sender);
                } else {
                    result.setFailed("could not reach anyone with the broadcast");
                }
            }
        });
        return result;
    }

    FutureForkJoin<FutureResponse> pingBroadcast(int port) {
        int size = this.bindings.getBroadcastAddresses().size();
        if (size > 0) {
            BaseFuture[] validBroadcast = new FutureResponse[size];
            for (int i = 0; i < size; ++i) {
                InetAddress broadcastAddress = this.bindings.getBroadcastAddresses().get(i);
                PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                validBroadcast[i] = this.getHandshakeRPC().pingBroadcastUDP(peerAddress);
                logger.debug("ping broadcast to " + broadcastAddress);
            }
            FutureForkJoin pings = new FutureForkJoin(1, true, validBroadcast);
            return pings;
        }
        throw new IllegalArgumentException("No broadcast address found. Cannot ping nothing");
    }

    public FutureResponse ping(InetSocketAddress address) {
        return this.getHandshakeRPC().pingUDP(new PeerAddress(Number160.ZERO, address));
    }

    public FutureBootstrap bootstrap(InetSocketAddress address) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureResponse tmp = this.ping(address);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    ArrayList<PeerAddress> peerAddresses = new ArrayList<PeerAddress>();
                    PeerAddress sender = future.getResponse().getSender();
                    peerAddresses.add(sender);
                    result.waitForBootstrap(Peer.this.bootstrap(peerAddresses), sender);
                } else {
                    result.setFailed("could not reach anyone with the broadcast");
                }
            }
        });
        return result;
    }

    public FutureBootstrap bootstrap(Collection<PeerAddress> peerAddresses) {
        return this.bootstrap(peerAddresses, Configurations.defaultStoreConfiguration());
    }

    public FutureBootstrap bootstrap(Collection<PeerAddress> peerAddresses, ConfigurationStore config) {
        return this.routing.bootstrap(peerAddresses, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getParallel(), false);
    }

    public FutureBootstrap bootstrap(PeerAddress peerAddress) {
        ArrayList<PeerAddress> peerAddresses = new ArrayList<PeerAddress>();
        peerAddresses.add(peerAddress);
        return this.bootstrap(peerAddresses);
    }

    public FutureDiscover discover(final PeerAddress peerAddress) {
        final FutureDiscover futureDiscover = new FutureDiscover(this.peerConfiguration.getDiscoverTimeoutSec());
        FutureLateJoin<FutureResponse> late = new FutureLateJoin<FutureResponse>(2);
        final FutureResponse futureResponseTCP = this.getHandshakeRPC().pingTCPDiscover(peerAddress);
        final FutureResponse futureResponseUDP = this.getHandshakeRPC().pingUDPDiscover(peerAddress);
        late.add(futureResponseTCP);
        late.add(futureResponseUDP);
        this.addPeerListener(new PeerListener(){

            @Override
            public void serverAddressChanged(PeerAddress peerAddress) {
                futureDiscover.done(peerAddress);
            }

            @Override
            public void notifyOnStart() {
            }

            @Override
            public void notifyOnShutdown() {
            }
        });
        late.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureLateJoin<FutureResponse>>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void operationComplete(FutureLateJoin<FutureResponse> future) throws Exception {
                boolean mapped = false;
                PeerAddress serverAddress = Peer.this.getPeerBean().getServerPeerAddress();
                if (!futureResponseTCP.isSuccess()) {
                    futureDiscover.setFailed("We need at least the TCP connection");
                    return;
                }
                Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighbors();
                if (tmp.size() != 1) {
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                PeerAddress seenAs = tmp.iterator().next();
                if (!Peer.this.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                    Peer.this.connectionHandler.mapUPNP(serverAddress.getInetAddress(), seenAs.getInetAddress(), serverAddress.portUDP(), serverAddress.portTCP());
                    mapped = true;
                    Peer.this.getPeerBean().setServerPeerAddress(serverAddress.forward(seenAs.getInetAddress()));
                }
                Peer.this.getHandshakeRPC().pingTCPProbe(peerAddress);
                serverAddress = Peer.this.getPeerBean().getServerPeerAddress();
                if (!futureResponseUDP.isSuccess()) {
                    futureDiscover.onGoing(false, true);
                    return;
                }
                tmp = futureResponseUDP.getResponse().getNeighbors();
                if (tmp.size() != 1) {
                    futureDiscover.onGoing(false, true);
                    return;
                }
                seenAs = tmp.iterator().next();
                if (!mapped && !Peer.this.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                    Peer.this.connectionHandler.mapUPNP(serverAddress.getInetAddress(), seenAs.getInetAddress(), serverAddress.portUDP(), serverAddress.portTCP());
                    Peer.this.getPeerBean().setServerPeerAddress(serverAddress.forward(seenAs.getInetAddress()));
                }
                Peer.this.getHandshakeRPC().pingUDPProbe(peerAddress);
                futureDiscover.onGoing(true, true);
            }
        });
        return futureDiscover;
    }

    public FutureDHT put(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.put(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        if (data.isProtectedEntry()) {
            try {
                data.signAndSetPublicKey(this.keyPair);
            }
            catch (Exception e) {
                FutureDHT futureDHT = new FutureDHT(0);
                futureDHT.setFailed("Error in put " + e);
                logger.error("Error in put " + e);
                e.printStackTrace();
                return futureDHT;
            }
        }
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
        dataMap.put(config.getContentKey(), data);
        return this.put0(locationKey, dataMap, config);
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        try {
            this.protectEntry(dataMap);
        }
        catch (Exception e) {
            FutureDHT futureDHT = new FutureDHT(0);
            futureDHT.setFailed("Error in put " + e);
            logger.error("Error in put " + e);
            e.printStackTrace();
            return futureDHT;
        }
        return this.put(locationKey, dataMap, config);
    }

    private void protectEntry(Map<Number160, Data> dataMap) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        for (Data data : dataMap.values()) {
            if (!data.isProtectedEntry()) continue;
            data.signAndSetPublicKey(this.keyPair);
        }
    }

    private FutureDHT put0(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config) {
        FutureDHT futureDHT = this.getDHT().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.schedulePut(locationKey, dataMap, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> schedulePut(final Number160 locationKey, Map<Number160, Data> dataMap, final ConfigurationStore config, final FutureDHT futureDHT) {
        final HashSet<Number480> keys = new HashSet<Number480>();
        for (Map.Entry<Number160, Data> entry : dataMap.entrySet()) {
            Number160 contentKey = entry.getKey();
            Number480 key = new Number480(locationKey, config.getDomain(), contentKey);
            entry.getValue().setDataPublicKey(this.keyPair.getPublic());
            this.getPeerBean().getStorage().put(key, entry.getValue(), this.keyPair.getPublic(), config.isStoreIfAbsent(), config.isProtectDomain());
            keys.add(key);
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Map<Number160, Data> dataMap2 = Peer.this.getPeerBean().getStorage().get(keys, Peer.this.keyPair.getPublic());
                FutureDHT futureDHT2 = Peer.this.getDHT().put(locationKey, config.getDomain(), dataMap2, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate());
                futureDHT.created(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT add(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.add(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        ArrayList<Data> dataCollection = new ArrayList<Data>();
        dataCollection.add(data);
        return this.add(locationKey, dataCollection, config);
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        if (config.getContentKey() != null && !config.getContentKey().equals(Number160.ZERO)) {
            logger.warn("Warning, setting a content key in add() does not have any effect");
        }
        if (!config.isSignMessage()) {
            for (Data data : dataCollection) {
                if (!data.isProtectedEntry()) continue;
                config.setSignMessage(true);
                break;
            }
        }
        FutureDHT futureDHT = this.getDHT().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.scheduleAdd(locationKey, dataCollection, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleAdd(final Number160 locationKey, Collection<Data> dataCollection, final ConfigurationStore config, final FutureDHT futureDHT) {
        final HashSet<Number480> keys = new HashSet<Number480>();
        for (Data data : dataCollection) {
            Number160 contentKey = data.getHash();
            data.setDataPublicKey(this.keyPair.getPublic());
            Number480 key = new Number480(locationKey, config.getDomain(), contentKey);
            this.getPeerBean().getStorage().put(key, data, this.keyPair.getPublic(), config.isStoreIfAbsent(), config.isProtectDomain());
            keys.add(key);
        }
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Map<Number160, Data> dataMap2 = Peer.this.getPeerBean().getStorage().get(keys, Peer.this.keyPair.getPublic());
                FutureDHT futureDHT2 = Peer.this.getDHT().add(locationKey, config.getDomain(), dataMap2.values(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.getFutureCreate());
                futureDHT.created(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT getAll(Number160 locationKey) {
        return this.get(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, null, config);
    }

    public FutureDHT get(Number160 locationKey) {
        return this.get(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.get(locationKey, keyCollection, config);
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDHT().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage());
        return futureDHT;
    }

    public FutureDHT removeAll(Number160 locationKey) {
        return this.remove(locationKey, null, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config) {
        return this.remove(locationKey, null, config);
    }

    public FutureDHT remove(Number160 locationKey) {
        return this.remove(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.remove(locationKey, keyCollection, config);
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config) {
        if (keyCollection != null) {
            for (Number160 contentKey : keyCollection) {
                this.getPeerBean().getStorage().remove(new Number480(locationKey, config.getDomain(), contentKey), this.keyPair.getPublic());
            }
        } else {
            this.getPeerBean().getStorage().remove(new Number320(locationKey, config.getDomain()), this.keyPair.getPublic());
        }
        FutureDHT futureDHT = this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.getFutureCreate());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleRemove(locationKey, keyCollection, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleRemove(final Number160 locationKey, final Set<Number160> keyCollection, final ConfigurationRemove config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureDHT futureDHT2 = Peer.this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.getFutureCreate());
                futureDHT.created(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, buffer, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, true, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureDHT;
    }

    public FutureDHT send(Number160 locationKey, Object object) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, object, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        byte[] me = Utils.encodeJavaObject(object);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])me);
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            futureDHT.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleSend(final Number160 locationKey, final ChannelBuffer buffer, final ConfigurationDirect config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureDHT futureDHT2 = Peer.this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish());
                futureDHT.created(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config) {
        return this.getTracker().getFromTracker(locationKey, config.getDomain(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isExpectAttachement(), config.getEvaluationScheme(), config.isSignMessage());
    }

    public FutureTracker addToTracker(Number160 locationKey, ConfigurationTrackerStore config) {
        if (!config.isSignMessage()) {
            config.setSignMessage(config.getAttachement() != null && config.getAttachement().isProtectedEntry());
        }
        FutureTracker futureTracker = this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate());
        if (this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() > 0) {
            ScheduledFuture<?> tmp = this.scheduleAddTracker(locationKey, config, futureTracker);
            futureTracker.setScheduledFuture(tmp, this.scheduledFutures);
        }
        return futureTracker;
    }

    private ScheduledFuture<?> scheduleAddTracker(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureTracker futureTracker2 = Peer.this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate());
                futureTracker.repeated(futureTracker2);
            }
        };
        int refresh = this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() * 3 / 4;
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public P2PConfiguration getP2PConfiguration() {
        return this.peerConfiguration;
    }

    private class Maintenance
    implements Runnable {
        final int max;
        final Map<PeerAddress, FutureResponse> result = new HashMap<PeerAddress, FutureResponse>();
        private final PeerMap peerMap;
        private final HandshakeRPC handshakeRPC;

        public Maintenance(PeerMap peerMap, HandshakeRPC handshakeRPC, P2PConfiguration config) {
            this.peerMap = peerMap;
            this.handshakeRPC = handshakeRPC;
            this.max = config.getMaintenanceThreads();
        }

        @Override
        public void run() {
            Collection<PeerAddress> nas = this.peerMap.peersForMaintenance();
            if (logger.isDebugEnabled()) {
                logger.debug("numbe of peers for maintenance: " + nas.size());
            }
            for (PeerAddress na : nas) {
                this.result.put(na, this.handshakeRPC.pingUDP(na));
                if (this.result.size() >= this.max && !this.waitFor()) {
                    this.cleanUp();
                    return;
                }
                if (!Thread.interrupted()) continue;
                this.cleanUp();
                return;
            }
            if (!this.waitFor()) {
                this.cleanUp();
                return;
            }
        }

        private void cleanUp() {
            for (FutureResponse futureResponse : this.result.values()) {
                futureResponse.cancel();
            }
        }

        private boolean waitFor() {
            try {
                for (Map.Entry<PeerAddress, FutureResponse> entry : this.result.entrySet()) {
                    entry.getValue().await();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Maintenance: peer " + entry.getKey() + " online=" + entry.getValue());
                }
                this.result.clear();
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

