/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.BaseFutureImpl;
import net.tomp2p.peers.PeerAddress;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timeout;
import org.jboss.netty.util.Timer;
import org.jboss.netty.util.TimerTask;

public class FutureDiscover
extends BaseFutureImpl {
    private final Timer timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS, 10);
    private final Timeout timeout;
    private boolean onGoingUDP;
    private boolean onGoingTCP;
    private boolean privateUDP;
    private boolean privateTCP;
    private PeerAddress peerAddress;

    public FutureDiscover(int delaySec) {
        this.timeout = this.timer.newTimeout((TimerTask)new DiscoverTimeoutTask(), (long)delaySec, TimeUnit.SECONDS);
    }

    @Override
    public void cancel() {
        this.timeout.cancel();
        this.timer.stop();
        super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrivateUPD(boolean privateUDP) {
        Object object = this.lock;
        synchronized (object) {
            this.privateUDP = privateUDP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPrivateUPD() {
        Object object = this.lock;
        synchronized (object) {
            return this.privateUDP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPrivateTCP() {
        Object object = this.lock;
        synchronized (object) {
            return this.privateTCP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onGoing(boolean onGoingUDP, boolean onGoingTCP) {
        Object object = this.lock;
        synchronized (object) {
            this.onGoingUDP = onGoingUDP;
            this.onGoingTCP = onGoingTCP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(PeerAddress peerAddress) {
        this.timer.stop();
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.peerAddress = peerAddress;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUDPOngoing() {
        Object object = this.lock;
        synchronized (object) {
            return this.onGoingUDP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTCPOngoing() {
        Object object = this.lock;
        synchronized (object) {
            return this.onGoingTCP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerAddress getPeerAddress() {
        Object object = this.lock;
        synchronized (object) {
            return this.peerAddress;
        }
    }

    private final class DiscoverTimeoutTask
    implements TimerTask {
        private DiscoverTimeoutTask() {
        }

        public void run(Timeout timeout) throws Exception {
            FutureDiscover.this.timer.stop();
            FutureDiscover.this.setFailed("Timeout");
        }
    }
}

