/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import net.tomp2p.storage.StorageRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMemory
extends Storage {
    private static final Logger logger = LoggerFactory.getLogger(StorageMemory.class);
    private final Object lock = new Object();
    protected final SortedMap<Number480, Data> dataMap = new TreeMap<Number480, Data>();
    protected final Set<Number480> dataDirectReplication = new HashSet<Number480>();
    private final Map<Number320, PublicKey> protectedMap = new HashMap<Number320, PublicKey>();
    protected final Map<Number160, Number160> responsibilityMap = new HashMap<Number160, Number160>();
    protected final Map<Number160, Set<Number160>> responsibilityMapRev = new HashMap<Number160, Set<Number160>>();
    private final Map<Number480, Long> timeoutMap = new HashMap<Number480, Long>();
    private final SortedMap<Long, Set<Number480>> timeoutMapRev = new TreeMap<Long, Set<Number480>>();

    @Override
    public void close() {
        this.dataMap.clear();
        this.dataDirectReplication.clear();
        this.protectedMap.clear();
        this.responsibilityMap.clear();
        this.responsibilityMapRev.clear();
        this.timeoutMap.clear();
        this.timeoutMapRev.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(Number480 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        Object object = this.lock;
        synchronized (object) {
            boolean protectEntry;
            Data oldData;
            this.checkTimeout();
            if (!this.securityDomainCheck(key, publicKey, domainProtection)) {
                return false;
            }
            boolean contains = this.dataMap.containsKey(key);
            if (putIfAbsent && contains) {
                return false;
            }
            if (contains && !this.canUpdateEntry(key, oldData = (Data)this.dataMap.get(key), newData, protectEntry = newData.isProtectedEntry())) {
                return false;
            }
            this.dataMap.put(key, newData);
            long exp = newData.getExpirationMillis();
            this.addTimeout(key, exp);
        }
        return true;
    }

    private void addTimeout(Number480 key, long exp) {
        HashSet<Number480> tmp;
        Long old = this.timeoutMap.put(key, exp);
        if (old != null && (tmp = (HashSet<Number480>)this.timeoutMapRev.get(old)) != null) {
            tmp.remove(key);
            if (tmp.isEmpty()) {
                this.responsibilityMapRev.remove(old);
            }
        }
        if ((tmp = (Set)this.timeoutMapRev.get(exp)) == null) {
            tmp = new HashSet<Number480>();
            this.timeoutMapRev.put(exp, tmp);
        }
        tmp.add(key);
    }

    private void removeTimeout(Number480 key) {
        Set tmp2;
        Long tmp = this.timeoutMap.remove(key);
        if (tmp != null && (tmp2 = (Set)this.timeoutMapRev.get(tmp)) != null) {
            tmp2.remove(key);
            if (tmp2.isEmpty()) {
                this.timeoutMapRev.remove(tmp);
            }
        }
    }

    private boolean securityDomainCheck(Number480 key, PublicKey publicKey, boolean domainProtection) {
        Number320 partKey = new Number320(key.getLocationKey(), key.getDomainKey());
        boolean domainProtectedByOthers = this.isDomainProtectedByOthers(partKey, publicKey);
        if (!domainProtection && !domainProtectedByOthers) {
            return true;
        }
        if (domainProtection && (!domainProtectedByOthers || this.getProtectionDomainMode() == Storage.ProtectionMode.MASTER_PUBLIC_KEY && this.foreceOverrideDomain(key.getDomainKey(), publicKey)) && this.canProtectDomain(partKey, publicKey)) {
            return this.protectDomain(partKey, publicKey);
        }
        return false;
    }

    private boolean isDomainProtectedByOthers(Number320 partKey, PublicKey publicKey) {
        PublicKey other = this.protectedMap.get(partKey);
        if (other == null) {
            return false;
        }
        return !publicKey.equals(other);
    }

    private boolean protectDomain(Number320 partKey, PublicKey publicKey) {
        if (this.getProtectionEntryInDomain() == Storage.ProtectionEntryInDomain.ENTRY_REMOVE_IF_DOMAIN_CLAIMED) {
            this.remove(partKey.min(), partKey.max(), publicKey);
        }
        this.protectedMap.put(partKey, publicKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data get(Number480 key) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            return (Data)this.dataMap.get(key);
        }
    }

    public List<Number480> getKeys(Number320 key) {
        return this.getKeys(key.min(), key.max());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Number480> getKeys(Number480 fromKey, Number480 toKey) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            if (fromKey == null && toKey == null) {
                return null;
            }
            if (toKey == null) {
                return new ArrayList<Number480>(this.dataMap.tailMap(fromKey).keySet());
            }
            if (fromKey == null) {
                return new ArrayList<Number480>(this.dataMap.headMap(toKey).keySet());
            }
            return new ArrayList<Number480>(this.dataMap.subMap(fromKey, toKey).keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<Number480, Data> get(Number480 fromKey, Number480 toKey) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            if (fromKey == null && toKey == null) {
                return null;
            }
            if (toKey == null) {
                return new TreeMap<Number480, Data>(this.dataMap.tailMap(fromKey));
            }
            if (fromKey == null) {
                return new TreeMap<Number480, Data>(this.dataMap.headMap(toKey));
            }
            return new TreeMap<Number480, Data>(this.dataMap.subMap(fromKey, toKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Data remove(Number480 key, PublicKey publicKey) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            return this.remove(key, publicKey, false);
        }
    }

    private Data remove(Number480 key, PublicKey publicKey, boolean force) {
        if (!force && this.isDomainProtectedByOthers(new Number320(key.getLocationKey(), key.getDomainKey()), publicKey)) {
            return null;
        }
        Data data = (Data)this.dataMap.get(key);
        if (data != null && (force || data.getDataPublicKey() == null || data.getDataPublicKey().equals(publicKey))) {
            this.removeTimeout(key);
            this.removeResponsibility(key.getLocationKey());
            return (Data)this.dataMap.remove(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedMap<Number480, Data> remove(Number480 fromKey, Number480 toKey, PublicKey publicKey) {
        Object object = this.lock;
        synchronized (object) {
            boolean cont;
            this.checkTimeout();
            if (!fromKey.getLocationKey().equals(toKey.getLocationKey()) || !fromKey.getDomainKey().equals(toKey.getDomainKey())) {
                return null;
            }
            boolean domainProtectedByOthers = this.isDomainProtectedByOthers(new Number320(fromKey.getLocationKey(), fromKey.getDomainKey()), publicKey);
            boolean bl = cont = !domainProtectedByOthers || this.getProtectionDomainMode() == Storage.ProtectionMode.MASTER_PUBLIC_KEY && this.foreceOverrideDomain(fromKey.getDomainKey(), publicKey);
            if (!cont) {
                return null;
            }
            if (fromKey == null && toKey == null) {
                return null;
            }
            SortedMap<Number480, Data> tmp = toKey == null ? this.dataMap.tailMap(fromKey) : (fromKey == null ? this.dataMap.headMap(toKey) : this.dataMap.subMap(fromKey, toKey));
            ArrayList<Number480> keys = new ArrayList<Number480>(tmp.keySet());
            TreeMap<Number480, Data> result = new TreeMap<Number480, Data>();
            for (Number480 key : keys) {
                Data data = (Data)this.dataMap.get(key);
                if (data.getDataPublicKey() != null && !data.getDataPublicKey().equals(publicKey)) continue;
                this.removeTimeout(key);
                this.removeResponsibility(key.getLocationKey());
                result.put(key, (Data)this.dataMap.remove(key));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Number480 key) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            return this.dataMap.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Number480 fromKey, Number480 toKey) {
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            SortedMap<Number480, Data> tmp = this.get(fromKey, toKey);
            Number160 hash = Number160.ZERO;
            for (Number480 key : tmp.keySet()) {
                hash = hash.xor(key.getContentKey());
            }
            return new DigestInfo(hash, tmp.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Collection<Number480> keys) {
        Number160 hash = Number160.ZERO;
        int size = 0;
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            for (Number480 key : keys) {
                if (!this.dataMap.containsKey(key)) continue;
                hash = hash.xor(key.getContentKey());
                ++size;
            }
        }
        return new DigestInfo(hash, size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateAndRun(Number160 locationKey, StorageRunner runner) {
        Number480 min = new Number480(locationKey, Number160.ZERO, Number160.ZERO);
        Number480 max = new Number480(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
        Object object = this.lock;
        synchronized (object) {
            this.checkTimeout();
            for (Map.Entry<Number480, Data> entry : this.dataMap.subMap(min, max).entrySet()) {
                runner.call(entry.getKey().getLocationKey(), entry.getKey().getDomainKey(), entry.getKey().getContentKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number160> findResponsibleData(Number160 peerID) {
        Object object = this.lock;
        synchronized (object) {
            Collection result = this.responsibilityMapRev.get(peerID);
            if (result == null) {
                return Collections.emptyList();
            }
            return new ArrayList<Number160>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number160 findResponsiblePeerID(Number160 key) {
        Object object = this.lock;
        synchronized (object) {
            return this.responsibilityMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateResponsibilities(Number160 key, Number160 closest) {
        Object object = this.lock;
        synchronized (object) {
            Set<Number160> tmp;
            boolean isNew = false;
            Number160 old = this.responsibilityMap.put(key, closest);
            if (old != null) {
                isNew = !old.equals(closest);
                tmp = this.responsibilityMapRev.get(old);
                if (tmp != null) {
                    tmp.remove(key);
                    if (tmp.isEmpty()) {
                        this.responsibilityMapRev.remove(old);
                    }
                }
            } else {
                isNew = true;
            }
            tmp = this.responsibilityMapRev.get(closest);
            if (tmp == null) {
                tmp = new HashSet<Number160>();
                this.responsibilityMapRev.put(closest, tmp);
            }
            tmp.add(key);
            return isNew;
        }
    }

    @Override
    public Collection<Number480> storedDirectReplication() {
        return new ArrayList<Number480>(0);
    }

    private void removeResponsibility(Number160 key) {
        Set<Number160> tmp2;
        Number160 tmp = this.responsibilityMap.remove(key);
        if (tmp != null && (tmp2 = this.responsibilityMapRev.get(tmp)) != null) {
            tmp2.remove(key);
            if (tmp2.isEmpty()) {
                this.responsibilityMapRev.remove(tmp);
            }
        }
    }

    private Collection<Number480> checkTimeout() {
        long time = System.currentTimeMillis();
        ArrayList<Number480> toRemove = new ArrayList<Number480>();
        for (Map.Entry<Long, Set<Number480>> entry : this.timeoutMapRev.subMap(0L, time).entrySet()) {
            toRemove.addAll((Collection<Number480>)entry.getValue());
        }
        if (toRemove.size() > 0) {
            for (Number480 key : toRemove) {
                logger.debug("Remove key " + key + " due to expiration");
                this.remove(key, null, true);
            }
        }
        return toRemove;
    }
}

