/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.bind.tuple.TupleTupleKeyCreator;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.tomp2p.message.DataInput;
import net.tomp2p.message.DataOutput;
import net.tomp2p.message.DataOutputFactory;
import net.tomp2p.message.MessageCodec;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Storage;
import net.tomp2p.storage.StorageRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageDisk
extends Storage {
    private static final Logger logger = LoggerFactory.getLogger(StorageDisk.class);
    private final Environment env;
    private final StoredClassCatalog javaCatalog;
    private final Database dataDb;
    private final Database protectionDb;
    private final Database timeoutDb;
    private final Database responsibilityDb;
    private final SecondaryDatabase timeoutByLong;
    private final SecondaryDatabase responsibilityByNumber160;
    private final SecondaryDatabase dataByReplication;
    private final StoredSortedMap<Number480, Data> dataMap;
    private final StoredMap<Number480, Data> dataMapReplication;
    private final StoredMap<Number320, PublicKey> protectedMap;
    private final StoredMap<Number480, Number480Long> timeoutMap;
    private final StoredSortedMap<Long, Number480Long> timeoutMapRev;
    private final StoredMap<Number160, Number160Number160> responsibilityMap;
    private final StoredMap<Number160, Number160Number160> responsibilityMapRev;

    public StorageDisk(String homeDirectory) throws Exception {
        new File(homeDirectory).mkdirs();
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        this.env = new Environment(new File(homeDirectory), envConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        Database catalogDb = this.env.openDatabase(null, "java_class_catalog", dbConfig);
        this.javaCatalog = new StoredClassCatalog(catalogDb);
        this.dataDb = this.env.openDatabase(null, "data_store", dbConfig);
        this.protectionDb = this.env.openDatabase(null, "protection_store", dbConfig);
        this.timeoutDb = this.env.openDatabase(null, "timeout_store", dbConfig);
        this.responsibilityDb = this.env.openDatabase(null, "responsibilyt_store", dbConfig);
        Number480Binding number480Binding = new Number480Binding();
        Number320Binding number320Binding = new Number320Binding();
        PublicKeyValueBinding publicKeyValueBinding = new PublicKeyValueBinding();
        Number480LongBinding number480longBinding = new Number480LongBinding(number480Binding);
        LongBinding longBinding = new LongBinding();
        Number160Binding number160Binding = new Number160Binding();
        DataBinding dataValueBinding = new DataBinding();
        Number160Number160Binding number160number160Binding = new Number160Number160Binding(number160Binding);
        SecondaryConfig secConfig1 = new SecondaryConfig();
        secConfig1.setTransactional(true);
        secConfig1.setAllowCreate(true);
        secConfig1.setSortedDuplicates(true);
        secConfig1.setKeyCreator((SecondaryKeyCreator)new TimeoutByLongKeyCreator(number480longBinding));
        this.timeoutByLong = this.env.openSecondaryDatabase(null, "timeout_store_long", this.timeoutDb, secConfig1);
        SecondaryConfig secConfig2 = new SecondaryConfig();
        secConfig2.setTransactional(true);
        secConfig2.setAllowCreate(true);
        secConfig2.setSortedDuplicates(true);
        secConfig2.setKeyCreator((SecondaryKeyCreator)new ResponsibilityByNumber160KeyCreator(number160number160Binding, number160Binding));
        this.responsibilityByNumber160 = this.env.openSecondaryDatabase(null, "responsibilyt_store_number160", this.responsibilityDb, secConfig2);
        SecondaryConfig secConfig3 = new SecondaryConfig();
        secConfig3.setTransactional(true);
        secConfig3.setAllowCreate(true);
        secConfig3.setSortedDuplicates(true);
        secConfig3.setKeyCreator((SecondaryKeyCreator)new DataByNumber480KeyCreator(dataValueBinding, number480Binding));
        this.dataByReplication = this.env.openSecondaryDatabase(null, "data_store_boolean", this.dataDb, secConfig3);
        this.dataMap = new StoredSortedMap(this.dataDb, (EntryBinding)number480Binding, (EntryBinding)dataValueBinding, true);
        this.dataMapReplication = new StoredMap((Database)this.dataByReplication, (EntryBinding)number480Binding, (EntryBinding)dataValueBinding, true);
        this.protectedMap = new StoredMap(this.protectionDb, (EntryBinding)number320Binding, (EntryBinding)publicKeyValueBinding, true);
        this.timeoutMap = new StoredMap(this.timeoutDb, (EntryBinding)number480Binding, (EntryBinding)number480longBinding, true);
        this.timeoutMapRev = new StoredSortedMap((Database)this.timeoutByLong, (EntryBinding)longBinding, (EntryBinding)number480longBinding, true);
        this.responsibilityMap = new StoredMap(this.responsibilityDb, (EntryBinding)number160Binding, (EntryBinding)number160number160Binding, true);
        this.responsibilityMapRev = new StoredSortedMap((Database)this.responsibilityByNumber160, (EntryBinding)number160Binding, (EntryBinding)number160number160Binding, true);
    }

    @Override
    public void close() {
        this.dataByReplication.close();
        this.dataDb.close();
        this.protectionDb.close();
        this.timeoutByLong.close();
        this.timeoutDb.close();
        this.responsibilityByNumber160.close();
        this.responsibilityDb.close();
        this.javaCatalog.close();
        this.env.close();
    }

    @Override
    public boolean put(Number480 key, Data newData, PublicKey publicKey, boolean putIfAbsent, boolean domainProtection) {
        this.checkTimeout();
        Transaction txn = this.env.beginTransaction(null, null);
        try {
            boolean protectEntry;
            Data oldData;
            if (!this.securityDomainCheck(key, publicKey, domainProtection)) {
                txn.abort();
                return false;
            }
            boolean contains = this.dataMap.containsKey((Object)key);
            if (putIfAbsent && contains) {
                txn.abort();
                return false;
            }
            if (contains && !this.canUpdateEntry(key, oldData = (Data)this.dataMap.get((Object)key), newData, protectEntry = newData.isProtectedEntry())) {
                txn.abort();
                return false;
            }
            this.dataMap.put((Object)key, (Object)newData);
            this.timeoutMap.put((Object)key, (Object)new Number480Long(key, newData.getExpirationMillis()));
            txn.commit();
            return true;
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            if (txn != null) {
                txn.abort();
            }
            return false;
        }
    }

    private boolean securityDomainCheck(Number480 key, PublicKey publicKey, boolean domainProtection) {
        if (domainProtection) {
            Number320 partKey = new Number320(key.getLocationKey(), key.getDomainKey());
            if (this.canProtectDomain(partKey, publicKey) && !this.isDomainProtectedByOthers(partKey, publicKey)) {
                return this.protectDomain(partKey, publicKey);
            }
            return false;
        }
        return true;
    }

    private boolean isDomainProtectedByOthers(Number320 partKey, PublicKey publicKey) {
        PublicKey other = (PublicKey)this.protectedMap.get((Object)partKey);
        if (other == null) {
            return false;
        }
        return !publicKey.equals(other);
    }

    private boolean protectDomain(Number320 partKey, PublicKey publicKey) {
        if (!this.protectedMap.containsKey((Object)partKey)) {
            if (this.getProtectionEntryInDomain() == Storage.ProtectionEntryInDomain.ENTRY_REMOVE_IF_DOMAIN_CLAIMED) {
                this.remove(partKey.min(), partKey.max(), publicKey);
            }
            this.protectedMap.put((Object)partKey, (Object)publicKey);
            return true;
        }
        return ((PublicKey)this.protectedMap.get((Object)partKey)).equals(publicKey);
    }

    @Override
    public Data get(Number480 key) {
        this.checkTimeout();
        return (Data)this.dataMap.get((Object)key);
    }

    @Override
    public SortedMap<Number480, Data> get(Number480 fromKey, Number480 toKey) {
        this.checkTimeout();
        if (fromKey == null && toKey == null) {
            return null;
        }
        if (toKey == null) {
            return this.dataMap.tailMap((Object)fromKey);
        }
        if (fromKey == null) {
            return this.dataMap.headMap((Object)toKey);
        }
        return this.dataMap.subMap((Object)fromKey, (Object)toKey);
    }

    @Override
    public Data remove(Number480 key, PublicKey publicKey) {
        this.checkTimeout();
        return this.remove(key, publicKey, false);
    }

    private Data remove(Number480 key, PublicKey publicKey, boolean force) {
        Transaction txn = this.env.beginTransaction(null, null);
        try {
            if (!force && this.isDomainProtectedByOthers(new Number320(key.getLocationKey(), key.getDomainKey()), publicKey)) {
                txn.abort();
                return null;
            }
            Data data = (Data)this.dataMap.get((Object)key);
            if (force || data.getDataPublicKey() == null || data.getDataPublicKey().equals(publicKey)) {
                this.timeoutMap.remove((Object)key);
                this.responsibilityMap.remove((Object)key.getLocationKey());
                Data removedData = (Data)this.dataMap.remove((Object)key);
                txn.commit();
                return removedData;
            }
            txn.abort();
            return null;
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            if (txn != null) {
                txn.abort();
            }
            return null;
        }
    }

    @Override
    public SortedMap<Number480, Data> remove(Number480 fromKey, Number480 toKey, PublicKey publicKey) {
        this.checkTimeout();
        Transaction txn = this.env.beginTransaction(null, null);
        try {
            if (!fromKey.getLocationKey().equals(toKey.getLocationKey()) || !fromKey.getDomainKey().equals(toKey.getDomainKey())) {
                txn.abort();
                return null;
            }
            if (this.isDomainProtectedByOthers(new Number320(fromKey.getLocationKey(), fromKey.getDomainKey()), publicKey)) {
                txn.abort();
                return null;
            }
            if (fromKey == null && toKey == null) {
                txn.abort();
                return null;
            }
            SortedMap tmp = toKey == null ? this.dataMap.tailMap((Object)fromKey) : (fromKey == null ? this.dataMap.headMap((Object)toKey) : this.dataMap.subMap((Object)fromKey, (Object)toKey));
            ArrayList keys = new ArrayList(tmp.keySet());
            TreeMap<Number480, Data> result = new TreeMap<Number480, Data>();
            for (Number480 key : keys) {
                Data data = (Data)this.dataMap.get((Object)key);
                if (data.getDataPublicKey() != null && !data.getDataPublicKey().equals(publicKey)) continue;
                this.timeoutMap.remove((Object)key);
                this.responsibilityMap.remove((Object)key.getLocationKey());
                result.put(key, (Data)this.dataMap.remove((Object)key));
            }
            txn.commit();
            return result;
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            if (txn != null) {
                txn.abort();
            }
            return null;
        }
    }

    @Override
    public boolean contains(Number480 key) {
        this.checkTimeout();
        return this.dataMap.containsKey((Object)key);
    }

    @Override
    public DigestInfo digest(Number480 fromKey, Number480 toKey) {
        this.checkTimeout();
        SortedMap<Number480, Data> tmp = this.get(fromKey, toKey);
        Number160 hash = Number160.ZERO;
        for (Number480 key : tmp.keySet()) {
            hash = hash.xor(key.getContentKey());
        }
        return new DigestInfo(hash, tmp.size());
    }

    @Override
    public DigestInfo digest(Collection<Number480> keys) {
        this.checkTimeout();
        Number160 hash = Number160.ZERO;
        int size = 0;
        for (Number480 key : keys) {
            if (!this.contains(key)) continue;
            hash = hash.xor(key.getContentKey());
            ++size;
        }
        return new DigestInfo(hash, size);
    }

    @Override
    public void iterateAndRun(Number160 locationKey, StorageRunner runner) {
        Number480 min = new Number480(locationKey, Number160.ZERO, Number160.ZERO);
        Number480 max = new Number480(locationKey, Number160.MAX_VALUE, Number160.MAX_VALUE);
        this.checkTimeout();
        for (Map.Entry entry : this.dataMap.subMap((Object)min, (Object)max).entrySet()) {
            runner.call(((Number480)entry.getKey()).getLocationKey(), ((Number480)entry.getKey()).getDomainKey(), ((Number480)entry.getKey()).getContentKey(), (Data)entry.getValue());
        }
    }

    @Override
    public Collection<Number160> findResponsibleData(Number160 peerID) {
        ArrayList<Number160> result = new ArrayList<Number160>();
        for (Number160Number160 tmp : this.responsibilityMapRev.duplicates((Object)peerID)) {
            result.add(tmp.getNumberKey());
        }
        return result;
    }

    @Override
    public Number160 findResponsiblePeerID(Number160 locationKey) {
        Number160Number160 tmp = (Number160Number160)this.responsibilityMap.get((Object)locationKey);
        if (tmp == null) {
            return null;
        }
        return tmp.getNumberPeerID();
    }

    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerID) {
        Number160Number160 old = (Number160Number160)this.responsibilityMap.put((Object)locationKey, (Object)new Number160Number160(locationKey, peerID));
        if (old == null) {
            return true;
        }
        return !old.numberPeerID.equals(peerID);
    }

    @Override
    public Collection<Number480> storedDirectReplication() {
        return this.dataMapReplication.keySet();
    }

    private Collection<Number480> checkTimeout() {
        Transaction txn = this.env.beginTransaction(null, null);
        try {
            ArrayList<Number480> toRemove = new ArrayList<Number480>();
            for (Map.Entry entry : this.timeoutMapRev.subMap((Object)0L, (Object)System.currentTimeMillis()).entrySet()) {
                toRemove.add(((Number480Long)entry.getValue()).getNumber480());
            }
            if (toRemove.size() > 0) {
                for (Number480 key : toRemove) {
                    logger.debug("Remove key " + key + " due to expiration");
                    this.remove(key, null, true);
                }
            }
            txn.commit();
            return toRemove;
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            if (txn != null) {
                txn.abort();
            }
            return null;
        }
    }

    private static class TupleDecoder
    implements DataInput {
        private final TupleInput input;

        private TupleDecoder(TupleInput input) {
            this.input = input;
        }

        @Override
        public byte[] array() {
            return this.input.getBufferBytes();
        }

        @Override
        public int arrayOffset() {
            return this.input.getBufferOffset();
        }

        @Override
        public void readBytes(byte[] buf) {
            this.input.read(buf);
        }

        @Override
        public int readInt() {
            return this.input.readInt();
        }

        @Override
        public int readUnsignedByte() {
            return this.input.readUnsignedByte() & 0xFF;
        }

        @Override
        public int getUnsignedByte() {
            return this.input.getBufferBytes()[this.input.getBufferOffset() & 0xFF];
        }

        @Override
        public int readUnsignedShort() {
            return this.input.readUnsignedShort() & 0xFFFF;
        }

        @Override
        public int readerIndex() {
            return 0;
        }

        @Override
        public void skipBytes(int size) {
            this.input.skipFast(size);
        }
    }

    private static class TupleEncoder
    implements DataOutput {
        private final TupleOutput output;

        private TupleEncoder(TupleOutput output) {
            this.output = output;
        }

        public void writeBytes(byte[] data) {
            this.output.write(data);
        }

        public void writeBytes(byte[] data, int offset, int length) {
            this.output.write(data, offset, length);
        }

        @Override
        public void writeByte(int intVal) {
            this.output.writeUnsignedByte(intVal);
        }

        @Override
        public void writeInt(int intVal) {
            this.output.writeInt(intVal);
        }

        @Override
        public void writeShort(int intVal) {
            this.output.writeUnsignedShort(intVal);
        }
    }

    private static class TupleFactory
    implements DataOutputFactory {
        private final TupleEncoder encoder;

        private TupleFactory(TupleOutput output) {
            this.encoder = new TupleEncoder(output);
        }

        @Override
        public DataOutput create(int count) {
            return this.encoder;
        }

        @Override
        public DataOutput create(byte[] data, int offset, int length) {
            this.encoder.writeBytes(data, offset, length);
            return this.encoder;
        }

        @Override
        public DataOutput create(byte[] data) {
            this.encoder.writeBytes(data);
            return this.encoder;
        }
    }

    private static class Number160Number160 {
        private final Number160 numberKey;
        private final Number160 numberPeerID;

        private Number160Number160(Number160 numberKey, Number160 numberPeerID) {
            this.numberKey = numberKey;
            this.numberPeerID = numberPeerID;
        }

        public Number160 getNumberKey() {
            return this.numberKey;
        }

        public Number160 getNumberPeerID() {
            return this.numberPeerID;
        }
    }

    private static class Number480Long {
        private final Number480 number480;
        private final Long longValue;

        private Number480Long(Number480 number480, Long longValue) {
            this.number480 = number480;
            this.longValue = longValue;
        }

        public Number480 getNumber480() {
            return this.number480;
        }

        public Long getLongValue() {
            return this.longValue;
        }
    }

    private static class ResponsibilityByNumber160KeyCreator
    extends TupleTupleKeyCreator<Number160> {
        private final TupleBinding<Number160Number160> bindingInput;
        private final TupleBinding<Number160> bindingOutput;

        public ResponsibilityByNumber160KeyCreator(TupleBinding<Number160Number160> bindingInput, TupleBinding<Number160> bindingOutput) {
            this.bindingInput = bindingInput;
            this.bindingOutput = bindingOutput;
        }

        public boolean createSecondaryKey(TupleInput primaryKeyInput, TupleInput dataInput, TupleOutput indexKeyOutput) {
            Number160Number160 data = (Number160Number160)this.bindingInput.entryToObject(dataInput);
            this.bindingOutput.objectToEntry((Object)data.getNumberPeerID(), indexKeyOutput);
            return true;
        }
    }

    private static class TimeoutByLongKeyCreator
    extends TupleTupleKeyCreator<Long> {
        private final TupleBinding<Number480Long> binding;

        public TimeoutByLongKeyCreator(TupleBinding<Number480Long> binding) {
            this.binding = binding;
        }

        public boolean createSecondaryKey(TupleInput primaryKeyInput, TupleInput dataInput, TupleOutput indexKeyOutput) {
            Number480Long data = (Number480Long)this.binding.entryToObject(dataInput);
            indexKeyOutput.writeLong(data.getLongValue().longValue());
            return true;
        }
    }

    private static class DataByNumber480KeyCreator
    extends TupleTupleKeyCreator<Number480> {
        private final TupleBinding<Data> bindingData;
        private final TupleBinding<Number480> bindingNumber480;

        public DataByNumber480KeyCreator(TupleBinding<Data> bindingData, TupleBinding<Number480> bindingNumber480) {
            this.bindingData = bindingData;
            this.bindingNumber480 = bindingNumber480;
        }

        public boolean createSecondaryKey(TupleInput primaryKeyInput, TupleInput dataInput, TupleOutput indexKeyOutput) {
            Data data = (Data)this.bindingData.entryToObject(dataInput);
            Number480 key = (Number480)this.bindingNumber480.entryToObject(primaryKeyInput);
            if (data.isDirectReplication()) {
                this.bindingNumber480.objectToEntry((Object)key, indexKeyOutput);
                return true;
            }
            return false;
        }
    }

    private static class PublicKeyValueBinding
    extends TupleBinding<PublicKey> {
        private PublicKeyValueBinding() {
        }

        public PublicKey entryToObject(TupleInput input) {
            int len = input.readShort() & 0xFFFF;
            byte[] data = new byte[len];
            input.read(data);
            try {
                return MessageCodec.decodePublicKey(new TupleDecoder(input), data);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void objectToEntry(PublicKey object, TupleOutput output) {
            byte[] enc = object.getEncoded();
            output.writeShort(enc.length);
            output.write(enc);
        }
    }

    private static class DataBinding
    extends TupleBinding<Data> {
        private DataBinding() {
        }

        public Data entryToObject(TupleInput input) {
            try {
                Data data = MessageCodec.decodeData(new TupleDecoder(input), null);
                byte flag = input.readByte();
                boolean isDirectReplication = (flag & 1) > 0;
                data.setDirectReplication(isDirectReplication);
                return data;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void objectToEntry(Data object, TupleOutput output) {
            TupleFactory factory = new TupleFactory(output);
            MessageCodec.encodeData(new ArrayList<DataOutput>(), factory, null, object);
            int flag = 0;
            if (object.isDirectReplication()) {
                flag |= 1;
            }
            output.writeByte(flag);
        }
    }

    private static class LongBinding
    extends TupleBinding<Long> {
        private LongBinding() {
        }

        public Long entryToObject(TupleInput input) {
            return input.readLong();
        }

        public void objectToEntry(Long object, TupleOutput output) {
            output.writeLong(object.longValue());
        }
    }

    private static class Number320Binding
    extends TupleBinding<Number320> {
        private Number320Binding() {
        }

        public Number320 entryToObject(TupleInput input) {
            byte[] first = new byte[20];
            byte[] second = new byte[20];
            byte[] third = new byte[20];
            input.read(first);
            input.read(second);
            input.read(third);
            return new Number320(new Number160(first), new Number160(second));
        }

        public void objectToEntry(Number320 object, TupleOutput output) {
            output.write(object.getLocationKey().toByteArray());
            output.write(object.getDomainKey().toByteArray());
        }
    }

    private static class Number160Binding
    extends TupleBinding<Number160> {
        private Number160Binding() {
        }

        public Number160 entryToObject(TupleInput input) {
            byte[] first = new byte[20];
            input.read(first);
            return new Number160(first);
        }

        public void objectToEntry(Number160 object, TupleOutput output) {
            output.write(object.toByteArray());
        }
    }

    private static class Number480Binding
    extends TupleBinding<Number480> {
        private Number480Binding() {
        }

        public Number480 entryToObject(TupleInput input) {
            byte[] first = new byte[20];
            byte[] second = new byte[20];
            byte[] third = new byte[20];
            input.read(first);
            input.read(second);
            input.read(third);
            return new Number480(new Number160(first), new Number160(second), new Number160(third));
        }

        public void objectToEntry(Number480 object, TupleOutput output) {
            output.write(object.getLocationKey().toByteArray());
            output.write(object.getDomainKey().toByteArray());
            output.write(object.getContentKey().toByteArray());
        }
    }

    private static class Number480LongBinding
    extends TupleBinding<Number480Long> {
        private final TupleBinding<Number480> tupleBinding;

        private Number480LongBinding(TupleBinding<Number480> tupleBinding) {
            this.tupleBinding = tupleBinding;
        }

        public Number480Long entryToObject(TupleInput input) {
            long longValue = input.readLong();
            Number480 number480 = (Number480)this.tupleBinding.entryToObject(input);
            return new Number480Long(number480, longValue);
        }

        public void objectToEntry(Number480Long object, TupleOutput output) {
            output.writeLong(object.getLongValue().longValue());
            this.tupleBinding.objectToEntry((Object)object.getNumber480(), output);
        }
    }

    private static class Number160Number160Binding
    extends TupleBinding<Number160Number160> {
        private final TupleBinding<Number160> tupleBinding160;

        private Number160Number160Binding(TupleBinding<Number160> tupleBinding160) {
            this.tupleBinding160 = tupleBinding160;
        }

        public Number160Number160 entryToObject(TupleInput input) {
            Number160 numberKey = (Number160)this.tupleBinding160.entryToObject(input);
            Number160 numberPeerID = (Number160)this.tupleBinding160.entryToObject(input);
            return new Number160Number160(numberKey, numberPeerID);
        }

        public void objectToEntry(Number160Number160 object, TupleOutput output) {
            this.tupleBinding160.objectToEntry((Object)object.getNumberKey(), output);
            this.tupleBinding160.objectToEntry((Object)object.getNumberPeerID(), output);
        }
    }
}

