/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancellable;
import org.jboss.netty.util.internal.IoWorkerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFutureImpl
implements BaseFuture {
    private static final Logger logger = LoggerFactory.getLogger(BaseFutureImpl.class);
    private final ArrayList<BaseFutureListener<? extends BaseFuture>> listeners = new ArrayList(1);
    private final List<Cancellable> cancellables = new ArrayList<Cancellable>();
    protected boolean completed = false;
    protected BaseFuture.FutureType type = BaseFuture.FutureType.OK;
    protected final Object lock = this;
    protected String reason = "unknown";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                this.lock.wait();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture awaitUninterruptibly() {
        Object object = this.lock;
        synchronized (object) {
            this.checkDeadlock();
            while (!this.completed) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this;
        }
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("This should never ever happen.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean await0(long timeoutMillis, boolean interrupt) throws InterruptedException {
        long startTime = timeoutMillis <= 0L ? 0L : System.currentTimeMillis();
        long waitTime = timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                return this.completed;
            }
            if (waitTime <= 0L) {
                return this.completed;
            }
            this.checkDeadlock();
            do {
                block8: {
                    try {
                        this.lock.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        if (!interrupt) break block8;
                        throw e;
                    }
                }
                if (!this.completed) continue;
                return true;
            } while ((waitTime = timeoutMillis - (System.currentTimeMillis() - startTime)) > 0L);
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSuccess() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type == BaseFuture.FutureType.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFailed() {
        Object object = this.lock;
        synchronized (object) {
            return this.completed && this.type != BaseFuture.FutureType.OK;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFailed(String reason) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            logger.warn("set failed reason: " + reason);
            this.reason = reason;
            this.type = BaseFuture.FutureType.FAILED;
        }
        this.notifyListerenrs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFailedReason() {
        Object object = this.lock;
        synchronized (object) {
            return "complete=" + this.completed + "/" + this.reason + " type=" + (Object)((Object)this.type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture.FutureType getType() {
        Object object = this.lock;
        synchronized (object) {
            return this.type;
        }
    }

    protected boolean setCompletedAndNotify() {
        if (!this.completed) {
            this.completed = true;
            this.lock.notifyAll();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture addListener(BaseFutureListener<? extends BaseFuture> listener) {
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.completed) {
                notifyNow = true;
            } else {
                this.listeners.add(listener);
            }
        }
        if (notifyNow) {
            this.callOperationComplete(listener);
        }
        return this;
    }

    private void callOperationComplete(BaseFutureListener listener) {
        try {
            listener.operationComplete(this);
        }
        catch (Exception e) {
            try {
                listener.exceptionCaught(e);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void checkDeadlock() {
        String currentName = Thread.currentThread().getName();
        if (currentName.startsWith("Netty thread (non-blocking)/ ") || ((Boolean)IoWorkerRunnable.IN_IO_THREAD.get()).booleanValue()) {
            throw new IllegalStateException("await*() in Netty I/O thread causes a dead lock or sudden performance drop. Use addListener() instead or call await*() from a different thread.");
        }
    }

    protected void notifyListerenrs() {
        for (BaseFutureListener<? extends BaseFuture> listener : this.listeners) {
            this.callOperationComplete(listener);
        }
        this.listeners.clear();
        this.cancellables.clear();
    }

    private void cancelAll() {
        for (Cancellable cancellable : this.cancellables) {
            cancellable.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture removeListener(BaseFutureListener<? extends BaseFuture> listener) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.listeners.remove(listener);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture addCancellation(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.cancellables.add(cancellable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseFuture removeCancellation(Cancellable cancellable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.completed) {
                this.cancellables.remove(cancellable);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.setCompletedAndNotify()) {
                return;
            }
            this.type = BaseFuture.FutureType.CANCEL;
            this.reason = "canceled";
        }
        this.cancelAll();
        this.notifyListerenrs();
    }
}

