/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.DiscoverNetwork;

public class DiscoverNetwork6
implements DiscoverNetwork {
    private Bindings bindings;

    @Override
    public void init(Bindings bindings) {
        this.bindings = bindings;
    }

    @Override
    public StringBuilder discoverNetwork(NetworkInterface networkInterface) {
        StringBuilder sb = new StringBuilder();
        for (InterfaceAddress iface : networkInterface.getInterfaceAddresses()) {
            InetAddress inet = iface.getAddress();
            if (this.bindings.getAddresses().contains(inet)) continue;
            if (iface.getBroadcast() != null) {
                this.bindings.addBroadcastAddress(iface.getBroadcast());
            }
            if (this.bindings.useAllProtocols()) {
                sb.append(",All:").append(inet);
                this.bindings.addAddress(inet);
                continue;
            }
            if (inet instanceof Inet4Address && this.bindings.getProtocols().contains((Object)Bindings.Protocol.IPv4)) {
                sb.append(",IPv4:").append(inet);
                this.bindings.addAddress(inet);
            }
            if (!(inet instanceof Inet6Address) || !this.bindings.getProtocols().contains((Object)Bindings.Protocol.IPv6)) continue;
            sb.append(",IPv6:").append(inet);
            this.bindings.addAddress(inet);
        }
        return sb.replace(0, 1, "(").append(")");
    }
}

