/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlerTCP {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlerTCP.class);
    private final FutureResponse futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final MessageID sendMessageID;

    public RequestHandlerTCP(PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this(new FutureResponse(message), peerBean, connectionBean, message);
    }

    public RequestHandlerTCP(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = message;
        this.sendMessageID = new MessageID(message);
    }

    public FutureResponse getFutureResponse() {
        return this.futureResponse;
    }

    public FutureResponse sendTCP() {
        this.connectionBean.getSender().sendTCP(this.message, this);
        return this.futureResponse;
    }

    public FutureResponse sendTCP(String channelName) {
        this.connectionBean.getSender().sendTCP(channelName, this.message, this);
        return this.futureResponse;
    }

    public FutureResponse fireAndForgetTCP() {
        this.message.setFireAndForget(true);
        this.connectionBean.getSender().sendTCP(this.message, this);
        return this.futureResponse;
    }

    protected PeerMap getPeerMap() {
        return this.peerBean.getPeerMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(Message message) throws PeerException {
        try {
            MessageID recvMessageID = new MessageID(message);
            if (message.getType() == Message.Type.UNKNOWN_ID) {
                String msg = "Message was not delivered successfully: " + this.message;
                this.futureResponse.setFailed(msg);
                this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), true);
                throw new PeerException(PeerException.AbortCause.PEER_ABORT, msg);
            }
            if (message.getType() == Message.Type.EXCEPTION) {
                String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
                this.futureResponse.setFailed(msg);
                throw new PeerException(PeerException.AbortCause.PEER_ABORT, msg);
            }
            if (!this.sendMessageID.equals(recvMessageID)) {
                String msg = "Message [" + message + "] sent to the node is not the same as we expect. We sent [" + this.message + "]";
                if (logger.isWarnEnabled()) {
                    logger.warn(msg);
                }
                this.futureResponse.setFailed(msg);
                throw new PeerException(PeerException.AbortCause.PEER_ABORT, msg);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("perfect: " + message);
            }
            if (message.isOk() || message.isNotOk()) {
                this.getPeerMap().peerOnline(message.getSender(), null);
            }
            this.futureResponse.setResponse(message);
        }
        finally {
            this.futureResponse.setFailed("very unexpected exception...");
        }
    }
}

