/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

public class SimpleBloomFilter<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 3527833617516722215L;
    private final int k;
    private final BitSet bitSet;
    private final int bitArraySize;
    private final int expectedElements;

    public SimpleBloomFilter(int bitArraySize, int expectedElements) {
        this(bitArraySize, expectedElements, new BitSet(bitArraySize));
    }

    public SimpleBloomFilter(byte[] rawBitArray) {
        this(rawBitArray, 0, rawBitArray.length);
    }

    public SimpleBloomFilter(byte[] rawBitArray, int offset, int length) {
        this(SimpleBloomFilter.byteArrayToInt(rawBitArray, 4), SimpleBloomFilter.byteArrayToInt(rawBitArray, 0), SimpleBloomFilter.fromByteArray(new BitSet(), rawBitArray, offset + 8, length - 8));
    }

    public SimpleBloomFilter(int bitArraySize, int expectedElements, BitSet bitSet) {
        if (bitArraySize % 8 != 0) {
            throw new RuntimeException("BitArraySize must be a multiple of 8");
        }
        this.bitArraySize = bitArraySize;
        this.expectedElements = expectedElements;
        this.k = (int)Math.ceil((double)(bitArraySize / expectedElements) * Math.log(2.0));
        this.bitSet = bitSet;
    }

    public double expectedFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * (double)this.expectedElements / (double)this.bitArraySize), this.k);
    }

    public int getExpectedElements() {
        return this.expectedElements;
    }

    @Override
    public boolean add(E o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            this.bitSet.set(r.nextInt(this.bitArraySize), true);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E o : c) {
            this.add(o);
        }
        return false;
    }

    @Override
    public void clear() {
        for (int x = 0; x < this.bitSet.length(); ++x) {
            this.bitSet.set(x, false);
        }
    }

    @Override
    public boolean contains(Object o) {
        Random r = new Random(o.hashCode());
        for (int x = 0; x < this.k; ++x) {
            if (this.bitSet.get(r.nextInt(this.bitArraySize))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    public BitSet getBitSet() {
        return this.bitSet;
    }

    private static BitSet fromByteArray(BitSet bits, byte[] bytes, int offset, int length) {
        for (int i = 0; i < length * 8; ++i) {
            if ((bytes[offset + (length - i / 8 - 1)] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public byte[] toByteArray() {
        if (this.bitSet.length() == 0) {
            return SimpleBloomFilter.intToByteArray(this.expectedElements, this.bitArraySize, new byte[8]);
        }
        int length = this.bitSet.length() / 8 + 1;
        byte[] bytes = new byte[8 + length];
        SimpleBloomFilter.intToByteArray(this.expectedElements, this.bitArraySize, bytes);
        for (int i = 0; i < this.bitSet.length(); ++i) {
            if (!this.bitSet.get(i)) continue;
            int n = 8 + (length - i / 8 - 1);
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public static final byte[] intToByteArray(int value1, int value2, byte[] me) {
        me[0] = (byte)(value1 >>> 24);
        me[1] = (byte)(value1 >>> 16);
        me[2] = (byte)(value1 >>> 8);
        me[3] = (byte)value1;
        me[4] = (byte)(value2 >>> 24);
        me[5] = (byte)(value2 >>> 16);
        me[6] = (byte)(value2 >>> 8);
        me[7] = (byte)value2;
        return me;
    }

    public static final int byteArrayToInt(byte[] me, int offset) {
        return (me[0 + offset] << 24) + ((me[1 + offset] & 0xFF) << 16) + ((me[2 + offset] & 0xFF) << 8) + (me[3 + offset] & 0xFF);
    }
}

