/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import net.tomp2p.peers.Number160;

public final class PeerAddress
implements Comparable<PeerAddress>,
Serializable {
    private static final int NET6 = 1;
    private static final int FIREWALL_UDP = 2;
    private static final int FIREWALL_TCP = 4;
    private static final long serialVersionUID = -1316622724169272306L;
    private final Number160 id;
    private final InetAddress address;
    private final int portUDP;
    private final int portTCP;
    private final boolean net6;
    private final boolean firewalledUDP;
    private final boolean firewalledTCP;
    private final int hashCode;
    private final int offset;
    private final int readBytes;
    public static final int SIZE_IP_SOCKv6 = 21;
    public static final int SIZE_IP_SOCKv4 = 9;
    public static final int SIZE_IPv6 = 41;
    public static final int SIZE_IPv4 = 29;

    public PeerAddress(byte[] me) throws UnknownHostException {
        this(me, 0);
    }

    public PeerAddress(byte[] me, int offset) throws UnknownHostException {
        int offsetOld = offset;
        byte[] tmp = new byte[20];
        System.arraycopy(me, offset, tmp, 0, 20);
        this.id = new Number160(tmp);
        int types = me[offset += 20] & 0xFF;
        this.net6 = (types & 1) > 0;
        this.firewalledUDP = (types & 2) > 0;
        this.firewalledTCP = (types & 4) > 0;
        this.portTCP = ((me[++offset] & 0xFF) << 8) + (me[offset + 1] & 0xFF);
        this.portUDP = ((me[offset + 2] & 0xFF) << 8) + (me[offset + 3] & 0xFF);
        offset += 4;
        if (this.isIPv4()) {
            byte[] tmp2 = new byte[4];
            System.arraycopy(me, offset, tmp2, 0, 4);
            this.address = Inet4Address.getByAddress(tmp2);
            offset += 4;
        } else {
            byte[] tmp2 = new byte[16];
            System.arraycopy(me, offset, tmp2, 0, 16);
            this.address = Inet6Address.getByAddress(tmp2);
            offset += 16;
        }
        this.readBytes = offset - offsetOld;
        this.offset = offset;
        this.hashCode = this.id.hashCode();
    }

    public PeerAddress(byte[] peerAddress, byte[] socketAddress) throws UnknownHostException {
        int offsetPeerAddress = 0;
        int offsetSocketAddress = 0;
        int types = socketAddress[offsetSocketAddress] & 0xFF;
        this.net6 = (types & 1) > 0;
        this.firewalledUDP = (types & 2) > 0;
        this.firewalledTCP = (types & 4) > 0;
        byte[] tmp = new byte[20];
        System.arraycopy(peerAddress, offsetPeerAddress, tmp, 0, 20);
        this.id = new Number160(tmp);
        offsetPeerAddress += 20;
        this.portTCP = ((socketAddress[++offsetSocketAddress] & 0xFF) << 8) + (socketAddress[offsetSocketAddress + 1] & 0xFF);
        this.portUDP = ((socketAddress[offsetSocketAddress + 2] & 0xFF) << 8) + (socketAddress[offsetSocketAddress + 3] & 0xFF);
        offsetSocketAddress += 4;
        if (this.isIPv4()) {
            tmp = new byte[4];
            System.arraycopy(socketAddress, offsetSocketAddress, tmp, 0, 4);
            this.address = Inet4Address.getByAddress(tmp);
            offsetSocketAddress += 4;
        } else {
            tmp = new byte[16];
            System.arraycopy(socketAddress, offsetSocketAddress, tmp, 0, 16);
            this.address = Inet6Address.getByAddress(tmp);
            offsetSocketAddress += 16;
        }
        this.readBytes = this.offset = offsetSocketAddress + offsetPeerAddress;
        this.hashCode = this.id.hashCode();
    }

    public PeerAddress(Number160 id) {
        this(id, null, -1, -1);
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP, boolean firewalledUDP, boolean firewalledTCP) {
        this.id = id;
        this.address = address;
        this.portTCP = portTCP;
        this.portUDP = portUDP;
        this.hashCode = id.hashCode();
        this.net6 = address instanceof Inet6Address;
        this.firewalledUDP = firewalledUDP;
        this.firewalledTCP = firewalledTCP;
        this.offset = -1;
        this.readBytes = -1;
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP) {
        this(id, address, portTCP, portUDP, false, false);
    }

    public PeerAddress(Number160 id, InetSocketAddress inetSocketAddress) {
        this(id, inetSocketAddress.getAddress(), inetSocketAddress.getPort(), inetSocketAddress.getPort());
    }

    public PeerAddress(Number160 id, PeerAddress parent) {
        this(id, parent.address, parent.portTCP, parent.portUDP);
    }

    public PeerAddress(Number160 id, InetAddress address, int portTCP, int portUDP, byte optionType) {
        this(id, address, portTCP, portUDP, PeerAddress.isFirewalledUDP(optionType), PeerAddress.isFirewalledTCP(optionType));
    }

    public int offset() {
        return this.offset;
    }

    public int readBytes() {
        return this.readBytes;
    }

    public byte[] toByteArray() {
        byte[] me = this.address instanceof Inet4Address ? new byte[29] : new byte[41];
        this.toByteArray(me, 0);
        return me;
    }

    public int toByteArray(byte[] me, int offset) {
        int newOffset = this.id.toByteArray(me, offset);
        return this.toByteArraySocketAddress(me, newOffset);
    }

    @Deprecated
    public byte[] getSocketAddress() {
        return this.toByteArraySocketAddress();
    }

    public byte[] toByteArraySocketAddress() {
        byte[] me = new byte[this.getSocketAddressSize()];
        this.getSocketAddress(me, 0);
        return me;
    }

    @Deprecated
    public int getSocketAddress(byte[] me, int offset) {
        return this.toByteArraySocketAddress(me, offset);
    }

    public int toByteArraySocketAddress(byte[] me, int offset) {
        me[offset] = this.createType();
        int delta = 1;
        int tmp = offset + delta;
        me[tmp + 0] = (byte)(this.portTCP >>> 8);
        me[tmp + 1] = (byte)this.portTCP;
        me[tmp + 2] = (byte)(this.portUDP >>> 8);
        me[tmp + 3] = (byte)this.portUDP;
        delta += 4;
        if (this.address instanceof Inet4Address) {
            System.arraycopy(this.address.getAddress(), 0, me, offset + delta, 4);
            delta += 4;
        } else {
            System.arraycopy(this.address.getAddress(), 0, me, offset + delta, 16);
            delta += 16;
        }
        return offset + delta;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public InetSocketAddress createSocketTCP() {
        return new InetSocketAddress(this.address, this.portTCP);
    }

    public InetSocketAddress createSocketUDP() {
        return new InetSocketAddress(this.address, this.portUDP);
    }

    public Number160 getID() {
        return this.id;
    }

    public byte createType() {
        byte result = 0;
        if (this.net6) {
            result = (byte)(result | 1);
        }
        if (this.firewalledUDP) {
            result = (byte)(result | 2);
        }
        if (this.firewalledTCP) {
            result = (byte)(result | 4);
        }
        return result;
    }

    public static boolean isNet6(int type) {
        return (type & 0xFF & 1) > 0;
    }

    public static boolean isFirewalledTCP(int type) {
        return (type & 0xFF & 4) > 0;
    }

    public static boolean isFirewalledUDP(int type) {
        return (type & 0xFF & 2) > 0;
    }

    public static int expectedLength(int type) {
        if (PeerAddress.isNet6(type)) {
            return 41;
        }
        return 29;
    }

    public int expectedLength() {
        return this.isIPv6() ? 41 : 29;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PeerAddr[");
        return sb.append(this.address).append(",udp:").append(this.portUDP).append(",tcp:").append(this.portTCP).append(",ID:").append(this.id.toString()).append("]").toString();
    }

    @Override
    public int compareTo(PeerAddress nodeAddress) {
        return this.id.compareTo(nodeAddress.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PeerAddress) {
            return this.id.equals(((PeerAddress)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int portTCP() {
        return this.portTCP;
    }

    public int portUDP() {
        return this.portUDP;
    }

    public boolean isFirewalledUDP() {
        return this.firewalledUDP;
    }

    public boolean isFirewalledTCP() {
        return this.firewalledTCP;
    }

    public boolean isIPv6() {
        return this.net6;
    }

    public boolean isIPv4() {
        return !this.net6;
    }

    public PeerAddress notFirewalledUDP() {
        return new PeerAddress(this.id, this.address, this.portTCP, this.portUDP, false, this.firewalledTCP);
    }

    public PeerAddress notFirewalledTCP() {
        return new PeerAddress(this.id, this.address, this.portTCP, this.portUDP, this.firewalledUDP, false);
    }

    public PeerAddress ports(int portUDP, int portTCP) {
        return new PeerAddress(this.id, this.address, portTCP, portUDP, this.firewalledUDP, this.firewalledTCP);
    }

    public int getSocketAddressSize() {
        return this.address instanceof Inet4Address ? 9 : 21;
    }

    public PeerAddress copyWithDifferentId(Number160 id2) {
        return new PeerAddress(id2, this.address, this.portTCP, this.portUDP, this.firewalledUDP, this.firewalledTCP);
    }
}

