/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Utils;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class IrcDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(IrcDiscovery.class);
    private String channel;
    private int port = 6667;
    private String server;
    private BufferedWriter writer = null;
    private Socket connection;

    public IrcDiscovery(String channel) {
        this(channel, "irc.lfnet.org", 6667);
    }

    public IrcDiscovery(String channel, String server, int port) {
        this.channel = channel;
        this.server = server;
        this.port = port;
    }

    protected void onIRCSend(String message) {
    }

    protected void onIRCReceive(String message) {
    }

    @Override
    public void shutdown() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        this.connection = null;
        BufferedReader reader = null;
        try {
            String currLine;
            int ipCursorStart;
            InetAddress[] ips = InetAddress.getAllByName(this.server);
            int ipCursor = ipCursorStart = (int)(Math.random() * (double)ips.length);
            do {
                this.connection = new Socket();
                int timeoutMsec = (int)TimeUnit.MILLISECONDS.convert(timeoutValue, timeoutUnit);
                this.connection.setSoTimeout(timeoutMsec);
                try {
                    InetAddress ip = ips[ipCursor];
                    log.info("Connecting to IRC with " + ip);
                    this.connection.connect(new InetSocketAddress(ip, this.port), timeoutMsec);
                }
                catch (SocketTimeoutException e) {
                    this.connection = null;
                }
                catch (IOException e) {
                    this.connection = null;
                }
                ipCursor = (ipCursor + 1) % ips.length;
                if (ipCursor != ipCursorStart) continue;
                throw new PeerDiscoveryException("Could not connect to " + this.server);
            } while (this.connection == null);
            this.writer = new BufferedWriter(new OutputStreamWriter(this.connection.getOutputStream(), "UTF-8"));
            reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            String nickRnd = String.format("bcj%d", new Random().nextInt(Integer.MAX_VALUE));
            String command = "NICK " + nickRnd;
            this.logAndSend(command);
            command = "USER " + nickRnd + " 8 *: " + nickRnd;
            this.logAndSend(command);
            this.writer.flush();
            while ((currLine = reader.readLine()) != null) {
                this.onIRCReceive(currLine);
                if (!IrcDiscovery.checkLineStatus("004", currLine)) continue;
            }
            this.logAndSend("JOIN " + this.channel);
            this.logAndSend("NAMES " + this.channel);
            this.writer.flush();
            while ((currLine = reader.readLine()) != null) {
                this.onIRCReceive(currLine);
                if (IrcDiscovery.checkLineStatus("353", currLine)) {
                    int subIndex = 0;
                    if (currLine.startsWith(":")) {
                        subIndex = 1;
                    }
                    String spacedList = currLine.substring(currLine.indexOf(":", subIndex));
                    addresses.addAll(IrcDiscovery.parseUserList(spacedList.substring(1).split(" ")));
                    continue;
                }
                if (!IrcDiscovery.checkLineStatus("366", currLine)) continue;
            }
            this.logAndSend("PART " + this.channel);
            this.logAndSend("QUIT");
            this.writer.flush();
        }
        catch (Exception e) {
            throw new PeerDiscoveryException(e.getMessage(), e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (IOException e) {
                log.warn("Exception whilst closing IRC discovery: " + e.toString());
            }
        }
        return addresses.toArray(new InetSocketAddress[addresses.size()]);
    }

    private void logAndSend(String command) throws Exception {
        this.onIRCSend(command);
        this.writer.write(command + "\n");
    }

    static ArrayList<InetSocketAddress> parseUserList(String[] userNames) throws UnknownHostException {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String user : userNames) {
            InetAddress ip;
            byte[] addressBytes;
            if (!user.startsWith("u")) continue;
            try {
                addressBytes = Base58.decodeChecked(user.substring(1));
            }
            catch (AddressFormatException e) {
                log.warn("IRC nick does not parse as base58: " + user);
                continue;
            }
            if (addressBytes.length != 6) continue;
            byte[] ipBytes = new byte[]{addressBytes[0], addressBytes[1], addressBytes[2], addressBytes[3]};
            int port = Utils.readUint16BE(addressBytes, 4);
            try {
                ip = InetAddress.getByAddress(ipBytes);
            }
            catch (UnknownHostException e) {
                continue;
            }
            InetSocketAddress address = new InetSocketAddress(ip, port);
            addresses.add(address);
        }
        return addresses;
    }

    private static boolean checkLineStatus(String statusCode, String response) {
        if (response.startsWith(":")) {
            int startIndex = response.indexOf(" ") + 1;
            return response.indexOf(statusCode + " ", startIndex) == startIndex;
        }
        return response.startsWith(statusCode + " ");
    }
}

