/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.net.discovery.MultiplexingDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.utils.DaemonThreadFactory;

public class DnsDiscovery
extends MultiplexingDiscovery {
    public DnsDiscovery(NetworkParameters netParams) {
        this(netParams.getDnsSeeds(), netParams);
    }

    public DnsDiscovery(String[] dnsSeeds, NetworkParameters params) {
        super(params, DnsDiscovery.buildDiscoveries(params, dnsSeeds));
    }

    private static List<PeerDiscovery> buildDiscoveries(NetworkParameters params, String[] seeds) {
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>();
        if (seeds != null) {
            for (String seed : seeds) {
                discoveries.add(new DnsSeedDiscovery(params, seed));
            }
        }
        return discoveries;
    }

    @Override
    protected ExecutorService createExecutor() {
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            return Executors.newSingleThreadExecutor(new ContextPropagatingThreadFactory("DNS seed lookups"));
        }
        return Executors.newFixedThreadPool(this.seeds.size(), new DaemonThreadFactory("DNS seed lookups"));
    }

    public static class DnsSeedDiscovery
    implements PeerDiscovery {
        private final String hostname;
        private final NetworkParameters params;

        public DnsSeedDiscovery(NetworkParameters params, String hostname) {
            this.hostname = hostname;
            this.params = params;
        }

        @Override
        public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
            try {
                InetAddress[] response = InetAddress.getAllByName(this.hostname);
                InetSocketAddress[] result = new InetSocketAddress[response.length];
                for (int i = 0; i < response.length; ++i) {
                    result[i] = new InetSocketAddress(response[i], this.params.getPort());
                }
                return result;
            }
            catch (UnknownHostException e) {
                throw new PeerDiscoveryException(e);
            }
        }

        @Override
        public void shutdown() {
        }

        public String toString() {
            return this.hostname;
        }
    }
}

