/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import javax.annotation.Nullable;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.net.ProtobufParser;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;

public abstract class ServerConnectionEventHandler {
    private ProtobufParser<Protos.TwoWayChannelMessage> connectionChannel;

    synchronized void setConnectionChannel(@Nullable ProtobufParser<Protos.TwoWayChannelMessage> connectionChannel) {
        this.connectionChannel = connectionChannel;
    }

    protected final synchronized void closeChannel() {
        if (this.connectionChannel == null) {
            throw new IllegalStateException("Channel is not fully initialized/has already been closed");
        }
        this.connectionChannel.write(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CLOSE).build());
        this.connectionChannel.closeConnection();
    }

    public abstract void channelOpen(Sha256Hash var1);

    @Nullable
    public abstract ListenableFuture<ByteString> paymentIncrease(Coin var1, Coin var2, ByteString var3);

    public abstract void channelClosed(PaymentChannelCloseException.CloseReason var1);
}

