/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.net.NioServer;
import org.bitcoinj.net.ProtobufParser;
import org.bitcoinj.net.StreamParserFactory;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentChannelServer;
import org.bitcoinj.protocols.channels.ServerConnectionEventHandler;

public class PaymentChannelServerListener {
    private final Wallet wallet;
    private final TransactionBroadcaster broadcaster;
    private final HandlerFactory eventHandlerFactory;
    private final Coin minAcceptedChannelSize;
    private NioServer server;
    private final int timeoutSeconds;

    public void bindAndStart(int port) throws Exception {
        this.server = new NioServer(new StreamParserFactory(){

            @Override
            public ProtobufParser<Protos.TwoWayChannelMessage> getNewParser(InetAddress inetAddress, int port) {
                return new ServerHandler(new InetSocketAddress(inetAddress, port), PaymentChannelServerListener.this.timeoutSeconds).socketProtobufHandler;
            }
        }, new InetSocketAddress(port));
        this.server.startAsync();
        this.server.awaitRunning();
    }

    public PaymentChannelServerListener(TransactionBroadcaster broadcaster, Wallet wallet, int timeoutSeconds, Coin minAcceptedChannelSize, HandlerFactory eventHandlerFactory) throws IOException {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.broadcaster = (TransactionBroadcaster)Preconditions.checkNotNull((Object)broadcaster);
        this.eventHandlerFactory = (HandlerFactory)Preconditions.checkNotNull((Object)eventHandlerFactory);
        this.minAcceptedChannelSize = (Coin)Preconditions.checkNotNull((Object)minAcceptedChannelSize);
        this.timeoutSeconds = timeoutSeconds;
    }

    public void close() {
        this.server.stopAsync();
        this.server.awaitTerminated();
    }

    private class ServerHandler {
        private PaymentChannelCloseException.CloseReason closeReason;
        private ServerConnectionEventHandler eventHandler;
        private final PaymentChannelServer paymentChannelManager;
        private final ProtobufParser<Protos.TwoWayChannelMessage> socketProtobufHandler;
        private final ProtobufParser.Listener<Protos.TwoWayChannelMessage> protobufHandlerListener;

        public ServerHandler(final SocketAddress address, int timeoutSeconds) {
            this.paymentChannelManager = new PaymentChannelServer(PaymentChannelServerListener.this.broadcaster, PaymentChannelServerListener.this.wallet, PaymentChannelServerListener.this.minAcceptedChannelSize, new PaymentChannelServer.ServerConnection(){

                @Override
                public void sendToClient(Protos.TwoWayChannelMessage msg) {
                    ServerHandler.this.socketProtobufHandler.write(msg);
                }

                @Override
                public void destroyConnection(PaymentChannelCloseException.CloseReason reason) {
                    if (ServerHandler.this.closeReason != null) {
                        ServerHandler.this.closeReason = reason;
                    }
                    ServerHandler.this.socketProtobufHandler.closeConnection();
                }

                @Override
                public void channelOpen(Sha256Hash contractHash) {
                    ServerHandler.this.socketProtobufHandler.setSocketTimeout(0);
                    ServerHandler.this.eventHandler.channelOpen(contractHash);
                }

                @Override
                public ListenableFuture<ByteString> paymentIncrease(Coin by, Coin to, @Nullable ByteString info) {
                    return ServerHandler.this.eventHandler.paymentIncrease(by, to, info);
                }
            });
            this.protobufHandlerListener = new ProtobufParser.Listener<Protos.TwoWayChannelMessage>(){

                @Override
                public synchronized void messageReceived(ProtobufParser<Protos.TwoWayChannelMessage> handler, Protos.TwoWayChannelMessage msg) {
                    ServerHandler.this.paymentChannelManager.receiveMessage(msg);
                }

                @Override
                public synchronized void connectionClosed(ProtobufParser<Protos.TwoWayChannelMessage> handler) {
                    ServerHandler.this.paymentChannelManager.connectionClosed();
                    if (ServerHandler.this.closeReason != null) {
                        ServerHandler.this.eventHandler.channelClosed(ServerHandler.this.closeReason);
                    } else {
                        ServerHandler.this.eventHandler.channelClosed(PaymentChannelCloseException.CloseReason.CONNECTION_CLOSED);
                    }
                    ServerHandler.this.eventHandler.setConnectionChannel(null);
                }

                @Override
                public synchronized void connectionOpen(ProtobufParser<Protos.TwoWayChannelMessage> handler) {
                    ServerConnectionEventHandler eventHandler = PaymentChannelServerListener.this.eventHandlerFactory.onNewConnection(address);
                    if (eventHandler == null) {
                        handler.closeConnection();
                    } else {
                        ServerHandler.this.eventHandler = eventHandler;
                        ServerHandler.this.paymentChannelManager.connectionOpen();
                    }
                }
            };
            this.socketProtobufHandler = new ProtobufParser<Protos.TwoWayChannelMessage>(this.protobufHandlerListener, Protos.TwoWayChannelMessage.getDefaultInstance(), Short.MAX_VALUE, timeoutSeconds * 1000);
        }
    }

    public static interface HandlerFactory {
        @Nullable
        public ServerConnectionEventHandler onNewConnection(SocketAddress var1);
    }
}

