/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.TxConfidenceTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private TxConfidenceTable confidenceTable = new TxConfidenceTable();
    private NetworkParameters params;
    private int eventHorizon = 100;
    private static volatile Context lastConstructed;
    private static final ThreadLocal<Context> slot;

    public Context(NetworkParameters params) {
        this.params = params;
        lastConstructed = this;
        slot.set(this);
    }

    public Context(NetworkParameters params, int eventHorizon) {
        this(params);
        this.eventHorizon = eventHorizon;
    }

    public static Context get() {
        Context tls = slot.get();
        if (tls == null) {
            if (lastConstructed == null) {
                throw new IllegalStateException("You must construct a Context object before using bitcoinj!");
            }
            slot.set(lastConstructed);
            log.error("Performing thread fixup: you are accessing bitcoinj via a thread that has not had any context set on it.");
            log.error("This error has been corrected for, but doing this makes your app less robust.");
            log.error("You should use Context.propagate() or a ContextPropagatingThreadFactory.");
            log.error("Please refer to the user guide for more information about this.");
            return lastConstructed;
        }
        return tls;
    }

    public static Context getOrCreate(NetworkParameters params) {
        Context context;
        try {
            context = Context.get();
        }
        catch (IllegalStateException e) {
            log.warn("Implicitly creating context. This is a migration step and this message will eventually go away.");
            Context context2 = new Context(params);
            return context2;
        }
        if (context.getParams() != params) {
            throw new IllegalStateException("Context does not match implicit network params: " + context.getParams() + " vs " + params);
        }
        return context;
    }

    public static void propagate(Context context) {
        slot.set((Context)Preconditions.checkNotNull((Object)context));
    }

    public TxConfidenceTable getConfidenceTable() {
        return this.confidenceTable;
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    public int getEventHorizon() {
        return this.eventHorizon;
    }

    static {
        slot = new ThreadLocal();
    }
}

